/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.image;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.isxander.yacl3.gui.image.ImageRenderer;
import dev.isxander.yacl3.gui.image.ImageRendererFactory;
import dev.isxander.yacl3.impl.utils.YACLConstants;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_2960;

public class ImageRendererManager {
    private static final ExecutorService SINGLE_THREAD_EXECUTOR = Executors.newSingleThreadExecutor(task -> new Thread(task, "YACL Image Prep"));
    private static final Map<class_2960, CompletableFuture<ImageRenderer>> IMAGE_CACHE = new ConcurrentHashMap<class_2960, CompletableFuture<ImageRenderer>>();
    private static final Queue<FactoryIDPair<?>> CREATION_QUEUE = new ConcurrentLinkedQueue();

    public static <T extends ImageRenderer> CompletableFuture<T> registerImage(class_2960 id, ImageRendererFactory<T> factory) {
        if (IMAGE_CACHE.containsKey(id)) {
            return IMAGE_CACHE.get(id);
        }
        SINGLE_THREAD_EXECUTOR.submit(() -> {
            try {
                ImageRendererFactory.ImageSupplier supplier = factory.prepareImage();
                CREATION_QUEUE.add(new FactoryIDPair(id, supplier));
            }
            catch (Exception e) {
                YACLConstants.LOGGER.error("Failed to prepare image '{}'", (Object)id, (Object)e);
                IMAGE_CACHE.remove(id);
            }
        });
        CompletableFuture future = new CompletableFuture();
        IMAGE_CACHE.put(id, future);
        return future;
    }

    public static void pollImageFactories() {
        RenderSystem.assertOnRenderThread();
        while (!CREATION_QUEUE.isEmpty()) {
            Object image;
            FactoryIDPair<?> pair = CREATION_QUEUE.poll();
            if (!IMAGE_CACHE.containsKey(pair.id())) {
                YACLConstants.LOGGER.error("Tried to finalise image '{}' but it was not found in cache.", (Object)pair.id());
                continue;
            }
            try {
                image = pair.supplier().completeImage();
            }
            catch (Exception e) {
                YACLConstants.LOGGER.error("Failed to create image '{}'", (Object)pair.id(), (Object)e);
                continue;
            }
            CompletableFuture<ImageRenderer> future = IMAGE_CACHE.get(pair.id());
            if (future.isDone()) {
                YACLConstants.LOGGER.error("Image '{}' was already completed", (Object)pair.id());
                continue;
            }
            future.complete((ImageRenderer)image);
        }
    }

    public static void closeAll() {
        SINGLE_THREAD_EXECUTOR.shutdownNow();
        CREATION_QUEUE.clear();
        IMAGE_CACHE.values().forEach(future -> {
            if (future.isDone()) {
                ((ImageRenderer)future.join()).close();
            }
        });
        IMAGE_CACHE.clear();
    }

    private record FactoryIDPair<T extends ImageRenderer>(class_2960 id, ImageRendererFactory.ImageSupplier<T> supplier) {
    }
}

