/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.resource;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import me.pepperbell.continuity.api.client.CTMLoader;
import me.pepperbell.continuity.api.client.CTMLoaderRegistry;
import me.pepperbell.continuity.api.client.CTMProperties;
import me.pepperbell.continuity.api.client.CachingPredicates;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.model.QuadProcessors;
import me.pepperbell.continuity.client.resource.InvalidIdentifierStateHolder;
import me.pepperbell.continuity.client.util.BooleanState;
import me.pepperbell.continuity.client.util.biome.BiomeHolderManager;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_4730;
import org.jetbrains.annotations.NotNull;

public final class CTMPropertiesLoader {
    public static LoadingResult loadAllWithState(class_3300 resourceManager) {
        BiomeHolderManager.clearCache();
        LoadingResult result = CTMPropertiesLoader.loadAll(resourceManager);
        BiomeHolderManager.refreshHolders();
        return result;
    }

    public static LoadingResult loadAll(class_3300 resourceManager) {
        ObjectArrayList containers = new ObjectArrayList();
        Object2ObjectOpenHashMap textureDependencies = new Object2ObjectOpenHashMap();
        LoadingResult result = new LoadingResult((List<LoadingContainer<?>>)containers, (Map<class_2960, Set<class_2960>>)textureDependencies);
        int packPriority = 0;
        Iterator iterator = resourceManager.method_29213().iterator();
        BooleanState invalidIdentifierState = InvalidIdentifierStateHolder.get();
        invalidIdentifierState.enable();
        while (iterator.hasNext()) {
            class_3262 pack = (class_3262)iterator.next();
            CTMPropertiesLoader.loadAll(pack, packPriority, resourceManager, result);
            ++packPriority;
        }
        invalidIdentifierState.disable();
        containers.sort(Comparator.reverseOrder());
        return result;
    }

    private static void loadAll(class_3262 pack, int packPriority, class_3300 resourceManager, LoadingResult result) {
        for (String namespace : pack.method_14406(class_3264.field_14188)) {
            pack.method_14408(class_3264.field_14188, namespace, "optifine/ctm", (id, inputSupplier) -> {
                if (id.method_12832().endsWith(".properties")) {
                    try (InputStream stream = (InputStream)inputSupplier.get();){
                        Properties properties = new Properties();
                        properties.load(stream);
                        CTMPropertiesLoader.load(properties, id, pack, packPriority, resourceManager, result);
                    }
                    catch (Exception e) {
                        ContinuityClient.LOGGER.error("Failed to load CTM properties from file '" + id + "' in pack '" + pack.method_14409() + "'", (Throwable)e);
                    }
                }
            });
        }
    }

    private static void load(Properties properties, class_2960 id, class_3262 pack, int packPriority, class_3300 resourceManager, LoadingResult result) {
        String method = properties.getProperty("method", "ctm").trim();
        CTMLoader<?> loader = CTMLoaderRegistry.get().getLoader(method);
        if (loader != null) {
            CTMPropertiesLoader.load(loader, properties, id, pack, packPriority, resourceManager, method, result);
        } else {
            ContinuityClient.LOGGER.error("Unknown 'method' value '" + method + "' in file '" + id + "' in pack '" + pack.method_14409() + "'");
        }
    }

    private static <T extends CTMProperties> void load(CTMLoader<T> loader, Properties properties, class_2960 id, class_3262 pack, int packPriority, class_3300 resourceManager, String method, LoadingResult result) {
        T ctmProperties = loader.getPropertiesFactory().createProperties(properties, id, pack, packPriority, resourceManager, method);
        if (ctmProperties != null) {
            LoadingContainer<T> container = new LoadingContainer<T>(loader, ctmProperties);
            result.containers().add(container);
            for (class_4730 spriteId : ctmProperties.getTextureDependencies()) {
                Set atlasTextureDependencies = result.textureDependencies().computeIfAbsent(spriteId.method_24144(), id1 -> new ObjectOpenHashSet());
                atlasTextureDependencies.add(spriteId.method_24147());
            }
        }
    }

    public static List<QuadProcessors.ProcessorHolder> createProcessorHolders(List<LoadingContainer<?>> containers, Function<class_4730, class_1058> textureGetter) {
        ObjectArrayList processorHolders = new ObjectArrayList();
        for (LoadingContainer<?> container : containers) {
            processorHolders.add(container.toProcessorHolder(textureGetter));
        }
        return processorHolders;
    }

    public record LoadingResult(List<LoadingContainer<?>> containers, Map<class_2960, Set<class_2960>> textureDependencies) {
    }

    public record LoadingContainer<T extends CTMProperties>(CTMLoader<T> loader, T properties) implements Comparable<LoadingContainer<?>>
    {
        public QuadProcessors.ProcessorHolder toProcessorHolder(Function<class_4730, class_1058> textureGetter) {
            QuadProcessor processor = this.loader.getProcessorFactory().createProcessor(this.properties, textureGetter);
            CachingPredicates predicates = this.loader.getPredicatesFactory().createPredicates(this.properties, textureGetter);
            return new QuadProcessors.ProcessorHolder(processor, predicates);
        }

        @Override
        public int compareTo(@NotNull LoadingContainer<?> o) {
            return this.properties.compareTo(o.properties);
        }
    }
}

