/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor.overlay;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.ProcessingDataProvider;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.processor.AbstractQuadProcessor;
import me.pepperbell.continuity.client.processor.AbstractQuadProcessorFactory;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.processor.DirectionMaps;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.processor.overlay.OverlayProcessingPredicate;
import me.pepperbell.continuity.client.properties.overlay.OverlayPropertiesSection;
import me.pepperbell.continuity.client.properties.overlay.StandardOverlayCTMProperties;
import me.pepperbell.continuity.client.util.QuadUtil;
import me.pepperbell.continuity.client.util.RenderUtil;
import me.pepperbell.continuity.client.util.SpriteCalculator;
import me.pepperbell.continuity.client.util.TextureUtil;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2960;
import net.minecraft.class_5819;

public class StandardOverlayQuadProcessor
extends AbstractQuadProcessor {
    protected Set<class_2960> matchTilesSet;
    protected Predicate<class_2680> matchBlocksPredicate;
    protected Set<class_2960> connectTilesSet;
    protected Predicate<class_2680> connectBlocksPredicate;
    protected ConnectionPredicate connectionPredicate;
    protected int tintIndex;
    protected class_2680 tintBlock;
    protected RenderMaterial material;

    public StandardOverlayQuadProcessor(class_1058[] sprites, ProcessingPredicate processingPredicate, Set<class_2960> matchTilesSet, Predicate<class_2680> matchBlocksPredicate, Set<class_2960> connectTilesSet, Predicate<class_2680> connectBlocksPredicate, ConnectionPredicate connectionPredicate, int tintIndex, class_2680 tintBlock, BlendMode layer) {
        super(sprites, processingPredicate);
        this.matchTilesSet = matchTilesSet;
        this.matchBlocksPredicate = matchBlocksPredicate;
        this.connectTilesSet = connectTilesSet;
        this.connectBlocksPredicate = connectBlocksPredicate;
        this.connectionPredicate = connectionPredicate;
        this.tintIndex = tintIndex;
        this.tintBlock = tintBlock;
        this.material = RenderUtil.findOverlayMaterial(layer, this.tintBlock);
    }

    @Override
    public QuadProcessor.ProcessingResult processQuadInner(MutableQuadView quad, class_1058 sprite, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, int pass, QuadProcessor.ProcessingContext context) {
        class_2350 lightFace = quad.lightFace();
        OverlayRenderer renderer = this.getRenderer(blockView, pos, state, lightFace, sprite, DirectionMaps.getMap(lightFace)[0], context);
        if (renderer != null) {
            context.addEmitterConsumer(renderer);
        }
        return QuadProcessor.ProcessingResult.CONTINUE;
    }

    protected boolean appliesOverlay(class_2680 other, class_1920 blockView, class_2680 state, class_2338 pos, class_2350 face, class_1058 quadSprite) {
        if (other.method_26204().method_9543()) {
            return false;
        }
        if (!other.method_26234((class_1922)class_2682.field_12294, class_2338.field_10980)) {
            return false;
        }
        if (this.connectBlocksPredicate != null && !this.connectBlocksPredicate.test(other)) {
            return false;
        }
        if (this.connectTilesSet != null && !this.connectTilesSet.contains(SpriteCalculator.getSprite(other, face).method_45851().method_45816())) {
            return false;
        }
        return !this.connectionPredicate.shouldConnect(blockView, state, pos, other, face, quadSprite);
    }

    protected boolean hasSameOverlay(class_2680 other, class_1920 blockView, class_2680 state, class_2338 pos, class_2350 face, class_1058 quadSprite) {
        if (this.matchBlocksPredicate != null && !this.matchBlocksPredicate.test(other)) {
            return false;
        }
        return this.matchTilesSet == null || this.matchTilesSet.contains(SpriteCalculator.getSprite(other, face).method_45851().method_45816());
    }

    protected boolean appliesOverlayUnobscured(class_2680 state0, class_2350 direction0, class_1920 blockView, class_2338 pos, class_2680 state, class_2350 lightFace, class_1058 quadSprite, class_2338.class_2339 mutablePos) {
        boolean a0 = this.appliesOverlay(state0, blockView, state, pos, lightFace, quadSprite);
        if (a0) {
            mutablePos.method_25505((class_2382)pos, direction0).method_10098(lightFace);
            a0 = !blockView.method_8320((class_2338)mutablePos).method_26216((class_1922)blockView, (class_2338)mutablePos);
        }
        return a0;
    }

    protected boolean hasSameOverlayUnobscured(class_2680 state0, class_2350 direction0, class_1920 blockView, class_2338 pos, class_2680 state, class_2350 lightFace, class_1058 quadSprite, class_2338.class_2339 mutablePos) {
        boolean s0 = this.hasSameOverlay(state0, blockView, state, pos, lightFace, quadSprite);
        if (s0) {
            mutablePos.method_25505((class_2382)pos, direction0).method_10098(lightFace);
            s0 = !blockView.method_8320((class_2338)mutablePos).method_26216((class_1922)blockView, (class_2338)mutablePos);
        }
        return s0;
    }

    protected boolean appliesOverlayCorner(class_2350 direction0, class_2350 direction1, class_1920 blockView, class_2338 pos, class_2680 state, class_2350 lightFace, class_1058 quadSprite, class_2338.class_2339 mutablePos) {
        mutablePos.method_25505((class_2382)pos, direction0).method_10098(direction1);
        boolean corner0 = this.appliesOverlay(blockView.method_8320((class_2338)mutablePos), blockView, state, pos, lightFace, quadSprite);
        if (corner0) {
            mutablePos.method_10098(lightFace);
            corner0 = !blockView.method_8320((class_2338)mutablePos).method_26216((class_1922)blockView, (class_2338)mutablePos);
        }
        return corner0;
    }

    protected OverlayRenderer fromCorner(class_2350 direction0, class_2350 direction1, int sprite0, int sprite1, OverlayRenderer renderer, class_1920 blockView, class_2338 pos, class_2680 state, class_2350 lightFace, class_1058 quadSprite, class_2338.class_2339 mutablePos) {
        class_1058[] rendererSprites = this.prepareRenderer(renderer, lightFace, blockView, pos);
        mutablePos.method_25505((class_2382)pos, direction0).method_10098(direction1);
        if (this.appliesOverlay(blockView.method_8320((class_2338)mutablePos), blockView, state, pos, lightFace, quadSprite)) {
            mutablePos.method_10098(lightFace);
            if (!blockView.method_8320((class_2338)mutablePos).method_26216((class_1922)blockView, (class_2338)mutablePos)) {
                rendererSprites[1] = this.sprites[sprite1];
            }
        }
        rendererSprites[0] = this.sprites[sprite0];
        return renderer;
    }

    protected OverlayRenderer fromOneSide(class_2680 state0, class_2680 state1, class_2680 state2, class_2350 direction0, class_2350 direction1, class_2350 direction2, int sprite0, int sprite1, int sprite2, OverlayRenderer renderer, class_1920 blockView, class_2338 pos, class_2680 state, class_2350 lightFace, class_1058 quadSprite, class_2338.class_2339 mutablePos) {
        boolean s0 = this.hasSameOverlayUnobscured(state0, direction0, blockView, pos, state, lightFace, quadSprite, mutablePos);
        boolean s1 = this.hasSameOverlayUnobscured(state1, direction1, blockView, pos, state, lightFace, quadSprite, mutablePos);
        boolean s2 = this.hasSameOverlayUnobscured(state2, direction2, blockView, pos, state, lightFace, quadSprite, mutablePos);
        class_1058[] rendererSprites = this.prepareRenderer(renderer, lightFace, blockView, pos);
        rendererSprites[0] = this.sprites[sprite0];
        if (s0 | s1 && this.appliesOverlayCorner(direction0, direction1, blockView, pos, state, lightFace, quadSprite, mutablePos)) {
            rendererSprites[1] = this.sprites[sprite1];
        }
        if (s1 | s2 && this.appliesOverlayCorner(direction1, direction2, blockView, pos, state, lightFace, quadSprite, mutablePos)) {
            rendererSprites[2] = this.sprites[sprite2];
        }
        return renderer;
    }

    protected static OverlayRenderer getRenderer(ProcessingDataProvider dataProvider) {
        return dataProvider.getData(ProcessingDataKeys.STANDARD_OVERLAY_RENDERER_POOL_KEY).getRenderer();
    }

    protected class_1058[] prepareRenderer(OverlayRenderer renderer, class_2350 face, class_1920 blockView, class_2338 pos) {
        return renderer.prepare(face, RenderUtil.getTintColor(this.tintBlock, blockView, pos, this.tintIndex), this.material);
    }

    protected OverlayRenderer prepareRenderer(OverlayRenderer renderer, class_2350 face, class_1920 blockView, class_2338 pos, int sprite1) {
        class_1058[] rendererSprites = this.prepareRenderer(renderer, face, blockView, pos);
        rendererSprites[0] = this.sprites[sprite1];
        return renderer;
    }

    protected OverlayRenderer prepareRenderer(OverlayRenderer renderer, class_2350 face, class_1920 blockView, class_2338 pos, int sprite1, int sprite2) {
        class_1058[] rendererSprites = this.prepareRenderer(renderer, face, blockView, pos);
        rendererSprites[0] = this.sprites[sprite1];
        rendererSprites[1] = this.sprites[sprite2];
        return renderer;
    }

    protected OverlayRenderer getRenderer(class_1920 blockView, class_2338 pos, class_2680 state, class_2350 lightFace, class_1058 quadSprite, class_2350[] directions, ProcessingDataProvider dataProvider) {
        class_2338.class_2339 mutablePos = dataProvider.getData(ProcessingDataKeys.MUTABLE_POS_KEY);
        mutablePos.method_25505((class_2382)pos, directions[0]);
        class_2680 state0 = blockView.method_8320((class_2338)mutablePos);
        boolean left = this.appliesOverlayUnobscured(state0, directions[0], blockView, pos, state, lightFace, quadSprite, mutablePos);
        mutablePos.method_25505((class_2382)pos, directions[1]);
        class_2680 state1 = blockView.method_8320((class_2338)mutablePos);
        boolean down = this.appliesOverlayUnobscured(state1, directions[1], blockView, pos, state, lightFace, quadSprite, mutablePos);
        mutablePos.method_25505((class_2382)pos, directions[2]);
        class_2680 state2 = blockView.method_8320((class_2338)mutablePos);
        boolean right = this.appliesOverlayUnobscured(state2, directions[2], blockView, pos, state, lightFace, quadSprite, mutablePos);
        mutablePos.method_25505((class_2382)pos, directions[3]);
        class_2680 state3 = blockView.method_8320((class_2338)mutablePos);
        boolean up = this.appliesOverlayUnobscured(state3, directions[3], blockView, pos, state, lightFace, quadSprite, mutablePos);
        if (left & down & right & up) {
            return this.prepareRenderer(StandardOverlayQuadProcessor.getRenderer(dataProvider), lightFace, blockView, pos, 8);
        }
        if (left & down & right) {
            return this.prepareRenderer(StandardOverlayQuadProcessor.getRenderer(dataProvider), lightFace, blockView, pos, 5);
        }
        if (left & down & up) {
            return this.prepareRenderer(StandardOverlayQuadProcessor.getRenderer(dataProvider), lightFace, blockView, pos, 6);
        }
        if (left & right & up) {
            return this.prepareRenderer(StandardOverlayQuadProcessor.getRenderer(dataProvider), lightFace, blockView, pos, 13);
        }
        if (down & right & up) {
            return this.prepareRenderer(StandardOverlayQuadProcessor.getRenderer(dataProvider), lightFace, blockView, pos, 12);
        }
        if (left & right) {
            return this.prepareRenderer(StandardOverlayQuadProcessor.getRenderer(dataProvider), lightFace, blockView, pos, 9, 7);
        }
        if (up & down) {
            return this.prepareRenderer(StandardOverlayQuadProcessor.getRenderer(dataProvider), lightFace, blockView, pos, 15, 1);
        }
        if (left & down) {
            return this.fromCorner(directions[2], directions[3], 4, 14, StandardOverlayQuadProcessor.getRenderer(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (down & right) {
            return this.fromCorner(directions[0], directions[3], 3, 16, StandardOverlayQuadProcessor.getRenderer(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (right & up) {
            return this.fromCorner(directions[0], directions[1], 10, 2, StandardOverlayQuadProcessor.getRenderer(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (up & left) {
            return this.fromCorner(directions[1], directions[2], 11, 0, StandardOverlayQuadProcessor.getRenderer(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (left) {
            return this.fromOneSide(state1, state2, state3, directions[1], directions[2], directions[3], 9, 0, 14, StandardOverlayQuadProcessor.getRenderer(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (down) {
            return this.fromOneSide(state2, state3, state0, directions[2], directions[3], directions[0], 1, 14, 16, StandardOverlayQuadProcessor.getRenderer(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (right) {
            return this.fromOneSide(state3, state0, state1, directions[3], directions[0], directions[1], 7, 16, 2, StandardOverlayQuadProcessor.getRenderer(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (up) {
            return this.fromOneSide(state0, state1, state2, directions[0], directions[1], directions[2], 15, 2, 0, StandardOverlayQuadProcessor.getRenderer(dataProvider), blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        boolean s0 = this.hasSameOverlayUnobscured(state0, directions[0], blockView, pos, state, lightFace, quadSprite, mutablePos);
        boolean s1 = this.hasSameOverlayUnobscured(state1, directions[1], blockView, pos, state, lightFace, quadSprite, mutablePos);
        boolean s2 = this.hasSameOverlayUnobscured(state2, directions[2], blockView, pos, state, lightFace, quadSprite, mutablePos);
        boolean s3 = this.hasSameOverlayUnobscured(state3, directions[3], blockView, pos, state, lightFace, quadSprite, mutablePos);
        boolean corner0 = false;
        boolean corner1 = false;
        boolean corner2 = false;
        boolean corner3 = false;
        if (s0 | s1) {
            corner0 = this.appliesOverlayCorner(directions[0], directions[1], blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (s1 | s2) {
            corner1 = this.appliesOverlayCorner(directions[1], directions[2], blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (s2 | s3) {
            corner2 = this.appliesOverlayCorner(directions[2], directions[3], blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (s3 | s0) {
            corner3 = this.appliesOverlayCorner(directions[3], directions[0], blockView, pos, state, lightFace, quadSprite, mutablePos);
        }
        if (corner0 | corner1 | corner2 | corner3) {
            OverlayRenderer renderer = StandardOverlayQuadProcessor.getRenderer(dataProvider);
            class_1058[] rendererSprites = this.prepareRenderer(renderer, lightFace, blockView, pos);
            if (corner0) {
                rendererSprites[0] = this.sprites[2];
            }
            if (corner1) {
                rendererSprites[1] = this.sprites[0];
            }
            if (corner2) {
                rendererSprites[2] = this.sprites[14];
            }
            if (corner3) {
                rendererSprites[3] = this.sprites[16];
            }
            return renderer;
        }
        return null;
    }

    public static class OverlayRenderer
    implements Consumer<QuadEmitter> {
        protected static final class_1058[] EMPTY_SPRITES = new class_1058[4];
        protected class_1058[] sprites = new class_1058[4];
        protected class_2350 face;
        protected int color;
        protected RenderMaterial material;

        @Override
        public void accept(QuadEmitter emitter) {
            for (class_1058 sprite : this.sprites) {
                if (sprite == null || TextureUtil.isMissingSprite(sprite)) continue;
                QuadUtil.emitOverlayQuad(emitter, this.face, sprite, this.color, this.material);
            }
        }

        public class_1058[] prepare(class_2350 face, int color, RenderMaterial material) {
            System.arraycopy(EMPTY_SPRITES, 0, this.sprites, 0, EMPTY_SPRITES.length);
            this.face = face;
            this.color = color;
            this.material = material;
            return this.sprites;
        }
    }

    public static class OverlayRendererPool {
        protected final List<OverlayRenderer> list = new ObjectArrayList();
        protected int nextIndex = 0;

        public OverlayRenderer getRenderer() {
            if (this.nextIndex >= this.list.size()) {
                this.list.add(new OverlayRenderer());
            }
            OverlayRenderer renderer = this.list.get(this.nextIndex);
            ++this.nextIndex;
            return renderer;
        }

        public void reset() {
            this.nextIndex = 0;
        }
    }

    public static class Factory
    extends AbstractQuadProcessorFactory<StandardOverlayCTMProperties> {
        @Override
        public QuadProcessor createProcessor(StandardOverlayCTMProperties properties, class_1058[] sprites) {
            OverlayPropertiesSection overlaySection = properties.getOverlayPropertiesSection();
            return new StandardOverlayQuadProcessor(sprites, OverlayProcessingPredicate.fromProperties(properties), properties.getMatchTilesSet(), properties.getMatchBlocksPredicate(), properties.getConnectTilesSet(), properties.getConnectBlocksPredicate(), properties.getConnectionPredicate(), overlaySection.getTintIndex(), overlaySection.getTintBlock(), overlaySection.getLayer());
        }

        @Override
        public int getTextureAmount(StandardOverlayCTMProperties properties) {
            return 17;
        }

        @Override
        public boolean supportsNullSprites(StandardOverlayCTMProperties properties) {
            return false;
        }
    }
}

