/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils;

import dev.isxander.controlify.api.bind.ControllerBinding;

public class NavigationHelper {
    private final int initialDelay;
    private final int repeatDelay;
    private int currentDelay;
    private boolean hasResetThisTick = false;

    public NavigationHelper(int initialDelay, int repeatDelay) {
        this.initialDelay = initialDelay;
        this.repeatDelay = repeatDelay;
        this.currentDelay = 0;
    }

    public boolean canNavigate() {
        return --this.currentDelay <= 0;
    }

    public void reset() {
        this.currentDelay = this.initialDelay;
        this.hasResetThisTick = true;
    }

    public void clearDelay() {
        this.currentDelay = 0;
    }

    public void onNavigate() {
        if (!this.hasResetThisTick) {
            this.currentDelay = this.repeatDelay;
        } else {
            this.hasResetThisTick = false;
        }
    }

    public boolean shouldAction(ControllerBinding binding) {
        boolean shouldAction;
        boolean bl = shouldAction = binding.held() && (this.canNavigate() || !binding.prevHeld());
        if (shouldAction && !binding.prevHeld()) {
            this.reset();
        }
        return shouldAction;
    }
}

