/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.compat;

import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.screenop.ComponentProcessor;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.utils.NavigationHelper;

public abstract class AbstractSliderComponentProcessor
implements ComponentProcessor {
    private final NavigationHelper navigationHelper = new NavigationHelper(15, 3);

    @Override
    public boolean overrideControllerNavigation(ScreenProcessor<?> screen, Controller<?, ?> controller) {
        boolean left = controller.bindings().CYCLE_OPT_BACKWARD.held();
        boolean leftPrev = controller.bindings().CYCLE_OPT_BACKWARD.prevHeld();
        boolean right = controller.bindings().CYCLE_OPT_FORWARD.held();
        boolean rightPrev = controller.bindings().CYCLE_OPT_FORWARD.prevHeld();
        boolean repeatEventAvailable = this.navigationHelper.canNavigate();
        if (left && (repeatEventAvailable || !leftPrev)) {
            this.incrementSlider(true);
            if (!leftPrev) {
                this.navigationHelper.reset();
            }
        } else if (right && (repeatEventAvailable || !rightPrev)) {
            this.incrementSlider(false);
            if (!rightPrev) {
                this.navigationHelper.reset();
            }
        } else {
            return false;
        }
        this.navigationHelper.onNavigate();
        return true;
    }

    protected abstract void incrementSlider(boolean var1);
}

