/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.hid;

import org.hid4java.HidDevice;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface HIDDevice {
    public int vendorID();

    public int productID();

    public String path();

    public boolean supportsCommunication();

    public void open();

    public void close();

    public int read(byte[] var1);

    public int write(byte[] var1, int var2, byte var3);

    public record IDOnly(int vendorID, int productID, String path) implements HIDDevice
    {
        @Override
        public boolean supportsCommunication() {
            return false;
        }

        @Override
        public void open() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] buffer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int write(byte[] buffer, int packetLength, byte reportId) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class Hid4Java
    implements HIDDevice {
        private final HidDevice hidDevice;

        public Hid4Java(HidDevice hidDevice) {
            this.hidDevice = hidDevice;
        }

        @Override
        public int vendorID() {
            return this.hidDevice.getVendorId();
        }

        @Override
        public int productID() {
            return this.hidDevice.getProductId();
        }

        @Override
        public String path() {
            return this.hidDevice.getPath();
        }

        @Override
        public boolean supportsCommunication() {
            return true;
        }

        @Override
        public void open() {
            this.hidDevice.open();
            this.hidDevice.setNonBlocking(true);
        }

        @Override
        public void close() {
            this.hidDevice.close();
        }

        @Override
        public int read(byte[] buffer) {
            return this.hidDevice.read(buffer);
        }

        @Override
        public int write(byte[] buffer, int packetLength, byte reportId) {
            return this.hidDevice.write(buffer, packetLength, reportId);
        }
    }
}

