/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.BindRenderer;
import dev.isxander.controlify.api.bind.ControllerBinding;
import dev.isxander.controlify.api.bind.RadialIcon;
import dev.isxander.controlify.bindings.RadialIcons;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.ControllerConfig;
import dev.isxander.controlify.gui.guide.GuideAction;
import dev.isxander.controlify.gui.guide.GuideActionRenderer;
import dev.isxander.controlify.gui.layout.AnchorPoint;
import dev.isxander.controlify.gui.layout.PositionedComponent;
import dev.isxander.controlify.screenop.ComponentProcessor;
import dev.isxander.controlify.screenop.ScreenControllerEventListener;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.sound.ControlifySounds;
import dev.isxander.controlify.utils.Animator;
import dev.isxander.controlify.utils.Easings;
import dev.isxander.controlify.virtualmouse.VirtualMouseBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5489;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;

public class RadialMenuScreen
extends class_437
implements ScreenControllerEventListener,
ScreenProcessorProvider {
    public static final class_2960 EMPTY_ACTION = new class_2960("controlify", "empty_action");
    private final Controller<?, ?> controller;
    private final boolean editMode;
    private final class_437 parent;
    private final RadialButton[] buttons = new RadialButton[8];
    private int selectedButton = -1;
    private int idleTicks;
    private boolean isEditing;
    private ActionSelectList actionSelectList;
    private final Processor processor = new Processor(this);

    public RadialMenuScreen(Controller<?, ?> controller, boolean editMode, class_437 parent) {
        super((class_2561)class_2561.method_43473());
        this.controller = controller;
        this.editMode = editMode;
        this.parent = parent;
    }

    protected void method_25426() {
        RadialButton button;
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        this.buttons[0] = button = new RadialButton(0, centerX - 16, centerY - 64 - 8);
        this.method_37063(button);
        this.buttons[1] = button = new RadialButton(1, button.x + 32 + 8, button.y + 16);
        this.method_37063(button);
        this.buttons[2] = button = new RadialButton(2, button.x + 16, button.y + 32 + 8);
        this.method_37063(button);
        this.buttons[3] = button = new RadialButton(3, button.x - 16, button.y + 32 + 8);
        this.method_37063(button);
        this.buttons[4] = button = new RadialButton(4, button.x - 32 - 8, button.y + 16);
        this.method_37063(button);
        this.buttons[5] = button = new RadialButton(5, button.x - 32 - 8, button.y - 16);
        this.method_37063(button);
        this.buttons[6] = button = new RadialButton(6, button.x - 16, button.y - 32 - 8);
        this.method_37063(button);
        this.buttons[7] = new RadialButton(7, button.x + 16, button.y - 32 - 8);
        this.method_37063(this.buttons[7]);
        Animator.AnimationInstance animation = new Animator.AnimationInstance(5, Easings::easeOutQuad);
        for (RadialButton radialButton : this.buttons) {
            animation.addConsumer(radialButton::setX, (float)(centerX - 16), (float)radialButton.getX());
            animation.addConsumer(radialButton::setY, (float)(centerY - 16), (float)radialButton.getY());
        }
        Animator.INSTANCE.play(animation);
        if (this.editMode) {
            PositionedComponent exitGuide = (PositionedComponent)this.method_37063(new PositionedComponent<GuideActionRenderer<Object>>(new GuideActionRenderer<Object>(new GuideAction<Object>(this.controller.bindings().GUI_BACK, obj -> Optional.of(class_5244.field_24334)), false, true), AnchorPoint.BOTTOM_CENTER, 0, -10, AnchorPoint.BOTTOM_CENTER));
            ((GuideActionRenderer)exitGuide.getComponent()).updateName(null);
            exitGuide.updatePosition(this.field_22789, this.field_22790);
        }
    }

    @Override
    public void onControllerInput(Controller<?, ?> controller) {
        if (this.controller != controller) {
            return;
        }
        if (!this.editMode && !controller.bindings().RADIAL_MENU.held()) {
            if (this.selectedButton != -1 && this.buttons[this.selectedButton].invoke()) {
                this.playClickSound();
            }
            this.method_25419();
        }
        if (this.editMode && controller.bindings().GUI_BACK.justPressed()) {
            this.playClickSound();
            this.method_25419();
        }
        if (!this.isEditing) {
            float x = controller.bindings().RADIAL_AXIS_RIGHT.state() - controller.bindings().RADIAL_AXIS_LEFT.state();
            float y = controller.bindings().RADIAL_AXIS_DOWN.state() - controller.bindings().RADIAL_AXIS_UP.state();
            float threshold = ((ControllerConfig)controller.config()).buttonActivationThreshold;
            if (Math.abs(x) >= threshold || Math.abs(y) >= threshold) {
                float each;
                float angle = class_3532.method_15393((float)(57.295776f * (float)class_3532.method_15349((double)y, (double)x) - 90.0f)) + 180.0f;
                int newSelected = class_3532.method_15375((float)((angle + (each = 360.0f / (float)this.buttons.length) / 2.0f) / each)) % this.buttons.length;
                if (newSelected != this.selectedButton) {
                    this.selectedButton = newSelected;
                    this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)ControlifySounds.SCREEN_FOCUS_CHANGE, (float)1.0f));
                }
                for (int i = 0; i < this.buttons.length; ++i) {
                    boolean selected = i == this.selectedButton;
                    this.buttons[i].method_25365(selected);
                    if (!selected) continue;
                    this.method_25395(this.buttons[i]);
                }
                this.idleTicks = 0;
            } else if (!this.editMode) {
                ++this.idleTicks;
                if (this.idleTicks >= 20) {
                    this.selectedButton = -1;
                    for (RadialButton button : this.buttons) {
                        button.method_25365(false);
                    }
                }
            }
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (this.editMode) {
            this.method_25434(graphics);
        }
        super.method_25394(graphics, mouseX, mouseY, delta);
        if (!this.editMode) {
            graphics.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"controlify.radial_menu.configure_hint"), this.field_22789 / 2, this.field_22790 - 39, -1);
        }
    }

    private void playClickSound() {
        this.field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
    }

    private void finishEditing() {
        this.isEditing = false;
        this.method_37066((class_364)this.actionSelectList);
        this.method_25395(null);
        this.actionSelectList = null;
    }

    public void method_25419() {
        Controlify.instance().config().saveIfDirty();
        this.field_22787.method_1507(this.parent);
    }

    public boolean method_25421() {
        return this.editMode;
    }

    @Override
    public ScreenProcessor<?> screenProcessor() {
        return this.processor;
    }

    public class RadialButton
    implements class_4068,
    class_364,
    class_6379,
    ComponentProcessor {
        public static final class_2960 TEXTURE = Controlify.id("textures/gui/radial-buttons.png");
        private int x;
        private int y;
        private float translateX;
        private float translateY;
        private boolean focused;
        private ControllerBinding binding;
        private class_5489 name;
        private RadialIcon icon;

        private RadialButton(int index, float x, float y) {
            this.setX(x);
            this.setY(y);
            this.setAction(((ControllerConfig)RadialMenuScreen.this.controller.config()).radialActions[index]);
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)this.x + this.translateX, (float)this.y + this.translateY, 0.0f);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_22905(2.0f, 2.0f, 1.0f);
            graphics.method_25290(TEXTURE, 0, 0, this.focused ? 16.0f : 0.0f, 0.0f, 16, 16, 32, 16);
            graphics.method_51448().method_22909();
            if (!RadialMenuScreen.this.editMode || !this.focused) {
                graphics.method_51448().method_22903();
                graphics.method_51448().method_46416(4.0f, 4.0f, 0.0f);
                graphics.method_51448().method_22905(1.5f, 1.5f, 1.0f);
                this.icon.draw(graphics, 0, 0, delta);
                graphics.method_51448().method_22909();
            } else {
                BindRenderer renderer = RadialMenuScreen.this.controller.bindings().GUI_PRESS.renderer();
                renderer.render(graphics, 16 - renderer.size().width() / 2, 16);
            }
            graphics.method_51448().method_22909();
            if (this.focused) {
                int n = RadialMenuScreen.this.field_22789 / 2;
                int n2 = RadialMenuScreen.this.field_22790 / 2;
                Objects.requireNonNull(RadialMenuScreen.this.field_22793);
                int n3 = n2 - 9 / 2;
                int n4 = this.name.method_30887() - 1;
                Objects.requireNonNull(RadialMenuScreen.this.field_22793);
                this.name.method_30888(graphics, n, n3 - n4 * 9 / 2);
            }
        }

        public boolean invoke() {
            if (this.binding != null) {
                this.binding.fakePress();
                return true;
            }
            return false;
        }

        public void setAction(class_2960 binding) {
            if (!EMPTY_ACTION.equals((Object)binding)) {
                this.binding = RadialMenuScreen.this.controller.bindings().get(binding);
                this.icon = RadialIcons.getIcons().get(this.binding.radialIcon().orElseThrow());
                this.name = class_5489.method_30890((class_327)RadialMenuScreen.this.field_22793, (class_5348)this.binding.name(), (int)76);
            } else {
                this.binding = null;
                this.name = class_5489.field_26528;
                this.icon = RadialIcons.getIcons().get(RadialIcons.EMPTY);
            }
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public void setX(float x) {
            this.x = (int)x;
            this.translateX = x - (float)this.x;
        }

        public void setY(float y) {
            this.y = (int)y;
            this.translateY = y - (float)this.y;
        }

        public boolean method_25370() {
            return this.focused;
        }

        public void method_25365(boolean focused) {
            this.focused = focused;
        }

        @Override
        public boolean overrideControllerButtons(ScreenProcessor<?> screen, Controller<?, ?> controller) {
            if (RadialMenuScreen.this.editMode && controller == RadialMenuScreen.this.controller && controller.bindings().GUI_PRESS.justPressed()) {
                RadialButton button = RadialMenuScreen.this.buttons[RadialMenuScreen.this.selectedButton];
                int x = button.x < RadialMenuScreen.this.field_22789 / 2 ? button.x - 110 : button.x + 42;
                RadialMenuScreen.this.actionSelectList = new ActionSelectList(RadialMenuScreen.this.selectedButton, x, button.y, 100, 80);
                RadialMenuScreen.this.method_37063((class_364)RadialMenuScreen.this.actionSelectList);
                RadialMenuScreen.this.method_25395((class_364)RadialMenuScreen.this.actionSelectList);
                RadialMenuScreen.this.isEditing = true;
                return true;
            }
            return false;
        }

        public class_6379.class_6380 method_37018() {
            return this.method_25370() ? class_6379.class_6380.field_33786 : class_6379.class_6380.field_33784;
        }

        public void method_37020(class_6382 builder) {
            if (this.binding != null) {
                builder.method_37034(class_6381.field_33788, this.binding.name());
            }
        }

        public class_8030 method_48202() {
            return new class_8030(this.x, this.y, 32, 32);
        }
    }

    public static class Processor
    extends ScreenProcessor<RadialMenuScreen> {
        public Processor(RadialMenuScreen screen) {
            super(screen);
        }

        @Override
        public VirtualMouseBehaviour virtualMouseBehaviour() {
            return VirtualMouseBehaviour.DISABLED;
        }
    }

    public class ActionSelectList
    implements class_4068,
    class_4069,
    class_6379,
    ComponentProcessor {
        private final int radialIndex;
        private int x;
        private int y;
        private int width;
        private int height;
        private final int itemHeight = 10;
        private int scrollOffset;
        private boolean focused;
        private ActionEntry focusedEntry;
        private final List<ActionEntry> children = new ArrayList<ActionEntry>();

        public ActionSelectList(int index, int x, int y, int width, int height) {
            this.radialIndex = index;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            RadialMenuScreen.this.controller.bindings().registry().entrySet().stream().filter(entry -> ((ControllerBinding)entry.getValue()).radialIcon().isPresent()).map(Map.Entry::getKey).forEach(id -> this.children.add(new ActionEntry((class_2960)id)));
            class_2960 selectedBind = ((ControllerConfig)RadialMenuScreen.this.controller.config()).radialActions[this.radialIndex];
            this.children.stream().filter(action -> action.binding.equals((Object)selectedBind)).findAny().ifPresent(this::method_25395);
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            graphics.method_25294(this.x, this.y, this.x + this.width, this.y + this.height, Integer.MIN_VALUE);
            graphics.method_44379(this.x, this.y, this.x + this.width, this.y + this.height);
            int y = this.y - this.scrollOffset;
            for (ActionEntry child : this.children) {
                child.render(graphics, this.x, y, this.width, 10, mouseX, mouseY, delta);
                y += 10;
            }
            graphics.method_44380();
            graphics.method_49601(this.x - 1, this.y - 1, this.width + 2, this.height + 2, -2130706433);
        }

        @Override
        public boolean overrideControllerButtons(ScreenProcessor<?> screen, Controller<?, ?> controller) {
            if (controller == RadialMenuScreen.this.controller && controller.bindings().GUI_BACK.justPressed()) {
                RadialMenuScreen.this.finishEditing();
                return true;
            }
            return false;
        }

        public List<ActionEntry> method_25396() {
            return this.children;
        }

        public boolean method_25397() {
            return false;
        }

        public void method_25398(boolean dragging) {
        }

        @Nullable
        public ActionEntry getFocused() {
            return this.focusedEntry;
        }

        public void method_25395(@Nullable class_364 child) {
            int index;
            ActionEntry focus;
            this.focusedEntry = focus = (ActionEntry)child;
            if (focus != null && (index = this.method_25396().indexOf(child)) != -1) {
                int focusY = index * 10 - this.scrollOffset;
                if (focusY < 0) {
                    this.scrollOffset = class_3532.method_15340((int)(index * 10), (int)0, (int)(this.method_25396().size() * 10 - this.height));
                } else if (focusY + 10 > this.height) {
                    this.scrollOffset = class_3532.method_15340((int)(index * 10 + 10 - this.height), (int)0, (int)(this.method_25396().size() * 10 - this.height));
                }
            }
        }

        public void method_25365(boolean focused) {
            this.focused = focused;
        }

        public boolean method_25370() {
            return this.focused;
        }

        public class_6379.class_6380 method_37018() {
            return this.focused ? class_6379.class_6380.field_33786 : class_6379.class_6380.field_33784;
        }

        public void method_37020(class_6382 builder) {
            if (this.getFocused() != null) {
                builder.method_37034(class_6381.field_33788, this.getFocused().name);
            }
        }

        public class ActionEntry
        implements class_364,
        ComponentProcessor {
            private int x;
            private int y;
            private boolean focused;
            private final class_2960 binding;
            private final class_2561 name;

            public ActionEntry(class_2960 binding) {
                this.binding = binding;
                this.name = RadialMenuScreen.this.controller.bindings().get(binding).name();
            }

            public void render(class_332 graphics, int x, int y, int width, int itemHeight, int mouseX, int mouseY, float delta) {
                this.x = x;
                this.y = y;
                if (this.focused) {
                    graphics.method_25294(x, y, x + width, y + itemHeight, -16777216);
                }
                graphics.method_27535(RadialMenuScreen.this.field_22793, this.name, x + 2, y + 1, this.focused ? -1 : -5855578);
            }

            public void method_25365(boolean focused) {
                this.focused = focused;
            }

            public boolean method_25370() {
                return this.focused;
            }

            @Nullable
            public class_8016 method_48205(class_8023 event) {
                return !this.focused ? class_8016.method_48193((class_364)this) : null;
            }

            public class_8030 method_48202() {
                return new class_8030(this.x, this.y, ActionSelectList.this.width, 10);
            }

            @Override
            public boolean overrideControllerButtons(ScreenProcessor<?> screen, Controller<?, ?> controller) {
                if (controller == RadialMenuScreen.this.controller && controller.bindings().GUI_PRESS.justPressed()) {
                    ((ControllerConfig)controller.config()).radialActions[ActionSelectList.this.radialIndex] = this.binding;
                    Controlify.instance().config().setDirty();
                    RadialMenuScreen.this.buttons[ActionSelectList.this.radialIndex].setAction(this.binding);
                    RadialMenuScreen.this.playClickSound();
                    RadialMenuScreen.this.finishEditing();
                    return true;
                }
                return false;
            }
        }
    }
}

