/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.sdl2;

import dev.isxander.controlify.utils.DebugLog;
import dev.isxander.controlify.utils.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import org.libsdl.SDL;

public class SDL2NativesManager {
    private static final String SDL2_VERSION = "2.28.2-26";
    private static final Map<Target, String> NATIVE_LIBRARIES = Map.of(new Target(class_156.class_158.field_1133, true, false), "windows64.dll", new Target(class_156.class_158.field_1133, false, false), "window32.dll", new Target(class_156.class_158.field_1135, true, false), "linux64.so", new Target(class_156.class_158.field_1137, true, false), "macosx64.dylib", new Target(class_156.class_158.field_1137, true, true), "macosxarm64.dylib");
    private static final String NATIVE_LIBRARY_URL = "https://maven.isxander.dev/releases/dev/isxander/sdl2-jni-natives/%s/".formatted("2.28.2-26");
    private static boolean loaded = false;
    private static boolean initialised = false;

    public static void initialise() {
        if (initialised) {
            return;
        }
        initialised = true;
        DebugLog.log("Initialising SDL2 native library", new Object[0]);
        if (!Target.CURRENT.hasNativeLibrary()) {
            Log.LOGGER.warn("SDL2 native library not available for OS: " + Target.CURRENT);
            return;
        }
        Path localLibraryPath = Target.CURRENT.getLocalNativePath();
        if (Files.notExists(localLibraryPath, new LinkOption[0])) {
            if (Files.exists(localLibraryPath.getParent(), new LinkOption[0])) {
                try (Stream<Path> walk = Files.walk(localLibraryPath.getParent(), new FileVisitOption[0]);){
                    walk.sorted(Comparator.reverseOrder()).map(Path::toFile).forEachOrdered(File::delete);
                }
                catch (Exception e) {
                    Log.LOGGER.error("Failed to delete old SDL2 native library", (Throwable)e);
                }
            }
            Log.LOGGER.info("Downloading SDL2 native library: " + Target.CURRENT.getArtifactName());
            SDL2NativesManager.downloadLibrary(localLibraryPath);
        }
        try {
            SDL.load((Path)localLibraryPath);
            SDL2NativesManager.startSDL2();
            loaded = true;
        }
        catch (Exception e) {
            Log.LOGGER.error("Failed to load SDL2 native library", (Throwable)e);
        }
    }

    private static void startSDL2() {
        SDL.SDL_SetHint((String)"SDL_JOYSTICK_ALLOW_BACKGROUND_EVENTS", (String)"1");
        SDL.SDL_SetHint((String)"SDL_ACCELEROMETER_AS_JOYSTICK", (String)"0");
        SDL.SDL_SetHint((String)"SDL_MAC_BACKGROUND_APP", (String)"1");
        SDL.SDL_SetHint((String)"SDL_JOYSTICK_RAWINPUT", (String)"0");
        SDL.SDL_SetHint((String)"SDL_JOYSTICK_HIDAPI", (String)"1");
        SDL.SDL_SetHint((String)"SDL_JOYSTICK_HIDAPI_PS4_RUMBLE", (String)"1");
        SDL.SDL_SetHint((String)"SDL_JOYSTICK_HIDAPI_PS5_RUMBLE", (String)"1");
        SDL.SDL_SetHint((String)"SDL_JOYSTICK_HIDAPI_STEAM", (String)"1");
        int joystickSubsystem = 512;
        int gameControllerSubsystem = 8192;
        if (SDL.SDL_Init((int)(joystickSubsystem | gameControllerSubsystem)) != 0) {
            Log.LOGGER.error("Failed to initialise SDL2: " + SDL.SDL_GetError());
            throw new RuntimeException("Failed to initialise SDL2: " + SDL.SDL_GetError());
        }
        DebugLog.log("Initialised SDL2", new Object[0]);
    }

    private static boolean downloadLibrary(Path path) {
        try {
            Files.deleteIfExists(path);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(path.toFile());){
            String url = NATIVE_LIBRARY_URL + Target.CURRENT.getArtifactName();
            URL downloadUrl = new URL(url);
            ReadableByteChannel readableByteChannel = Channels.newChannel(downloadUrl.openStream());
            FileChannel fileChannel = fileOutputStream.getChannel();
            fileChannel.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            Log.LOGGER.info("Downloaded SDL2 native library from " + downloadUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    public static boolean isInitialised() {
        return initialised;
    }

    public record Target(class_156.class_158 os, boolean is64Bit, boolean isARM) {
        public static final Target CURRENT = (Target)class_156.method_656(() -> {
            class_156.class_158 os = class_156.method_668();
            String arch = System.getProperty("os.arch");
            boolean is64bit = arch.contains("64");
            boolean isARM = arch.contains("arm") || arch.contains("aarch");
            return new Target(os, is64bit, isARM);
        });

        public boolean hasNativeLibrary() {
            return NATIVE_LIBRARIES.containsKey(this);
        }

        public String getArtifactName() {
            String suffix = NATIVE_LIBRARIES.get(CURRENT);
            return "sdl2-jni-natives-2.28.2-26-" + suffix;
        }

        public Path getLocalNativePath() {
            return FabricLoader.getInstance().getGameDir().resolve("controlify-natives").resolve(this.getArtifactName());
        }

        public boolean isMacArm() {
            return this.os == class_156.class_158.field_1137 && this.isARM;
        }
    }
}

