/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.joystick.mapping;

import dev.isxander.controlify.bindings.JoystickAxisBind;
import dev.isxander.controlify.controller.joystick.JoystickState;
import dev.isxander.controlify.controller.joystick.mapping.JoystickMapping;
import dev.isxander.controlify.controller.joystick.render.GenericRenderer;
import dev.isxander.controlify.controller.joystick.render.JoystickRenderer;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.Buffer;
import java.util.Optional;
import net.minecraft.class_2561;
import org.lwjgl.glfw.GLFW;

public class UnmappedJoystickMapping
implements JoystickMapping {
    public static final UnmappedJoystickMapping EMPTY = new UnmappedJoystickMapping(0, 0, 0);
    private final UnmappedAxis[] axes;
    private final UnmappedButton[] buttons;
    private final UnmappedHat[] hats;

    private UnmappedJoystickMapping(int axisCount, int buttonCount, int hatCount) {
        int i;
        this.axes = new UnmappedAxis[axisCount];
        for (i = 0; i < axisCount; ++i) {
            this.axes[i] = new UnmappedAxis(i, new GenericRenderer.Axis(Integer.toString(i + 1)));
        }
        this.buttons = new UnmappedButton[buttonCount];
        for (i = 0; i < buttonCount; ++i) {
            this.buttons[i] = new UnmappedButton(i, new GenericRenderer.Button(Integer.toString(i + 1)));
        }
        this.hats = new UnmappedHat[hatCount];
        for (i = 0; i < hatCount; ++i) {
            this.hats[i] = new UnmappedHat(i);
        }
    }

    public UnmappedJoystickMapping(int joystickId) {
        this(Optional.ofNullable(GLFW.glfwGetJoystickAxes((int)joystickId)).map(Buffer::limit).orElse(0), Optional.ofNullable(GLFW.glfwGetJoystickButtons((int)joystickId)).map(Buffer::limit).orElse(0), Optional.ofNullable(GLFW.glfwGetJoystickHats((int)joystickId)).map(Buffer::limit).orElse(0));
    }

    @Override
    public JoystickMapping.Axis[] axes() {
        return this.axes;
    }

    @Override
    public JoystickMapping.Button[] buttons() {
        return this.buttons;
    }

    @Override
    public JoystickMapping.Hat[] hats() {
        return this.hats;
    }

    private static final class UnmappedAxis
    extends Record
    implements JoystickMapping.Axis {
        private final int axis;
        private final GenericRenderer.Axis renderer;

        private UnmappedAxis(int axis, GenericRenderer.Axis renderer) {
            this.axis = axis;
            this.renderer = renderer;
        }

        @Override
        public float getAxis(JoystickMapping.JoystickData data) {
            return data.axes()[this.axis];
        }

        @Override
        public String identifier() {
            return "axis-" + this.axis;
        }

        @Override
        public class_2561 name() {
            return class_2561.method_43469((String)"controlify.joystick_mapping.unmapped.axis", (Object[])new Object[]{this.axis + 1});
        }

        @Override
        public boolean requiresDeadzone() {
            return true;
        }

        @Override
        public boolean isAxisResting(float value) {
            return value == this.restingValue();
        }

        @Override
        public float restingValue() {
            return 0.0f;
        }

        @Override
        public String getDirectionIdentifier(int axis, JoystickAxisBind.AxisDirection direction) {
            return direction.name().toLowerCase();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{UnmappedAxis.class, "axis;renderer", "axis", "renderer"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{UnmappedAxis.class, "axis;renderer", "axis", "renderer"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{UnmappedAxis.class, "axis;renderer", "axis", "renderer"}, this, o);
        }

        public int axis() {
            return this.axis;
        }

        @Override
        public GenericRenderer.Axis renderer() {
            return this.renderer;
        }
    }

    private static final class UnmappedButton
    extends Record
    implements JoystickMapping.Button {
        private final int button;
        private final GenericRenderer.Button renderer;

        private UnmappedButton(int button, GenericRenderer.Button renderer) {
            this.button = button;
            this.renderer = renderer;
        }

        @Override
        public boolean isPressed(JoystickMapping.JoystickData data) {
            return data.buttons()[this.button];
        }

        @Override
        public String identifier() {
            return "button-" + this.button;
        }

        @Override
        public class_2561 name() {
            return class_2561.method_43469((String)"controlify.joystick_mapping.unmapped.button", (Object[])new Object[]{this.button + 1});
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{UnmappedButton.class, "button;renderer", "button", "renderer"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{UnmappedButton.class, "button;renderer", "button", "renderer"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{UnmappedButton.class, "button;renderer", "button", "renderer"}, this, o);
        }

        public int button() {
            return this.button;
        }

        @Override
        public GenericRenderer.Button renderer() {
            return this.renderer;
        }
    }

    private record UnmappedHat(int hat) implements JoystickMapping.Hat
    {
        @Override
        public JoystickState.HatState getHatState(JoystickMapping.JoystickData data) {
            return data.hats()[this.hat];
        }

        @Override
        public String identifier() {
            return "hat-" + this.hat;
        }

        @Override
        public class_2561 name() {
            return class_2561.method_43469((String)"controlify.joystick_mapping.unmapped.hat", (Object[])new Object[]{this.hat + 1});
        }

        @Override
        public JoystickRenderer renderer(JoystickState.HatState state) {
            return new GenericRenderer.Hat(Integer.toString(this.hat + 1));
        }
    }
}

