/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.joystick.mapping;

import dev.isxander.controlify.bindings.JoystickAxisBind;
import dev.isxander.controlify.controller.ControllerType;
import dev.isxander.controlify.controller.joystick.JoystickController;
import dev.isxander.controlify.controller.joystick.JoystickState;
import dev.isxander.controlify.controller.joystick.mapping.JoystickMapping;
import dev.isxander.controlify.controller.joystick.mapping.UnmappedJoystickMapping;
import dev.isxander.controlify.controller.joystick.render.JoystickRenderer;
import dev.isxander.controlify.utils.Log;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.json5.JsonReader;
import org.quiltmc.json5.JsonToken;

public class RPJoystickMapping
implements JoystickMapping {
    private final AxisMapping[] axes;
    private final ButtonMapping[] buttons;
    private final HatMapping[] hats;

    public RPJoystickMapping(JsonReader reader, ControllerType type) throws IOException {
        AxisMapping[] axes = null;
        ButtonMapping[] buttons = null;
        HatMapping[] hats = null;
        reader.beginObject();
        block10: while (reader.hasNext()) {
            String name;
            switch (name = reader.nextName()) {
                case "axes": {
                    if (axes != null) {
                        throw new IllegalStateException("Axes defined twice.");
                    }
                    axes = this.readAxes(reader, type);
                    continue block10;
                }
                case "buttons": {
                    if (buttons != null) {
                        throw new IllegalStateException("Buttons defined twice.");
                    }
                    buttons = this.readButtons(reader, type);
                    continue block10;
                }
                case "hats": {
                    if (hats != null) {
                        throw new IllegalStateException("Hats defined twice.");
                    }
                    hats = this.readHats(reader, type);
                    continue block10;
                }
            }
            Log.LOGGER.warn("Unknown field in joystick mapping: " + name + ". Expected values: ['axes', 'buttons', 'hats']");
            reader.skipValue();
        }
        reader.endObject();
        this.axes = axes;
        this.buttons = buttons;
        this.hats = hats;
    }

    private AxisMapping[] readAxes(JsonReader reader, ControllerType type) throws IOException {
        ArrayList<AxisMapping> axes = new ArrayList<AxisMapping>();
        reader.beginArray();
        while (reader.hasNext()) {
            ArrayList<Integer> ids = new ArrayList<Integer>();
            class_241 inpRange = null;
            class_241 outRange = null;
            boolean deadzone = false;
            float restState = 0.0f;
            String identifier = null;
            ArrayList<String[]> axisNames = new ArrayList<String[]>();
            reader.beginObject();
            block25: while (reader.hasNext()) {
                String name;
                switch (name = reader.nextName()) {
                    case "ids": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            ids.add(reader.nextInt());
                        }
                        reader.endArray();
                        continue block25;
                    }
                    case "identifier": {
                        identifier = reader.nextString();
                        continue block25;
                    }
                    case "range": {
                        if (reader.peek() == JsonToken.BEGIN_ARRAY) {
                            reader.beginArray();
                            outRange = new class_241((float)reader.nextDouble(), (float)reader.nextDouble());
                            inpRange = new class_241(-1.0f, 1.0f);
                            reader.endArray();
                            continue block25;
                        }
                        reader.beginObject();
                        block27: while (reader.hasNext()) {
                            String rangeName;
                            switch (rangeName = reader.nextName()) {
                                case "in": {
                                    reader.beginArray();
                                    inpRange = new class_241((float)reader.nextDouble(), (float)reader.nextDouble());
                                    reader.endArray();
                                    continue block27;
                                }
                                case "out": {
                                    reader.beginArray();
                                    outRange = new class_241((float)reader.nextDouble(), (float)reader.nextDouble());
                                    reader.endArray();
                                    continue block27;
                                }
                            }
                            reader.skipValue();
                            Log.LOGGER.info("Unknown axis range property: " + rangeName + ". Expected are ['in', 'out']");
                        }
                        reader.endObject();
                        continue block25;
                    }
                    case "rest": {
                        restState = (float)reader.nextDouble();
                        continue block25;
                    }
                    case "deadzone": {
                        deadzone = reader.nextBoolean();
                        continue block25;
                    }
                    case "axis_names": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            reader.beginArray();
                            axisNames.add(new String[]{reader.nextString(), reader.nextString()});
                            reader.endArray();
                        }
                        reader.endArray();
                        continue block25;
                    }
                }
                reader.skipValue();
                Log.LOGGER.info("Unknown axis property: " + name + ". Expected are ['identifier', 'axis_names', 'ids', 'range', 'rest', 'deadzone']");
            }
            reader.endObject();
            for (Integer id : ids) {
                axes.add(new AxisMapping(id, identifier, inpRange, outRange, restState, deadzone, type.mappingId(), (String[])axisNames.get(ids.indexOf(id))));
            }
        }
        reader.endArray();
        return axes.toArray(new AxisMapping[0]);
    }

    private ButtonMapping[] readButtons(JsonReader reader, ControllerType type) throws IOException {
        ArrayList<ButtonMapping> buttons = new ArrayList<ButtonMapping>();
        reader.beginArray();
        while (reader.hasNext()) {
            int id = -1;
            String btnName = null;
            reader.beginObject();
            block9: while (reader.hasNext()) {
                String name;
                switch (name = reader.nextName()) {
                    case "button": {
                        id = reader.nextInt();
                        continue block9;
                    }
                    case "name": {
                        btnName = reader.nextString();
                        continue block9;
                    }
                }
                reader.skipValue();
                Log.LOGGER.info("Unknown button property: " + name + ". Expected are ['button', 'name']");
            }
            reader.endObject();
            buttons.add(new ButtonMapping(id, btnName, type.mappingId()));
        }
        reader.endArray();
        return buttons.toArray(new ButtonMapping[0]);
    }

    private HatMapping[] readHats(JsonReader reader, ControllerType type) throws IOException {
        ArrayList<HatMapping> hats = new ArrayList<HatMapping>();
        reader.beginArray();
        while (reader.hasNext()) {
            int id = -1;
            String hatName = null;
            HatMapping.EmulatedAxis axis = null;
            reader.beginObject();
            block11: while (reader.hasNext()) {
                String name;
                switch (name = reader.nextName()) {
                    case "hat": {
                        id = reader.nextInt();
                        continue block11;
                    }
                    case "name": {
                        hatName = reader.nextString();
                        continue block11;
                    }
                    case "emulated_axis": {
                        int axisId = -1;
                        HashMap<Float, JoystickState.HatState> states = new HashMap<Float, JoystickState.HatState>();
                        reader.beginObject();
                        while (reader.hasNext()) {
                            String emulatedName = reader.nextName();
                            for (JoystickState.HatState hatState : JoystickState.HatState.values()) {
                                if (!hatState.name().equalsIgnoreCase(emulatedName)) continue;
                                states.put(Float.valueOf((float)reader.nextDouble()), hatState);
                            }
                            if (!emulatedName.equalsIgnoreCase("axis")) continue;
                            axisId = reader.nextInt();
                        }
                        reader.endObject();
                        if (axisId == -1) {
                            Log.LOGGER.error("No axis id defined for emulated hat " + hatName + "! Skipping.");
                            continue block11;
                        }
                        if (states.size() != JoystickState.HatState.values().length) {
                            Log.LOGGER.error("Not all hat states are defined for emulated hat " + hatName + "! Skipping.");
                            continue block11;
                        }
                        axis = new HatMapping.EmulatedAxis(axisId, states);
                        continue block11;
                    }
                }
                reader.skipValue();
                Log.LOGGER.info("Unknown hat property: " + name + ". Expected are ['hat', 'name']");
            }
            reader.endObject();
            hats.add(new HatMapping(id, hatName, type.mappingId(), axis));
        }
        reader.endArray();
        return hats.toArray(new HatMapping[0]);
    }

    @Override
    public JoystickMapping.Axis[] axes() {
        return this.axes;
    }

    @Override
    public JoystickMapping.Button[] buttons() {
        return this.buttons;
    }

    @Override
    public JoystickMapping.Hat[] hats() {
        return this.hats;
    }

    public static JoystickMapping fromType(JoystickController<?> joystick) {
        RPJoystickMapping rPJoystickMapping;
        block9: {
            Optional resource = class_310.method_1551().method_1478().method_14486(new class_2960("controlify", "mappings/" + joystick.type().mappingId() + ".json"));
            if (resource.isEmpty()) {
                Log.LOGGER.warn("No joystick mapping found for controller: '" + joystick.type().mappingId() + "'");
                return new UnmappedJoystickMapping(joystick.joystickId());
            }
            JsonReader reader = JsonReader.json5((Reader)((class_3298)resource.get()).method_43039());
            try {
                rPJoystickMapping = new RPJoystickMapping(reader, joystick.type());
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Log.LOGGER.error("Failed to load joystick mapping for controller: '" + joystick.type().mappingId() + "'", (Throwable)e);
                    return new UnmappedJoystickMapping(joystick.joystickId());
                }
            }
            reader.close();
        }
        return rPJoystickMapping;
    }

    private record AxisMapping(int id, String identifier, class_241 inpRange, class_241 outRange, float restingValue, boolean requiresDeadzone, String theme, String[] axisNames) implements JoystickMapping.Axis
    {
        @Override
        public float getAxis(JoystickMapping.JoystickData data) {
            float rawAxis = data.axes()[this.id];
            if (this.inpRange() == null || this.outRange() == null) {
                return rawAxis;
            }
            return (rawAxis + (this.outRange().field_1343 - this.inpRange().field_1343)) / (this.inpRange().field_1342 - this.inpRange().field_1343) * (this.outRange().field_1342 - this.outRange().field_1343);
        }

        @Override
        public boolean isAxisResting(float value) {
            return value == this.restingValue();
        }

        @Override
        public class_2561 name() {
            return class_2561.method_43471((String)("controlify.joystick_mapping." + this.theme() + ".axis." + this.identifier()));
        }

        @Override
        public String getDirectionIdentifier(int axis, JoystickAxisBind.AxisDirection direction) {
            return this.axisNames()[direction.ordinal()];
        }

        @Override
        public JoystickRenderer renderer() {
            return null;
        }
    }

    private record ButtonMapping(int id, String identifier, String typeId) implements JoystickMapping.Button
    {
        @Override
        public boolean isPressed(JoystickMapping.JoystickData data) {
            return data.buttons()[this.id];
        }

        @Override
        public class_2561 name() {
            return class_2561.method_43471((String)("controlify.joystick_mapping." + this.typeId() + ".button." + this.identifier()));
        }

        @Override
        public JoystickRenderer renderer() {
            return null;
        }
    }

    private record HatMapping(int hatId, String identifier, String typeId, @Nullable EmulatedAxis emulatedAxis) implements JoystickMapping.Hat
    {
        @Override
        public JoystickState.HatState getHatState(JoystickMapping.JoystickData data) {
            if (this.emulatedAxis() != null) {
                EmulatedAxis axis = this.emulatedAxis();
                float axisValue = data.axes()[axis.axisId()];
                return this.emulatedAxis().states().get(Float.valueOf(axisValue));
            }
            return data.hats()[this.hatId()];
        }

        @Override
        public class_2561 name() {
            return class_2561.method_43471((String)("controlify.joystick_mapping." + this.typeId() + ".hat." + this.identifier()));
        }

        @Override
        public JoystickRenderer renderer(JoystickState.HatState state) {
            return null;
        }

        private record EmulatedAxis(int axisId, Map<Float, JoystickState.HatState> states) {
        }
    }
}

