/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.joystick;

import dev.isxander.controlify.controller.ControllerConfig;
import dev.isxander.controlify.controller.joystick.JoystickController;
import dev.isxander.controlify.controller.joystick.mapping.JoystickMapping;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class JoystickConfig
extends ControllerConfig {
    private Map<String, Float> deadzones;
    private transient JoystickController<?> controller;

    public JoystickConfig(JoystickController<?> controller) {
        Validate.notNull(controller);
        this.setup(controller);
    }

    @Override
    public void setDeadzone(int axis, float deadzone) {
        if (axis < 0) {
            throw new IllegalArgumentException("Axis cannot be negative!");
        }
        this.deadzones.put(this.controller.mapping().axes()[axis].identifier(), Float.valueOf(deadzone));
    }

    @Override
    public float getDeadzone(int axis) {
        if (axis < 0) {
            throw new IllegalArgumentException("Axis cannot be negative!");
        }
        return this.deadzones.getOrDefault(this.controller.mapping().axes()[axis].identifier(), Float.valueOf(0.2f)).floatValue();
    }

    void setup(JoystickController<?> controller) {
        this.controller = controller;
        if (this.deadzones == null) {
            this.deadzones = new HashMap<String, Float>();
            for (int i = 0; i < controller.mapping().axes().length; ++i) {
                JoystickMapping.Axis axis = controller.mapping().axes()[i];
                if (!axis.requiresDeadzone()) continue;
                this.deadzones.put(axis.identifier(), Float.valueOf(0.2f));
            }
        }
    }
}

