/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.joystick;

import dev.isxander.controlify.ControllerManager;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.ControllerType;
import dev.isxander.controlify.controller.joystick.CompoundJoystickController;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public record CompoundJoystickInfo(Collection<String> joystickUids, String friendlyName) {
    public ControllerType type() {
        return new ControllerType(this.friendlyName, CompoundJoystickInfo.createUID(this.joystickUids), "generic", true, false);
    }

    public boolean canBeUsed() {
        List<Controller> joysticks = ControllerManager.getConnectedControllers().stream().filter(c -> this.joystickUids.contains(c.uid())).toList();
        if (joysticks.size() != this.joystickUids().size()) {
            return false;
        }
        return !joysticks.stream().anyMatch(c -> !c.canBeUsed());
    }

    public boolean isLoaded() {
        return ControllerManager.isControllerConnected(CompoundJoystickInfo.createUID(this.joystickUids));
    }

    public Optional<CompoundJoystickController> attemptCreate() {
        if (!this.canBeUsed()) {
            return Optional.empty();
        }
        List<Integer> joystickIDs = ControllerManager.getConnectedControllers().stream().filter(c -> this.joystickUids.contains(c.uid())).map(Controller::joystickId).toList();
        ControllerType type = this.type();
        return Optional.of(new CompoundJoystickController(joystickIDs, type.mappingId(), type));
    }

    public static String createUID(Collection<String> joystickUIDs) {
        return "compound-" + String.join((CharSequence)"_", joystickUIDs);
    }
}

