/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.controller.gamepad;

import dev.isxander.controlify.controller.ControllerState;
import dev.isxander.controlify.utils.ControllerUtils;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class GamepadState
implements ControllerState {
    public static final GamepadState EMPTY = new GamepadState(AxesState.EMPTY, AxesState.EMPTY, ButtonState.EMPTY, new GyroState(), new GyroState());
    private final AxesState gamepadAxes;
    private final AxesState rawGamepadAxes;
    private final ButtonState gamepadButtons;
    private final GyroState absoluteGyroPos;
    @Nullable
    private final GyroState gyroDelta;
    private final List<Float> unnamedAxes;
    private final List<Float> unnamedRawAxes;
    private final List<Boolean> unnamedButtons;

    public GamepadState(AxesState gamepadAxes, AxesState rawGamepadAxes, ButtonState gamepadButtons, @Nullable GyroState gyroDelta, GyroState absoluteGyroPos) {
        this.gamepadAxes = gamepadAxes;
        this.rawGamepadAxes = rawGamepadAxes;
        this.gamepadButtons = gamepadButtons;
        this.gyroDelta = gyroDelta;
        this.absoluteGyroPos = absoluteGyroPos;
        this.unnamedAxes = List.of(Float.valueOf(gamepadAxes.leftStickX()), Float.valueOf(gamepadAxes.leftStickY()), Float.valueOf(gamepadAxes.rightStickX()), Float.valueOf(gamepadAxes.rightStickY()), Float.valueOf(gamepadAxes.leftTrigger()), Float.valueOf(gamepadAxes.rightTrigger()));
        this.unnamedRawAxes = List.of(Float.valueOf(rawGamepadAxes.leftStickX()), Float.valueOf(rawGamepadAxes.leftStickY()), Float.valueOf(rawGamepadAxes.rightStickX()), Float.valueOf(rawGamepadAxes.rightStickY()), Float.valueOf(rawGamepadAxes.leftTrigger()), Float.valueOf(rawGamepadAxes.rightTrigger()));
        this.unnamedButtons = List.of(gamepadButtons.a(), gamepadButtons.b(), gamepadButtons.x(), gamepadButtons.y(), gamepadButtons.leftBumper(), gamepadButtons.rightBumper(), gamepadButtons.back(), gamepadButtons.start(), gamepadButtons.leftStick(), gamepadButtons.rightStick(), gamepadButtons.dpadUp(), gamepadButtons.dpadDown(), gamepadButtons.dpadLeft(), gamepadButtons.dpadRight());
    }

    @Override
    public List<Float> axes() {
        return this.unnamedAxes;
    }

    @Override
    public List<Float> rawAxes() {
        return this.unnamedRawAxes;
    }

    @Override
    public List<Boolean> buttons() {
        return this.unnamedButtons;
    }

    @Override
    public boolean hasAnyInput() {
        return !this.gamepadAxes().equals(AxesState.EMPTY) || !this.gamepadButtons().equals(ButtonState.EMPTY);
    }

    public AxesState gamepadAxes() {
        return this.gamepadAxes;
    }

    public AxesState rawGamepadAxes() {
        return this.rawGamepadAxes;
    }

    public ButtonState gamepadButtons() {
        return this.gamepadButtons;
    }

    public GyroState gyroDelta() {
        if (this.gyroDelta == null) {
            return new GyroState();
        }
        return this.gyroDelta;
    }

    public GyroState absoluteGyroPos() {
        return this.absoluteGyroPos;
    }

    public boolean supportsGyro() {
        return this.gyroDelta != null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GamepadState that = (GamepadState)obj;
        return Objects.equals(this.gamepadAxes, that.gamepadAxes) && Objects.equals(this.rawGamepadAxes, that.rawGamepadAxes) && Objects.equals(this.gamepadButtons, that.gamepadButtons);
    }

    public int hashCode() {
        return Objects.hash(this.gamepadAxes, this.rawGamepadAxes, this.gamepadButtons);
    }

    public String toString() {
        return "GamepadState[gamepadAxes=" + this.gamepadAxes + ", rawGamepadAxes=" + this.rawGamepadAxes + ", gamepadButtons=" + this.gamepadButtons + "]";
    }

    public record AxesState(float leftStickX, float leftStickY, float rightStickX, float rightStickY, float leftTrigger, float rightTrigger) {
        public static AxesState EMPTY = new AxesState(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);

        public AxesState leftJoystickDeadZone(float deadZone) {
            return new AxesState(ControllerUtils.deadzone(this.leftStickX, deadZone), ControllerUtils.deadzone(this.leftStickY, deadZone), this.rightStickX, this.rightStickY, this.leftTrigger, this.rightTrigger);
        }

        public AxesState rightJoystickDeadZone(float deadZone) {
            return new AxesState(this.leftStickX, this.leftStickY, ControllerUtils.deadzone(this.rightStickX, deadZone), ControllerUtils.deadzone(this.rightStickY, deadZone), this.leftTrigger, this.rightTrigger);
        }

        public AxesState leftTriggerDeadZone(float deadZone) {
            return new AxesState(this.leftStickX, this.leftStickY, this.rightStickX, this.rightStickY, ControllerUtils.deadzone(this.leftTrigger, deadZone), this.rightTrigger);
        }

        public AxesState rightTriggerDeadZone(float deadZone) {
            return new AxesState(this.leftStickX, this.leftStickY, this.rightStickX, this.rightStickY, this.leftTrigger, ControllerUtils.deadzone(this.rightTrigger, deadZone));
        }

        public AxesState neutraliseLeft() {
            return new AxesState(0.0f, 0.0f, this.rightStickX, this.rightStickY, this.leftTrigger, this.rightTrigger);
        }

        public AxesState neutraliseRight() {
            return new AxesState(this.leftStickX, this.leftStickY, 0.0f, 0.0f, this.leftTrigger, this.rightTrigger);
        }
    }

    public record ButtonState(boolean a, boolean b, boolean x, boolean y, boolean leftBumper, boolean rightBumper, boolean back, boolean start, boolean guide, boolean dpadUp, boolean dpadDown, boolean dpadLeft, boolean dpadRight, boolean leftStick, boolean rightStick) {
        public static ButtonState EMPTY = new ButtonState(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
    }

    public static class GyroState
    extends Vector3f
    implements GyroStateC {
        public GyroState(float pitch, float yaw, float roll) {
            super(pitch, yaw, roll);
        }

        public GyroState(GyroStateC vec) {
            super((Vector3fc)vec);
        }

        public GyroState() {
        }

        @Override
        public float pitch() {
            return this.x;
        }

        @Override
        public float yaw() {
            return this.y;
        }

        @Override
        public float roll() {
            return this.z;
        }

        public GyroState mul(Vector3fc v) {
            super.mul(v);
            return this;
        }

        public GyroState mul(float scalar) {
            super.mul(scalar);
            return this;
        }

        public GyroState div(Vector3fc v) {
            super.div(v);
            return this;
        }

        public GyroState div(float scalar) {
            super.div(scalar);
            return this;
        }

        public GyroState sub(Vector3fc v) {
            super.sub(v);
            return this;
        }

        public GyroState sub(float x, float y, float z) {
            super.sub(x, y, z);
            return this;
        }
    }

    public static interface GyroStateC
    extends Vector3fc {
        public float pitch();

        public float yaw();

        public float roll();
    }
}

