/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings;

import com.google.gson.JsonObject;
import dev.isxander.controlify.bindings.IBind;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.joystick.JoystickController;
import dev.isxander.controlify.controller.joystick.JoystickState;
import dev.isxander.controlify.gui.DrawSize;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class JoystickButtonBind
implements IBind<JoystickState> {
    public static final String BIND_ID = "joystick_button";
    private final JoystickController<?> joystick;
    private final int buttonIndex;

    public JoystickButtonBind(JoystickController<?> joystick, int buttonIndex) {
        this.joystick = joystick;
        this.buttonIndex = buttonIndex;
    }

    @Override
    public float state(JoystickState state) {
        return state.buttons().get(this.buttonIndex) != false ? 1.0f : 0.0f;
    }

    @Override
    public void draw(class_332 graphics, int x, int centerY) {
        String type = this.joystick.type().themeId();
        String button = this.joystick.mapping().buttons()[this.buttonIndex].identifier();
        class_2960 texture = new class_2960("controlify", "textures/gui/joystick/" + type + "/button_" + button + ".png");
        graphics.method_25290(texture, x, centerY - 11, 0.0f, 0.0f, 22, 22, 22, 22);
    }

    @Override
    public DrawSize drawSize() {
        return new DrawSize(22, 22);
    }

    @Override
    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("type", BIND_ID);
        object.addProperty("button", (Number)this.buttonIndex);
        return object;
    }

    @Override
    public Controller<JoystickState, ?> controller() {
        return this.joystick;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoystickButtonBind that = (JoystickButtonBind)o;
        return this.buttonIndex == that.buttonIndex && this.joystick.uid().equals(that.joystick.uid());
    }

    public int hashCode() {
        return Objects.hash(this.buttonIndex, this.joystick.uid());
    }

    public static JoystickButtonBind fromJson(JsonObject object, JoystickController<?> joystick) {
        int buttonIndex = object.get("button").getAsInt();
        return new JoystickButtonBind(joystick, buttonIndex);
    }
}

