/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings;

import com.google.gson.JsonObject;
import dev.isxander.controlify.bindings.IBind;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.gamepad.BuiltinGamepadTheme;
import dev.isxander.controlify.controller.gamepad.GamepadConfig;
import dev.isxander.controlify.controller.gamepad.GamepadController;
import dev.isxander.controlify.controller.gamepad.GamepadState;
import dev.isxander.controlify.gui.DrawSize;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class GamepadBind
implements IBind<GamepadState> {
    private final Function<GamepadState, Float> stateSupplier;
    private final String identifier;
    private final GamepadController gamepad;

    public GamepadBind(Function<GamepadState, Float> stateSupplier, String identifier, GamepadController gamepad) {
        this.stateSupplier = stateSupplier;
        this.identifier = identifier;
        this.gamepad = gamepad;
    }

    @Override
    public float state(GamepadState state) {
        return this.stateSupplier.apply(state).floatValue();
    }

    @Override
    public void draw(class_332 graphics, int x, int centerY) {
        class_2960 texture = this.getTexture(((GamepadConfig)this.gamepad.config()).theme);
        graphics.method_25290(texture, x, centerY - 11, 0.0f, 0.0f, 22, 22, 22, 22);
    }

    @Override
    public DrawSize drawSize() {
        return new DrawSize(22, 22);
    }

    public String identifier() {
        return this.identifier;
    }

    @Override
    public Controller<GamepadState, ?> controller() {
        return this.gamepad;
    }

    @Override
    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "gamepad");
        object.addProperty("bind", this.identifier);
        return object;
    }

    private class_2960 getTexture(BuiltinGamepadTheme theme) {
        String themeId = theme.id();
        if (theme == BuiltinGamepadTheme.DEFAULT) {
            themeId = this.gamepad.type().themeId();
        }
        return new class_2960("controlify", "textures/gui/gamepad/" + themeId + "/" + this.identifier + ".png");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GamepadBind that = (GamepadBind)o;
        return this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }
}

