/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.bindings;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.BindingSupplier;
import dev.isxander.controlify.api.bind.ControlifyBindingsApi;
import dev.isxander.controlify.api.bind.ControllerBinding;
import dev.isxander.controlify.api.bind.ControllerBindingBuilder;
import dev.isxander.controlify.api.bind.RadialIcon;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.bindings.BindContexts;
import dev.isxander.controlify.bindings.ControllerBindingImpl;
import dev.isxander.controlify.bindings.EmptyBind;
import dev.isxander.controlify.bindings.GamepadBinds;
import dev.isxander.controlify.bindings.IBind;
import dev.isxander.controlify.bindings.KeyMappingOverrideHolder;
import dev.isxander.controlify.bindings.RadialIcons;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.ControllerConfig;
import dev.isxander.controlify.controller.ControllerState;
import dev.isxander.controlify.controller.gamepad.GamepadController;
import dev.isxander.controlify.mixins.compat.fapi.KeyBindingRegistryImplAccessor;
import dev.isxander.controlify.mixins.feature.bind.KeyMappingAccessor;
import dev.isxander.controlify.mixins.feature.bind.ToggleKeyMappingAccessor;
import dev.isxander.controlify.utils.Log;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_1294;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.minecraft.class_4666;

public class ControllerBindings<T extends ControllerState> {
    private static final Map<class_2960, Function<ControllerBindings<?>, ControllerBinding>> CUSTOM_BINDS = new LinkedHashMap();
    private static final Set<class_304> EXCLUDED_VANILLA_BINDS = new HashSet<class_304>();
    public static final class_2561 MOVEMENT_CATEGORY = class_2561.method_43471((String)"key.categories.movement");
    public static final class_2561 GAMEPLAY_CATEGORY = class_2561.method_43471((String)"key.categories.gameplay");
    public static final class_2561 INVENTORY_CATEGORY = class_2561.method_43471((String)"key.categories.inventory");
    public static final class_2561 CREATIVE_CATEGORY = class_2561.method_43471((String)"key.categories.creative");
    public static final class_2561 VMOUSE_CATEGORY = class_2561.method_43471((String)"controlify.binding_category.vmouse");
    public static final class_2561 GUI_CATEGORY = class_2561.method_43471((String)"controlify.binding_category.gui");
    public static final class_2561 MISC_CATEGORY = class_2561.method_43471((String)"key.categories.misc");
    public static final class_2561 RADIAL_CATEGORY = class_2561.method_43471((String)"controlify.gui.radial_menu");
    public final ControllerBinding WALK_FORWARD;
    public final ControllerBinding WALK_BACKWARD;
    public final ControllerBinding WALK_LEFT;
    public final ControllerBinding WALK_RIGHT;
    public final ControllerBinding LOOK_UP;
    public final ControllerBinding LOOK_DOWN;
    public final ControllerBinding LOOK_LEFT;
    public final ControllerBinding LOOK_RIGHT;
    public final ControllerBinding GAMEPAD_GYRO_BUTTON;
    public final ControllerBinding JUMP;
    public final ControllerBinding SNEAK;
    public final ControllerBinding ATTACK;
    public final ControllerBinding USE;
    public final ControllerBinding SPRINT;
    public final ControllerBinding DROP;
    public final ControllerBinding DROP_STACK;
    public final ControllerBinding NEXT_SLOT;
    public final ControllerBinding PREV_SLOT;
    public final ControllerBinding PAUSE;
    public final ControllerBinding INVENTORY;
    public final ControllerBinding CHANGE_PERSPECTIVE;
    public final ControllerBinding SWAP_HANDS;
    public final ControllerBinding OPEN_CHAT;
    public final ControllerBinding INV_SELECT;
    public final ControllerBinding INV_QUICK_MOVE;
    public final ControllerBinding INV_TAKE_HALF;
    public final ControllerBinding GUI_PRESS;
    public final ControllerBinding GUI_BACK;
    public final ControllerBinding GUI_NEXT_TAB;
    public final ControllerBinding GUI_PREV_TAB;
    public final ControllerBinding GUI_ABSTRACT_ACTION_1;
    public final ControllerBinding GUI_ABSTRACT_ACTION_2;
    public final ControllerBinding PICK_BLOCK;
    public final ControllerBinding PICK_BLOCK_NBT;
    public final ControllerBinding TOGGLE_HUD_VISIBILITY;
    public final ControllerBinding SHOW_PLAYER_LIST;
    public final ControllerBinding TAKE_SCREENSHOT;
    public final ControllerBinding RADIAL_MENU;
    public final ControllerBinding RADIAL_AXIS_UP;
    public final ControllerBinding RADIAL_AXIS_DOWN;
    public final ControllerBinding RADIAL_AXIS_LEFT;
    public final ControllerBinding RADIAL_AXIS_RIGHT;
    public final ControllerBinding VMOUSE_MOVE_UP;
    public final ControllerBinding VMOUSE_MOVE_DOWN;
    public final ControllerBinding VMOUSE_MOVE_LEFT;
    public final ControllerBinding VMOUSE_MOVE_RIGHT;
    public final ControllerBinding VMOUSE_LCLICK;
    public final ControllerBinding VMOUSE_RCLICK;
    public final ControllerBinding VMOUSE_SHIFT_CLICK;
    public final ControllerBinding VMOUSE_SCROLL_UP;
    public final ControllerBinding VMOUSE_SCROLL_DOWN;
    public final ControllerBinding VMOUSE_SHIFT;
    public final ControllerBinding VMOUSE_TOGGLE;
    public final ControllerBinding GUI_NAVI_UP;
    public final ControllerBinding GUI_NAVI_DOWN;
    public final ControllerBinding GUI_NAVI_LEFT;
    public final ControllerBinding GUI_NAVI_RIGHT;
    public final ControllerBinding CYCLE_OPT_FORWARD;
    public final ControllerBinding CYCLE_OPT_BACKWARD;
    private final Map<class_2960, ControllerBinding> registry = new LinkedHashMap<class_2960, ControllerBinding>();
    private final Controller<T, ?> controller;

    public ControllerBindings(Controller<T, ?> controller) {
        GamepadController gamepad;
        this.controller = controller;
        class_315 options = class_310.method_1551().field_1690;
        this.WALK_FORWARD = ControllerBindingBuilder.create(controller).identifier("controlify", "walk_forward").defaultBind(GamepadBinds.LEFT_STICK_FORWARD).category(MOVEMENT_CATEGORY).context(BindContexts.INGAME).build();
        this.register(this.WALK_FORWARD);
        this.WALK_BACKWARD = ControllerBindingBuilder.create(controller).identifier("controlify", "walk_backward").defaultBind(GamepadBinds.LEFT_STICK_BACKWARD).category(MOVEMENT_CATEGORY).context(BindContexts.INGAME).build();
        this.register(this.WALK_BACKWARD);
        this.WALK_LEFT = ControllerBindingBuilder.create(controller).identifier("controlify", "strafe_left").defaultBind(GamepadBinds.LEFT_STICK_LEFT).category(MOVEMENT_CATEGORY).context(BindContexts.INGAME).build();
        this.register(this.WALK_LEFT);
        this.WALK_RIGHT = ControllerBindingBuilder.create(controller).identifier("controlify", "strafe_right").defaultBind(GamepadBinds.LEFT_STICK_RIGHT).category(MOVEMENT_CATEGORY).context(BindContexts.INGAME).build();
        this.register(this.WALK_RIGHT);
        this.LOOK_UP = ControllerBindingBuilder.create(controller).identifier("controlify", "look_up").defaultBind(GamepadBinds.RIGHT_STICK_FORWARD).category(MOVEMENT_CATEGORY).context(BindContexts.INGAME).build();
        this.register(this.LOOK_UP);
        this.LOOK_DOWN = ControllerBindingBuilder.create(controller).identifier("controlify", "look_down").defaultBind(GamepadBinds.RIGHT_STICK_BACKWARD).category(MOVEMENT_CATEGORY).context(BindContexts.INGAME).build();
        this.register(this.LOOK_DOWN);
        this.LOOK_LEFT = ControllerBindingBuilder.create(controller).identifier("controlify", "look_left").defaultBind(GamepadBinds.RIGHT_STICK_LEFT).category(MOVEMENT_CATEGORY).context(BindContexts.INGAME).build();
        this.register(this.LOOK_LEFT);
        this.LOOK_RIGHT = ControllerBindingBuilder.create(controller).identifier("controlify", "look_right").defaultBind(GamepadBinds.RIGHT_STICK_RIGHT).category(MOVEMENT_CATEGORY).context(BindContexts.INGAME).build();
        this.register(this.LOOK_RIGHT);
        if (controller instanceof GamepadController && (gamepad = (GamepadController)controller).hasGyro()) {
            this.GAMEPAD_GYRO_BUTTON = ControllerBindingBuilder.create(controller).identifier("controlify", "gamepad_gyro_button").defaultBind(new EmptyBind()).category(MOVEMENT_CATEGORY).context(BindContexts.INGAME).build();
            this.register(this.GAMEPAD_GYRO_BUTTON);
        } else {
            this.GAMEPAD_GYRO_BUTTON = null;
        }
        this.JUMP = ControllerBindingBuilder.create(controller).identifier("controlify", "jump").defaultBind(GamepadBinds.A_BUTTON).category(MOVEMENT_CATEGORY).context(BindContexts.INGAME).radialCandidate(RadialIcons.getEffect(class_1294.field_5913)).build();
        this.register(this.JUMP);
        this.SPRINT = ControllerBindingBuilder.create(controller).identifier("controlify", "sprint").defaultBind(GamepadBinds.LEFT_STICK_PRESS).category(MOVEMENT_CATEGORY).context(BindContexts.INGAME).vanillaOverride(options.field_1867, () -> ((ControllerConfig)controller.config()).toggleSprint).build();
        this.register(this.SPRINT);
        this.SNEAK = ControllerBindingBuilder.create(controller).identifier("controlify", "sneak").defaultBind(GamepadBinds.RIGHT_STICK_PRESS).category(MOVEMENT_CATEGORY).context(BindContexts.INGAME).build();
        this.register(this.SNEAK);
        this.ATTACK = ControllerBindingBuilder.create(controller).identifier("controlify", "attack").defaultBind(GamepadBinds.RIGHT_TRIGGER).category(GAMEPLAY_CATEGORY).context(BindContexts.INGAME).vanillaOverride(options.field_1886, () -> false).build();
        this.register(this.ATTACK);
        this.USE = ControllerBindingBuilder.create(controller).identifier("controlify", "use").defaultBind(GamepadBinds.LEFT_TRIGGER).category(GAMEPLAY_CATEGORY).context(BindContexts.INGAME).vanillaOverride(options.field_1904, () -> false).build();
        this.register(this.USE);
        this.DROP = ControllerBindingBuilder.create(controller).identifier("controlify", "drop").defaultBind(GamepadBinds.DPAD_DOWN).category(GAMEPLAY_CATEGORY).context(BindContexts.INGAME, BindContexts.INVENTORY).radialCandidate(RadialIcons.getItem(class_1802.field_8077)).build();
        this.register(this.DROP);
        this.DROP_STACK = ControllerBindingBuilder.create(controller).identifier("controlify", "drop_stack").defaultBind(new EmptyBind()).category(GAMEPLAY_CATEGORY).context(BindContexts.INGAME).radialCandidate(RadialIcons.getItem(class_1802.field_8626)).build();
        this.register(this.DROP_STACK);
        this.NEXT_SLOT = ControllerBindingBuilder.create(controller).identifier("controlify", "next_slot").defaultBind(GamepadBinds.RIGHT_BUMPER).category(INVENTORY_CATEGORY).context(BindContexts.INGAME).build();
        this.register(this.NEXT_SLOT);
        this.PREV_SLOT = ControllerBindingBuilder.create(controller).identifier("controlify", "prev_slot").defaultBind(GamepadBinds.LEFT_BUMPER).category(INVENTORY_CATEGORY).context(BindContexts.INGAME).build();
        this.register(this.PREV_SLOT);
        this.PAUSE = ControllerBindingBuilder.create(controller).identifier("controlify", "pause").defaultBind(GamepadBinds.START).category(GAMEPLAY_CATEGORY).context(BindContexts.INGAME).radialCandidate(RadialIcons.getItem(class_1802.field_8615)).build();
        this.register(this.PAUSE);
        this.INVENTORY = ControllerBindingBuilder.create(controller).identifier("controlify", "inventory").defaultBind(GamepadBinds.Y_BUTTON).category(INVENTORY_CATEGORY).context(BindContexts.INGAME).radialCandidate(RadialIcons.getItem(class_1802.field_8106)).build();
        this.register(this.INVENTORY);
        this.CHANGE_PERSPECTIVE = ControllerBindingBuilder.create(controller).identifier("controlify", "change_perspective").defaultBind(GamepadBinds.BACK).category(GAMEPLAY_CATEGORY).context(BindContexts.INGAME).radialCandidate(RadialIcons.getItem(class_1802.field_8892)).build();
        this.register(this.CHANGE_PERSPECTIVE);
        this.SWAP_HANDS = ControllerBindingBuilder.create(controller).identifier("controlify", "swap_hands").defaultBind(GamepadBinds.X_BUTTON).category(INVENTORY_CATEGORY).context(BindContexts.INGAME).radialCandidate(RadialIcons.getItem(class_1802.field_8606)).build();
        this.register(this.SWAP_HANDS);
        this.OPEN_CHAT = ControllerBindingBuilder.create(controller).identifier("controlify", "open_chat").defaultBind(GamepadBinds.DPAD_UP).category(MISC_CATEGORY).context(BindContexts.INGAME).radialCandidate(RadialIcons.getItem(class_1802.field_8674)).vanillaOverride(options.field_1890, () -> false).build();
        this.register(this.OPEN_CHAT);
        this.GUI_PRESS = ControllerBindingBuilder.create(controller).identifier("controlify", "gui_press").defaultBind(GamepadBinds.A_BUTTON).category(GUI_CATEGORY).context(BindContexts.GUI).build();
        this.register(this.GUI_PRESS);
        this.GUI_BACK = ControllerBindingBuilder.create(controller).identifier("controlify", "gui_back").defaultBind(GamepadBinds.B_BUTTON).category(GUI_CATEGORY).context(BindContexts.GUI, BindContexts.GUI_VMOUSE).build();
        this.register(this.GUI_BACK);
        this.GUI_NEXT_TAB = ControllerBindingBuilder.create(controller).identifier("controlify", "gui_next_tab").defaultBind(GamepadBinds.RIGHT_BUMPER).category(GUI_CATEGORY).context(BindContexts.GUI, BindContexts.GUI_VMOUSE).build();
        this.register(this.GUI_NEXT_TAB);
        this.GUI_PREV_TAB = ControllerBindingBuilder.create(controller).identifier("controlify", "gui_prev_tab").defaultBind(GamepadBinds.LEFT_BUMPER).category(GUI_CATEGORY).context(BindContexts.GUI, BindContexts.GUI_VMOUSE).build();
        this.register(this.GUI_PREV_TAB);
        this.GUI_ABSTRACT_ACTION_1 = ControllerBindingBuilder.create(controller).identifier("controlify", "gui_abstract_action_1").defaultBind(GamepadBinds.X_BUTTON).category(GUI_CATEGORY).context(BindContexts.GUI).build();
        this.register(this.GUI_ABSTRACT_ACTION_1);
        this.GUI_ABSTRACT_ACTION_2 = ControllerBindingBuilder.create(controller).identifier("controlify", "gui_abstract_action_2").defaultBind(GamepadBinds.Y_BUTTON).category(GUI_CATEGORY).context(BindContexts.GUI).build();
        this.register(this.GUI_ABSTRACT_ACTION_2);
        this.INV_SELECT = ControllerBindingBuilder.create(controller).identifier("controlify", "inv_select").defaultBind(GamepadBinds.A_BUTTON).category(INVENTORY_CATEGORY).context(BindContexts.INVENTORY).build();
        this.register(this.INV_SELECT);
        this.INV_QUICK_MOVE = ControllerBindingBuilder.create(controller).identifier("controlify", "inv_quick_move").defaultBind(GamepadBinds.Y_BUTTON).category(INVENTORY_CATEGORY).context(BindContexts.INVENTORY).build();
        this.register(this.INV_QUICK_MOVE);
        this.INV_TAKE_HALF = ControllerBindingBuilder.create(controller).identifier("controlify", "inv_take_half").defaultBind(GamepadBinds.X_BUTTON).category(INVENTORY_CATEGORY).context(BindContexts.INVENTORY).build();
        this.register(this.INV_TAKE_HALF);
        this.PICK_BLOCK = ControllerBindingBuilder.create(controller).identifier("controlify", "pick_block").defaultBind(GamepadBinds.DPAD_LEFT).category(GAMEPLAY_CATEGORY).context(BindContexts.INGAME).radialCandidate(RadialIcons.getItem(class_1802.field_8600)).build();
        this.register(this.PICK_BLOCK);
        this.PICK_BLOCK_NBT = ControllerBindingBuilder.create(controller).identifier("controlify", "pick_block_nbt").defaultBind(new EmptyBind()).category(GAMEPLAY_CATEGORY).context(BindContexts.INGAME).radialCandidate(RadialIcons.getItem(class_1802.field_8688)).build();
        this.register(this.PICK_BLOCK_NBT);
        this.TOGGLE_HUD_VISIBILITY = ControllerBindingBuilder.create(controller).identifier("controlify", "toggle_hud_visibility").defaultBind(new EmptyBind()).category(MISC_CATEGORY).context(BindContexts.INGAME).radialCandidate(RadialIcons.getEffect(class_1294.field_5905)).build();
        this.register(this.TOGGLE_HUD_VISIBILITY);
        this.SHOW_PLAYER_LIST = ControllerBindingBuilder.create(controller).identifier("controlify", "show_player_list").defaultBind(new EmptyBind()).category(MISC_CATEGORY).context(BindContexts.INGAME).radialCandidate(RadialIcons.getItem(class_1802.field_8575)).build();
        this.register(this.SHOW_PLAYER_LIST);
        this.TAKE_SCREENSHOT = ControllerBindingBuilder.create(controller).identifier("controlify", "take_screenshot").defaultBind(new EmptyBind()).category(MISC_CATEGORY).context(BindContexts.INGAME).radialCandidate(RadialIcons.getItem(class_1802.field_27070)).build();
        this.register(this.TAKE_SCREENSHOT);
        this.RADIAL_MENU = ControllerBindingBuilder.create(controller).identifier("controlify", "radial_menu").defaultBind(GamepadBinds.DPAD_RIGHT).category(RADIAL_CATEGORY).context(BindContexts.INGAME).build();
        this.register(this.RADIAL_MENU);
        this.RADIAL_AXIS_UP = ControllerBindingBuilder.create(controller).identifier("controlify", "radial_axis_up").defaultBind(GamepadBinds.RIGHT_STICK_FORWARD).category(RADIAL_CATEGORY).context(BindContexts.GUI).build();
        this.register(this.RADIAL_AXIS_UP);
        this.RADIAL_AXIS_DOWN = ControllerBindingBuilder.create(controller).identifier("controlify", "radial_axis_down").defaultBind(GamepadBinds.RIGHT_STICK_BACKWARD).category(RADIAL_CATEGORY).context(BindContexts.GUI).build();
        this.register(this.RADIAL_AXIS_DOWN);
        this.RADIAL_AXIS_LEFT = ControllerBindingBuilder.create(controller).identifier("controlify", "radial_axis_left").defaultBind(GamepadBinds.RIGHT_STICK_LEFT).category(RADIAL_CATEGORY).context(BindContexts.GUI).build();
        this.register(this.RADIAL_AXIS_LEFT);
        this.RADIAL_AXIS_RIGHT = ControllerBindingBuilder.create(controller).identifier("controlify", "radial_axis_right").defaultBind(GamepadBinds.RIGHT_STICK_RIGHT).category(RADIAL_CATEGORY).context(BindContexts.GUI).build();
        this.register(this.RADIAL_AXIS_RIGHT);
        this.VMOUSE_MOVE_UP = ControllerBindingBuilder.create(controller).identifier("controlify", "vmouse_move_up").defaultBind(GamepadBinds.LEFT_STICK_FORWARD).category(VMOUSE_CATEGORY).context(BindContexts.GUI_VMOUSE_CURSOR_ONLY).build();
        this.register(this.VMOUSE_MOVE_UP);
        this.VMOUSE_MOVE_DOWN = ControllerBindingBuilder.create(controller).identifier("controlify", "vmouse_move_down").defaultBind(GamepadBinds.LEFT_STICK_BACKWARD).category(VMOUSE_CATEGORY).context(BindContexts.GUI_VMOUSE_CURSOR_ONLY).build();
        this.register(this.VMOUSE_MOVE_DOWN);
        this.VMOUSE_MOVE_LEFT = ControllerBindingBuilder.create(controller).identifier("controlify", "vmouse_move_left").defaultBind(GamepadBinds.LEFT_STICK_LEFT).category(VMOUSE_CATEGORY).context(BindContexts.GUI_VMOUSE_CURSOR_ONLY).build();
        this.register(this.VMOUSE_MOVE_LEFT);
        this.VMOUSE_MOVE_RIGHT = ControllerBindingBuilder.create(controller).identifier("controlify", "vmouse_move_right").defaultBind(GamepadBinds.LEFT_STICK_RIGHT).category(VMOUSE_CATEGORY).context(BindContexts.GUI_VMOUSE_CURSOR_ONLY).build();
        this.register(this.VMOUSE_MOVE_RIGHT);
        this.VMOUSE_LCLICK = ControllerBindingBuilder.create(controller).identifier("controlify", "vmouse_lclick").defaultBind(GamepadBinds.A_BUTTON).category(VMOUSE_CATEGORY).context(BindContexts.GUI_VMOUSE).build();
        this.register(this.VMOUSE_LCLICK);
        this.VMOUSE_RCLICK = ControllerBindingBuilder.create(controller).identifier("controlify", "vmouse_rclick").defaultBind(GamepadBinds.X_BUTTON).category(VMOUSE_CATEGORY).context(BindContexts.GUI_VMOUSE).build();
        this.register(this.VMOUSE_RCLICK);
        this.VMOUSE_SHIFT_CLICK = ControllerBindingBuilder.create(controller).identifier("controlify", "vmouse_shift_click").defaultBind(GamepadBinds.Y_BUTTON).category(VMOUSE_CATEGORY).context(BindContexts.GUI_VMOUSE).build();
        this.register(this.VMOUSE_SHIFT_CLICK);
        this.VMOUSE_SCROLL_UP = ControllerBindingBuilder.create(controller).identifier("controlify", "vmouse_scroll_up").defaultBind(GamepadBinds.RIGHT_STICK_FORWARD).category(VMOUSE_CATEGORY).context(BindContexts.GUI_VMOUSE).build();
        this.register(this.VMOUSE_SCROLL_UP);
        this.VMOUSE_SCROLL_DOWN = ControllerBindingBuilder.create(controller).identifier("controlify", "vmouse_scroll_down").defaultBind(GamepadBinds.RIGHT_STICK_BACKWARD).category(VMOUSE_CATEGORY).context(BindContexts.GUI_VMOUSE).build();
        this.register(this.VMOUSE_SCROLL_DOWN);
        this.VMOUSE_SHIFT = ControllerBindingBuilder.create(controller).identifier("controlify", "vmouse_shift").defaultBind(GamepadBinds.LEFT_STICK_PRESS).category(VMOUSE_CATEGORY).context(BindContexts.GUI_VMOUSE).build();
        this.register(this.VMOUSE_SHIFT);
        this.VMOUSE_TOGGLE = ControllerBindingBuilder.create(controller).identifier("controlify", "vmouse_toggle").defaultBind(GamepadBinds.BACK).category(VMOUSE_CATEGORY).context(BindContexts.GUI_VMOUSE, BindContexts.GUI).build();
        this.register(this.VMOUSE_TOGGLE);
        this.GUI_NAVI_UP = ControllerBindingBuilder.create(controller).identifier("controlify", "gui_navi_up").defaultBind(GamepadBinds.LEFT_STICK_FORWARD).category(GUI_CATEGORY).context(BindContexts.GUI).build();
        this.register(this.GUI_NAVI_UP);
        this.GUI_NAVI_DOWN = ControllerBindingBuilder.create(controller).identifier("controlify", "gui_navi_down").defaultBind(GamepadBinds.LEFT_STICK_BACKWARD).category(GUI_CATEGORY).context(BindContexts.GUI).build();
        this.register(this.GUI_NAVI_DOWN);
        this.GUI_NAVI_LEFT = ControllerBindingBuilder.create(controller).identifier("controlify", "gui_navi_left").defaultBind(GamepadBinds.LEFT_STICK_LEFT).category(GUI_CATEGORY).context(BindContexts.GUI).build();
        this.register(this.GUI_NAVI_LEFT);
        this.GUI_NAVI_RIGHT = ControllerBindingBuilder.create(controller).identifier("controlify", "gui_navi_right").defaultBind(GamepadBinds.LEFT_STICK_RIGHT).category(GUI_CATEGORY).context(BindContexts.GUI).build();
        this.register(this.GUI_NAVI_RIGHT);
        this.CYCLE_OPT_FORWARD = ControllerBindingBuilder.create(controller).identifier("controlify", "cycle_opt_forward").defaultBind(GamepadBinds.RIGHT_STICK_RIGHT).category(GUI_CATEGORY).context(BindContexts.GUI).build();
        this.register(this.CYCLE_OPT_FORWARD);
        this.CYCLE_OPT_BACKWARD = ControllerBindingBuilder.create(controller).identifier("controlify", "cycle_opt_backward").defaultBind(GamepadBinds.RIGHT_STICK_LEFT).category(GUI_CATEGORY).context(BindContexts.GUI).build();
        this.register(this.CYCLE_OPT_BACKWARD);
        for (Function<ControllerBindings<?>, ControllerBinding> constructor : CUSTOM_BINDS.values()) {
            this.register(constructor.apply(this));
        }
        this.registerModdedKeybinds();
        ControlifyEvents.CONTROLLER_STATE_UPDATE.register(ctrl -> {
            if (ctrl == this.controller) {
                this.imitateVanillaClick();
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> this.registry().values().forEach(ControllerBinding::tick));
        ControlifyEvents.INPUT_MODE_CHANGED.register(mode -> class_304.method_1437());
    }

    public ControllerBinding register(ControllerBinding binding) {
        this.registry.put(binding.id(), binding);
        if (binding.override() != null) {
            ((KeyMappingOverrideHolder)binding.override().keyMapping()).controlify$addOverride(binding);
        }
        return binding;
    }

    private ControllerBinding create(UnaryOperator<ControllerBindingBuilder<?>> builder) {
        return ((ControllerBindingBuilder)builder.apply(ControllerBindingBuilder.create(this.controller))).build();
    }

    @Deprecated
    private ControllerBinding create(GamepadBinds bind, class_2960 id) {
        return ControllerBindingBuilder.create(this.controller).identifier(id).defaultBind(bind).build();
    }

    @Deprecated
    private ControllerBinding create(GamepadBinds bind, class_2960 id, class_304 override, BooleanSupplier toggleOverride) {
        return ControllerBindingBuilder.create(this.controller).identifier(id).defaultBind(bind).vanillaOverride(override, toggleOverride).build();
    }

    public ControllerBinding get(class_2960 id) {
        return this.registry.get(id);
    }

    public Map<class_2960, ControllerBinding> registry() {
        return Collections.unmodifiableMap(this.registry);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        for (ControllerBinding binding : this.registry().values()) {
            json.add(binding.id().toString(), (JsonElement)binding.toJson());
        }
        return json;
    }

    public boolean fromJson(JsonObject json) {
        boolean clean = true;
        for (ControllerBinding binding : this.registry().values()) {
            if (!json.has(binding.id().toString())) {
                Log.LOGGER.warn("Missing binding: " + binding.id() + " in config file. Skipping!");
                clean = false;
                continue;
            }
            JsonObject bind = json.get(binding.id().toString()).getAsJsonObject();
            if (bind == null) {
                Log.LOGGER.warn("Unknown binding: " + binding.id() + " in config file. Skipping!");
                clean = false;
                continue;
            }
            ((ControllerBindingImpl)binding).setCurrentBind(IBind.fromJson(bind, this.controller));
        }
        return clean;
    }

    private void registerModdedKeybinds() {
        for (class_304 keyMapping : KeyBindingRegistryImplAccessor.getCustomKeys()) {
            if (EXCLUDED_VANILLA_BINDS.contains(keyMapping)) continue;
            try {
                String idPath = keyMapping.method_1431().toLowerCase().replaceAll("[^a-z0-9/._-]", "_").trim();
                class_2960 identifier = new class_2960("fabric-key-binding-api-v1", idPath);
                BooleanSupplier toggleOverride = () -> false;
                if (keyMapping instanceof class_4666) {
                    class_4666 toggleKeyMapping = (class_4666)keyMapping;
                    toggleOverride = ((ToggleKeyMappingAccessor)toggleKeyMapping).getNeedsToggle();
                }
                ControllerBinding binding = ControllerBindingBuilder.create(this.controller).identifier(identifier).defaultBind(new EmptyBind()).name((class_2561)class_2561.method_43471((String)keyMapping.method_1431())).description((class_2561)class_2561.method_43471((String)"controlify.custom_binding.vanilla_description").method_27692(class_124.field_1080)).category((class_2561)class_2561.method_43471((String)keyMapping.method_1423())).radialCandidate(RadialIcons.FABRIC_ICON).vanillaOverride(keyMapping, toggleOverride).build();
                this.register(binding);
            }
            catch (Exception e) {
                Log.LOGGER.error("Failed to automatically register modded keybind: " + keyMapping.method_1431(), (Throwable)e);
            }
        }
    }

    private void imitateVanillaClick() {
        ControllerBindingImpl.clearPressedBinds(this.controller);
        if (!Controlify.instance().currentInputMode().isController()) {
            return;
        }
        if (class_310.method_1551().field_1755 != null) {
            return;
        }
        for (ControllerBinding binding : this.registry().values()) {
            ControllerBinding.KeyMappingOverride override = binding.override();
            if (override == null) continue;
            KeyMappingAccessor accessor = (KeyMappingAccessor)override.keyMapping();
            class_3675.class_306 vanillaKeyCode = accessor.getKey();
            if (override.toggleable().getAsBoolean() && binding.justPressed()) {
                accessor.setIsDown(!accessor.getIsDown());
            }
            if (!binding.justPressed()) continue;
            class_304.method_1420((class_3675.class_306)vanillaKeyCode);
        }
    }

    public static final class Api
    implements ControlifyBindingsApi {
        public static final Api INSTANCE = new Api();

        @Override
        public BindingSupplier registerBind(class_2960 id, UnaryOperator<ControllerBindingBuilder<?>> builder) {
            CUSTOM_BINDS.put(id, bindings -> bindings.create(b -> ((ControllerBindingBuilder)builder.apply((ControllerBindingBuilder<?>)b)).identifier(id)));
            return controller -> controller.bindings().get(id);
        }

        @Override
        @Deprecated
        public BindingSupplier registerBind(GamepadBinds bind, class_2960 id) {
            CUSTOM_BINDS.put(id, bindings -> bindings.create(bind, id));
            return controller -> controller.bindings().get(id);
        }

        @Override
        @Deprecated
        public BindingSupplier registerBind(GamepadBinds bind, class_2960 id, class_304 override, BooleanSupplier toggleOverride) {
            CUSTOM_BINDS.put(id, bindings -> bindings.create(bind, id, override, toggleOverride));
            return controller -> controller.bindings().get(id);
        }

        @Override
        public void excludeVanillaBind(class_304 ... keyMappings) {
            EXCLUDED_VANILLA_BINDS.addAll(Arrays.asList(keyMappings));
        }

        @Override
        public void registerRadialIcon(class_2960 id, RadialIcon icon) {
            RadialIcons.registerIcon(id, icon);
        }
    }
}

