/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify;

import dev.isxander.controlify.ControllerManager;
import dev.isxander.controlify.InputMode;
import dev.isxander.controlify.api.ControlifyApi;
import dev.isxander.controlify.api.entrypoint.ControlifyEntrypoint;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.compatibility.ControlifyCompat;
import dev.isxander.controlify.config.ControlifyConfig;
import dev.isxander.controlify.controller.Controller;
import dev.isxander.controlify.controller.ControllerConfig;
import dev.isxander.controlify.controller.ControllerState;
import dev.isxander.controlify.controller.sdl2.SDL2NativesManager;
import dev.isxander.controlify.debug.DebugProperties;
import dev.isxander.controlify.gui.controllers.ControllerBindHandler;
import dev.isxander.controlify.gui.guide.InGameButtonGuide;
import dev.isxander.controlify.gui.screen.ControllerCalibrationScreen;
import dev.isxander.controlify.gui.screen.ControllerCarouselScreen;
import dev.isxander.controlify.gui.screen.SDLOnboardingScreen;
import dev.isxander.controlify.gui.screen.SubmitUnknownControllerScreen;
import dev.isxander.controlify.hid.ControllerHIDService;
import dev.isxander.controlify.ingame.ControllerPlayerMovement;
import dev.isxander.controlify.ingame.InGameInputHandler;
import dev.isxander.controlify.mixins.feature.virtualmouse.MouseHandlerAccessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.server.EntityVibrationPacket;
import dev.isxander.controlify.server.OriginVibrationPacket;
import dev.isxander.controlify.server.ServerPolicies;
import dev.isxander.controlify.server.ServerPolicy;
import dev.isxander.controlify.server.ServerPolicyPacket;
import dev.isxander.controlify.server.VibrationPacket;
import dev.isxander.controlify.utils.DebugLog;
import dev.isxander.controlify.utils.Log;
import dev.isxander.controlify.utils.ToastUtils;
import dev.isxander.controlify.virtualmouse.VirtualMouseHandler;
import dev.isxander.controlify.wireless.LowBatteryNotifier;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3673;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class Controlify
implements ControlifyApi {
    private static Controlify instance = null;
    private final class_310 minecraft = class_310.method_1551();
    private Controller<?, ?> currentController = null;
    private InGameInputHandler inGameInputHandler;
    public InGameButtonGuide inGameButtonGuide;
    private VirtualMouseHandler virtualMouseHandler;
    private InputMode currentInputMode = InputMode.KEYBOARD_MOUSE;
    private ControllerHIDService controllerHIDService;
    private CompletableFuture<Boolean> nativeOnboardingFuture = null;
    private final ControlifyConfig config = new ControlifyConfig(this);
    private final Queue<Controller<?, ?>> calibrationQueue = new ArrayDeque();
    private boolean canDiscoverControllers = true;
    private int consecutiveInputSwitches = 0;
    private double lastInputSwitchTime = 0.0;
    private int showMouseTicks = 0;
    @Nullable
    private Controller<?, ?> switchableController = null;
    private double askSwitchTime = 0.0;
    private ToastUtils.ControlifyToast askSwitchToast = null;

    public void initializeControlify() {
        Log.LOGGER.info("Initializing Controlify...");
        this.config().load();
        ControlifyCompat.init();
        boolean controllersConnected = IntStream.range(0, 16).anyMatch(GLFW::glfwJoystickPresent);
        if (controllersConnected) {
            if (!this.config().globalSettings().delegateSetup) {
                this.askNatives().whenComplete((loaded, th) -> this.discoverControllers());
            } else {
                ToastUtils.sendToast((class_2561)class_2561.method_43471((String)"controlify.toast.setup_in_config.title"), (class_2561)class_2561.method_43469((String)"controlify.toast.setup_in_config.description", (Object[])new Object[]{class_2561.method_43471((String)"options.title"), class_2561.method_43471((String)"controls.keybinds.title"), class_2561.method_43470((String)"Controlify")}), false);
            }
        }
        ClientTickEvents.START_CLIENT_TICK.register(this::tick);
        ClientLifecycleEvents.CLIENT_STOPPING.register(minecraft -> this.controllerHIDService().stop());
        GLFW.glfwSetJoystickCallback((jid, event) -> {
            try {
                this.askNatives().whenComplete((loaded, th) -> {
                    if (event == 262145) {
                        this.onControllerHotplugged(jid);
                    } else if (event == 262146) {
                        this.onControllerDisconnect(jid);
                    }
                });
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
        this.notifyOfNewFeatures();
    }

    private CompletableFuture<Boolean> askNatives() {
        if (this.nativeOnboardingFuture != null) {
            return this.nativeOnboardingFuture;
        }
        if (this.config().globalSettings().vibrationOnboarded) {
            boolean loadNatives = this.config().globalSettings().loadVibrationNatives;
            if (loadNatives && !SDL2NativesManager.isInitialised()) {
                SDL2NativesManager.initialise();
            }
            return CompletableFuture.completedFuture(loadNatives);
        }
        this.nativeOnboardingFuture = new CompletableFuture();
        class_437 parent = this.minecraft.field_1755;
        this.minecraft.method_1507((class_437)new SDLOnboardingScreen(() -> parent, answer -> {
            if (answer) {
                SDL2NativesManager.initialise();
            }
            this.nativeOnboardingFuture.complete(answer);
        }));
        return this.nativeOnboardingFuture;
    }

    public void discoverControllers() {
        if (!this.canDiscoverControllers) {
            throw new IllegalStateException("Already discovered/cannot discover controllers");
        }
        this.canDiscoverControllers = false;
        DebugLog.log("Discovering and initializing controllers...", new Object[0]);
        if (this.config().globalSettings().loadVibrationNatives) {
            SDL2NativesManager.initialise();
        }
        for (int jid = 0; jid <= 15; ++jid) {
            Optional<Controller<?, ?>> controllerOpt;
            if (!GLFW.glfwJoystickPresent((int)jid) || (controllerOpt = ControllerManager.createOrGet(jid, this.controllerHIDService.fetchType(jid))).isEmpty()) continue;
            Controller<?, ?> controller = controllerOpt.get();
            Log.LOGGER.info("Controller found: " + controller.name());
            this.config().loadOrCreateControllerData(controller);
            if (SubmitUnknownControllerScreen.canSubmit(controller)) {
                this.minecraft.method_1507((class_437)new SubmitUnknownControllerScreen(controller, this.minecraft.field_1755));
            }
            if (controller.uid().equals(this.config().currentControllerUid())) {
                this.setCurrentController(controller);
            }
            if (!((ControllerConfig)controller.config()).allowVibrations || this.config().globalSettings().loadVibrationNatives) continue;
            ((ControllerConfig)controller.config()).allowVibrations = false;
            this.config().setDirty();
        }
        if (ControllerManager.getConnectedControllers().isEmpty()) {
            Log.LOGGER.info("No controllers found.");
        }
        if (this.getCurrentController().isEmpty()) {
            Controller controller = ControllerManager.getConnectedControllers().stream().findFirst().orElse(null);
            if (controller != null && ((ControllerConfig)controller.config()).delayedCalibration) {
                controller = null;
            }
            this.setCurrentController(controller);
        } else {
            this.config().saveIfDirty();
        }
        FabricLoader.getInstance().getEntrypoints("controlify", ControlifyEntrypoint.class).forEach(entrypoint -> {
            try {
                entrypoint.onControllersDiscovered(this);
            }
            catch (Throwable e) {
                Log.LOGGER.error("Failed to run `onControllersDiscovered` on Controlify entrypoint: " + entrypoint.getClass().getName(), e);
            }
        });
    }

    public void preInitialiseControlify() {
        DebugProperties.printProperties();
        Log.LOGGER.info("Pre-initializing Controlify...");
        this.inGameInputHandler = null;
        this.virtualMouseHandler = new VirtualMouseHandler();
        this.controllerHIDService = new ControllerHIDService();
        this.controllerHIDService.start();
        ControllerBindHandler.setup();
        ClientPlayNetworking.registerGlobalReceiver(VibrationPacket.TYPE, (packet, player, sender) -> {
            if (this.config().globalSettings().allowServerRumble) {
                this.getCurrentController().ifPresent(controller -> controller.rumbleManager().play(packet.source(), packet.createEffect()));
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(OriginVibrationPacket.TYPE, (packet, player, sender) -> {
            if (this.config().globalSettings().allowServerRumble) {
                this.getCurrentController().ifPresent(controller -> controller.rumbleManager().play(packet.source(), packet.createEffect()));
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(EntityVibrationPacket.TYPE, (packet, player, sender) -> {
            if (this.config().globalSettings().allowServerRumble) {
                this.getCurrentController().ifPresent(controller -> controller.rumbleManager().play(packet.source(), packet.createEffect()));
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(ServerPolicyPacket.TYPE, (packet, player, sender) -> {
            Log.LOGGER.info("Connected server specified '{}' policy is {}.", (Object)packet.id(), (Object)(packet.allowed() ? "ALLOWED" : "DISALLOWED"));
            ServerPolicies.getById(packet.id()).set(ServerPolicy.fromBoolean(packet.allowed()));
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            DebugLog.log("Disconnected from server, resetting server policies", new Object[0]);
            ServerPolicies.unsetAll();
        });
        FabricLoader.getInstance().getEntrypoints("controlify", ControlifyEntrypoint.class).forEach(entrypoint -> {
            try {
                entrypoint.onControlifyPreInit(this);
            }
            catch (Exception e) {
                Log.LOGGER.error("Failed to run `onControlifyPreInit` on Controlify entrypoint: " + entrypoint.getClass().getName(), (Throwable)e);
            }
        });
    }

    public void tick(class_310 client) {
        if (this.minecraft.method_18506() == null && !this.calibrationQueue.isEmpty() && !(this.minecraft.field_1755 instanceof SDLOnboardingScreen)) {
            class_437 screen = this.minecraft.field_1755;
            while (!this.calibrationQueue.isEmpty()) {
                screen = new ControllerCalibrationScreen(this.calibrationQueue.poll(), screen);
            }
            this.minecraft.method_1507(screen);
        }
        boolean outOfFocus = !this.config().globalSettings().outOfFocusInput && !client.method_1569();
        for (Controller<?, ?> controller : ControllerManager.getConnectedControllers()) {
            if (!outOfFocus) {
                Controlify.wrapControllerError(controller::updateState, "Updating controller state", controller);
            } else {
                Controlify.wrapControllerError(controller::clearState, "Clearing controller state", controller);
            }
            ((ControlifyEvents.ControllerStateUpdate)ControlifyEvents.CONTROLLER_STATE_UPDATE.invoker()).onControllerStateUpdate(controller);
        }
        if (this.switchableController != null && class_3673.method_15974() - this.askSwitchTime <= 10000.0 && this.switchableController.state().hasAnyInput()) {
            this.switchableController.clearState();
            this.setCurrentController(this.switchableController);
            if (this.askSwitchToast != null) {
                this.askSwitchToast.remove();
                this.askSwitchToast = null;
            }
        }
        if (this.minecraft.field_1729.method_1613()) {
            this.showMouseTicks = 0;
        }
        if (this.currentInputMode() == InputMode.MIXED && this.showMouseTicks > 0) {
            --this.showMouseTicks;
            if (this.showMouseTicks == 0) {
                this.hideMouse(true, false);
                if (this.virtualMouseHandler().requiresVirtualMouse()) {
                    this.virtualMouseHandler().enableVirtualMouse();
                }
            }
        }
        LowBatteryNotifier.tick();
        this.getCurrentController().ifPresent(currentController -> Controlify.wrapControllerError(() -> this.tickController((Controller<?, ?>)currentController, outOfFocus), "Ticking current controller", currentController));
    }

    private void tickController(Controller<?, ?> controller, boolean outOfFocus) {
        Object state = controller.state();
        if (outOfFocus) {
            state = ControllerState.EMPTY;
            controller.rumbleManager().setSilent(true);
        } else {
            controller.rumbleManager().setSilent(false);
            controller.rumbleManager().tick();
        }
        if (state.hasAnyInput()) {
            this.setInputMode(((ControllerConfig)controller.config()).mixedInput ? InputMode.MIXED : InputMode.CONTROLLER);
        }
        if (this.consecutiveInputSwitches > 100) {
            Log.LOGGER.warn("Controlify detected current controller to be constantly giving input and has been disabled.");
            ToastUtils.sendToast((class_2561)class_2561.method_43471((String)"controlify.toast.faulty_input.title"), (class_2561)class_2561.method_43471((String)"controlify.toast.faulty_input.description"), true);
            this.setCurrentController(null);
            this.consecutiveInputSwitches = 0;
            return;
        }
        this.virtualMouseHandler().handleControllerInput(controller);
        if (this.minecraft.field_1755 != null) {
            ScreenProcessorProvider.provide(this.minecraft.field_1755).onControllerUpdate(controller);
        }
        if (this.minecraft.field_1687 != null) {
            this.inGameInputHandler().ifPresent(InGameInputHandler::inputTick);
        }
        ((ControlifyEvents.ControllerStateUpdate)ControlifyEvents.ACTIVE_CONTROLLER_TICKED.invoker()).onControllerStateUpdate(controller);
    }

    public static void wrapControllerError(Runnable runnable, String errorTitle, Controller<?, ?> controller) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            class_128 crashReport = class_128.method_560((Throwable)e, (String)errorTitle);
            class_129 category = crashReport.method_562("Affected controller");
            category.method_578("Controller name", (Object)controller.name());
            category.method_578("Controller identification", (Object)controller.type().toString());
            category.method_578("Controller type", (Object)controller.getClass().getCanonicalName());
            throw new class_148(crashReport);
        }
    }

    public ControlifyConfig config() {
        return this.config;
    }

    private void onControllerHotplugged(int jid) {
        Optional<Controller<?, ?>> controllerOpt = ControllerManager.createOrGet(jid, this.controllerHIDService.fetchType(jid));
        if (controllerOpt.isEmpty()) {
            return;
        }
        Controller<?, ?> controller = controllerOpt.get();
        Log.LOGGER.info("Controller connected: " + controller.name());
        this.config().loadOrCreateControllerData(controller);
        if (SubmitUnknownControllerScreen.canSubmit(controller)) {
            this.minecraft.method_1507((class_437)new SubmitUnknownControllerScreen(controller, this.minecraft.field_1755));
        }
        this.canDiscoverControllers = false;
        if (this.config().globalSettings().delegateSetup) {
            this.config().globalSettings().delegateSetup = false;
            this.config().setDirty();
        }
        if (((ControllerConfig)controller.config()).allowVibrations && !this.config().globalSettings().loadVibrationNatives) {
            ((ControllerConfig)controller.config()).allowVibrations = false;
            this.config().setDirty();
        }
        if (ControllerManager.getConnectedControllers().size() == 1) {
            this.setCurrentController(controller);
            ToastUtils.sendToast((class_2561)class_2561.method_43471((String)"controlify.toast.default_controller_connected.title"), (class_2561)class_2561.method_43471((String)"controlify.toast.default_controller_connected.description"), false);
        } else {
            this.askToSwitchController(controller);
            this.config().saveIfDirty();
        }
        class_437 class_4372 = this.minecraft.field_1755;
        if (class_4372 instanceof ControllerCarouselScreen) {
            ControllerCarouselScreen controllerListScreen = (ControllerCarouselScreen)class_4372;
            controllerListScreen.refreshControllers();
        }
    }

    private void onControllerDisconnect(int jid) {
        ControllerManager.getConnectedControllers().stream().filter(controller -> controller.joystickId() == jid).findAny().ifPresent(controller -> {
            ControllerManager.disconnect(controller);
            controller.hidInfo().ifPresent(this.controllerHIDService::unconsumeController);
            this.setCurrentController(ControllerManager.getConnectedControllers().stream().findFirst().orElse(null));
            Log.LOGGER.info("Controller disconnected: " + controller.name());
            this.setInputMode(this.currentController == null ? InputMode.KEYBOARD_MOUSE : InputMode.CONTROLLER);
            ToastUtils.sendToast((class_2561)class_2561.method_43471((String)"controlify.toast.controller_disconnected.title"), (class_2561)class_2561.method_43469((String)"controlify.toast.controller_disconnected.description", (Object[])new Object[]{controller.name()}), false);
            class_437 patt18501$temp = this.minecraft.field_1755;
            if (patt18501$temp instanceof ControllerCarouselScreen) {
                ControllerCarouselScreen controllerListScreen = (ControllerCarouselScreen)patt18501$temp;
                controllerListScreen.refreshControllers();
            }
        });
    }

    private void askToSwitchController(Controller<?, ?> controller) {
        this.switchableController = controller;
        this.askSwitchTime = class_3673.method_15974();
        this.askSwitchToast = ToastUtils.sendToast((class_2561)class_2561.method_43471((String)"controlify.toast.ask_to_switch.title"), (class_2561)class_2561.method_43469((String)"controlify.toast.ask_to_switch.description", (Object[])new Object[]{controller.name()}), true);
    }

    @Override
    @Deprecated
    @NotNull
    public Controller<?, ?> currentController() {
        if (this.currentController == null) {
            return Controller.DUMMY;
        }
        return this.currentController;
    }

    @Override
    @NotNull
    public Optional<Controller<?, ?>> getCurrentController() {
        return Optional.ofNullable(this.currentController);
    }

    public void setCurrentController(@Nullable Controller<?, ?> controller) {
        if (this.currentController == controller) {
            return;
        }
        this.currentController = controller;
        if (this.switchableController == controller) {
            this.switchableController = null;
        }
        if (controller == null) {
            this.setInputMode(InputMode.KEYBOARD_MOUSE);
            this.inGameInputHandler = null;
            this.inGameButtonGuide = null;
            DebugLog.log("Updated current controller to null", new Object[0]);
            this.config().save();
            return;
        }
        DebugLog.log("Updated current controller to {}({})", controller.name(), controller.uid());
        if (!controller.uid().equals(this.config().currentControllerUid())) {
            this.config().save();
        }
        this.inGameInputHandler = new InGameInputHandler(controller);
        this.setInputMode(((ControllerConfig)controller.config()).mixedInput ? InputMode.MIXED : InputMode.CONTROLLER);
        if (!((ControllerConfig)controller.config()).deadzonesCalibrated) {
            this.calibrationQueue.add(controller);
        }
    }

    public Optional<InGameInputHandler> inGameInputHandler() {
        return Optional.ofNullable(this.inGameInputHandler);
    }

    public Optional<InGameButtonGuide> inGameButtonGuide() {
        return Optional.ofNullable(this.inGameButtonGuide);
    }

    public VirtualMouseHandler virtualMouseHandler() {
        return this.virtualMouseHandler;
    }

    public ControllerHIDService controllerHIDService() {
        return this.controllerHIDService;
    }

    @Override
    @NotNull
    public InputMode currentInputMode() {
        return this.currentInputMode;
    }

    @Override
    public boolean setInputMode(@NotNull InputMode currentInputMode) {
        if (this.currentInputMode == currentInputMode) {
            return false;
        }
        this.currentInputMode = currentInputMode;
        if (!this.minecraft.field_1729.method_1613()) {
            this.hideMouse(currentInputMode.isController(), true);
        }
        if (this.minecraft.field_1755 != null) {
            ScreenProcessorProvider.provide(this.minecraft.field_1755).onInputModeChanged(currentInputMode);
        }
        if (class_310.method_1551().field_1724 != null) {
            this.inGameButtonGuide = currentInputMode == InputMode.KEYBOARD_MOUSE ? null : (InGameButtonGuide)this.getCurrentController().map(c -> new InGameButtonGuide((Controller<?, ?>)c, class_310.method_1551().field_1724)).orElse(null);
        }
        this.consecutiveInputSwitches = class_3673.method_15974() - this.lastInputSwitchTime < 20.0 ? ++this.consecutiveInputSwitches : 0;
        this.lastInputSwitchTime = class_3673.method_15974();
        if (this.currentInputMode.isController()) {
            this.getCurrentController().ifPresent(Controller::clearState);
        }
        ControllerPlayerMovement.updatePlayerInput(this.minecraft.field_1724);
        ((ControlifyEvents.InputModeChanged)ControlifyEvents.INPUT_MODE_CHANGED.invoker()).onInputModeChanged(currentInputMode);
        return true;
    }

    public void hideMouse(boolean hide, boolean moveMouse) {
        GLFW.glfwSetInputMode((long)this.minecraft.method_22683().method_4490(), (int)208897, (int)(hide ? 212994 : 212993));
        if (this.minecraft.field_1755 != null) {
            MouseHandlerAccessor mouseHandlerAccessor = (MouseHandlerAccessor)this.minecraft.field_1729;
            if (hide && !this.virtualMouseHandler().isVirtualMouseEnabled() && moveMouse) {
                mouseHandlerAccessor.invokeOnMove(this.minecraft.method_22683().method_4490(), -50.0, -50.0);
            }
        }
    }

    public void showCursorTemporarily() {
        if (this.currentInputMode() == InputMode.MIXED && !this.minecraft.field_1729.method_1613()) {
            this.hideMouse(false, false);
            this.showMouseTicks = 40;
            if (this.virtualMouseHandler().isVirtualMouseEnabled()) {
                this.virtualMouseHandler().disableVirtualMouse();
            }
        }
    }

    private void notifyOfNewFeatures() {
        if (this.config().isFirstLaunch()) {
            return;
        }
        Iterator<String> newFeatureVersions = List.of("1.5.0").iterator();
        String foundVersion = null;
        while (foundVersion == null && newFeatureVersions.hasNext()) {
            String version = newFeatureVersions.next();
            if (!this.config().isLastSeenVersionLessThan(version)) continue;
            foundVersion = version;
        }
        if (foundVersion != null) {
            Log.LOGGER.info("Sending new features toast for {}", foundVersion);
            ToastUtils.sendToast((class_2561)class_2561.method_43469((String)"controlify.new_features.title", (Object[])new Object[]{foundVersion}), (class_2561)class_2561.method_43471((String)("controlify.new_features." + foundVersion)), true);
        }
    }

    public static Controlify instance() {
        if (instance == null) {
            instance = new Controlify();
        }
        return instance;
    }

    public static class_2960 id(String path) {
        return new class_2960("controlify", path);
    }
}

