/*
 * Decompiled with CFR 0.152.
 */
package forge.net.raphimc.immediatelyfast.injection.mixins.hud_batching.consumer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forge.net.raphimc.immediatelyfast.feature.batching.BatchingBuffers;
import forge.net.raphimc.immediatelyfast.feature.batching.BatchingRenderLayers;
import forge.net.raphimc.immediatelyfast.feature.batching.BlendFuncDepthFunc;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class}, priority=500)
public abstract class MixinDrawContext {
    @Shadow
    @Final
    private PoseStack f_279612_;
    @Shadow
    @Final
    private Minecraft f_279544_;
    @Unique
    private MultiBufferSource immediatelyFast$prevFillConsumer = null;
    @Unique
    private MultiBufferSource immediatelyFast$prevTextConsumer = null;
    @Unique
    private MultiBufferSource immediatelyFast$prevTextureConsumer = null;

    @Inject(method={"fill(Lnet/minecraft/client/render/RenderLayer;IIIIII)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void fillIntoBuffer(RenderType layer, int x1, int y1, int x2, int y2, int z, int color, CallbackInfo ci) {
        if (BatchingBuffers.FILL_CONSUMER != null) {
            ci.cancel();
            if (x1 < x2) {
                x1 ^= x2;
                x2 = x1 ^ x2;
                x1 ^= x2;
            }
            if (y1 < y2) {
                y1 ^= y2;
                y2 = y1 ^ y2;
                y1 ^= y2;
            }
            Matrix4f matrix = this.f_279612_.m_85850_().m_252922_();
            float[] shaderColor = RenderSystem.getShaderColor();
            int argb = (int)(shaderColor[3] * 255.0f) << 24 | (int)(shaderColor[0] * 255.0f) << 16 | (int)(shaderColor[1] * 255.0f) << 8 | (int)(shaderColor[2] * 255.0f);
            color = FastColor.ARGB32.m_13657_((int)color, (int)argb);
            VertexConsumer vertexConsumer = BatchingBuffers.FILL_CONSUMER.m_6299_(layer);
            vertexConsumer.m_252986_(matrix, (float)x1, (float)y2, (float)z).m_193479_(color).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)x2, (float)y2, (float)z).m_193479_(color).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)x2, (float)y1, (float)z).m_193479_(color).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)x1, (float)y1, (float)z).m_193479_(color).m_5752_();
        }
    }

    @Inject(method={"drawTexturedQuad(Lnet/minecraft/util/Identifier;IIIIIFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void drawTexturedQuadIntoBuffer(ResourceLocation texture, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, CallbackInfo ci) {
        if (BatchingBuffers.TEXTURE_CONSUMER != null) {
            ci.cancel();
            Matrix4f matrix = this.f_279612_.m_85850_().m_252922_();
            float[] shaderColor = RenderSystem.getShaderColor();
            int r = (int)(shaderColor[0] * 255.0f);
            int g = (int)(shaderColor[1] * 255.0f);
            int b = (int)(shaderColor[2] * 255.0f);
            int a = (int)(shaderColor[3] * 255.0f);
            VertexConsumer vertexConsumer = BatchingBuffers.TEXTURE_CONSUMER.m_6299_(BatchingRenderLayers.COLORED_TEXTURE.apply(this.f_279544_.m_91097_().m_118506_(texture).m_117963_(), BlendFuncDepthFunc.current()));
            vertexConsumer.m_252986_(matrix, (float)x1, (float)y2, (float)z).m_7421_(u1, v2).m_6122_(r, g, b, a).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)x2, (float)y2, (float)z).m_7421_(u2, v2).m_6122_(r, g, b, a).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)x2, (float)y1, (float)z).m_7421_(u2, v1).m_6122_(r, g, b, a).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)x1, (float)y1, (float)z).m_7421_(u1, v1).m_6122_(r, g, b, a).m_5752_();
        }
    }

    @Inject(method={"drawTexturedQuad(Lnet/minecraft/util/Identifier;IIIIIFFFFFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void drawTexturedQuadIntoBuffer(ResourceLocation texture, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, float red, float green, float blue, float alpha, CallbackInfo ci) {
        if (BatchingBuffers.TEXTURE_CONSUMER != null) {
            ci.cancel();
            Matrix4f matrix = this.f_279612_.m_85850_().m_252922_();
            float[] shaderColor = RenderSystem.getShaderColor();
            int argb = (int)(shaderColor[3] * 255.0f) << 24 | (int)(shaderColor[0] * 255.0f) << 16 | (int)(shaderColor[1] * 255.0f) << 8 | (int)(shaderColor[2] * 255.0f);
            int color = FastColor.ARGB32.m_13657_((int)((int)(alpha * 255.0f) << 24 | (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f)), (int)argb);
            RenderSystem.enableBlend();
            VertexConsumer vertexConsumer = BatchingBuffers.TEXTURE_CONSUMER.m_6299_(BatchingRenderLayers.COLORED_TEXTURE.apply(this.f_279544_.m_91097_().m_118506_(texture).m_117963_(), BlendFuncDepthFunc.current()));
            vertexConsumer.m_252986_(matrix, (float)x1, (float)y2, (float)z).m_7421_(u1, v2).m_193479_(color).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)x2, (float)y2, (float)z).m_7421_(u2, v2).m_193479_(color).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)x2, (float)y1, (float)z).m_7421_(u2, v1).m_193479_(color).m_5752_();
            vertexConsumer.m_252986_(matrix, (float)x1, (float)y1, (float)z).m_7421_(u1, v1).m_193479_(color).m_5752_();
            RenderSystem.disableBlend();
        }
    }

    @ModifyArg(method={"drawItem(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;IIII)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/item/ItemRenderer;renderItem(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/render/model/json/ModelTransformationMode;ZLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IILnet/minecraft/client/render/model/BakedModel;)V"))
    private MultiBufferSource renderItemIntoBuffer(ItemStack stack, ItemDisplayContext renderMode, boolean leftHanded, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, BakedModel model) {
        if (BatchingBuffers.LIT_ITEM_MODEL_CONSUMER != null || BatchingBuffers.UNLIT_ITEM_MODEL_CONSUMER != null) {
            return model.m_7547_() ? BatchingBuffers.LIT_ITEM_MODEL_CONSUMER : BatchingBuffers.UNLIT_ITEM_MODEL_CONSUMER;
        }
        return vertexConsumers;
    }

    @Inject(method={"drawItemInSlot(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="HEAD")})
    private void renderItemOverlayIntoBufferStart(Font textRenderer, ItemStack stack, int x, int y, String countOverride, CallbackInfo ci) {
        if (BatchingBuffers.ITEM_OVERLAY_CONSUMER != null) {
            this.immediatelyFast$prevFillConsumer = BatchingBuffers.FILL_CONSUMER;
            this.immediatelyFast$prevTextConsumer = BatchingBuffers.TEXT_CONSUMER;
            this.immediatelyFast$prevTextureConsumer = BatchingBuffers.TEXTURE_CONSUMER;
            BatchingBuffers.FILL_CONSUMER = BatchingBuffers.ITEM_OVERLAY_CONSUMER;
            BatchingBuffers.TEXT_CONSUMER = BatchingBuffers.ITEM_OVERLAY_CONSUMER;
            BatchingBuffers.TEXTURE_CONSUMER = BatchingBuffers.ITEM_OVERLAY_CONSUMER;
        }
    }

    @Inject(method={"drawItemInSlot(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/item/ItemStack;IILjava/lang/String;)V"}, at={@At(value="RETURN")})
    private void renderItemOverlayIntoBufferEnd(Font textRenderer, ItemStack stack, int x, int y, String countOverride, CallbackInfo ci) {
        if (BatchingBuffers.ITEM_OVERLAY_CONSUMER != null) {
            BatchingBuffers.FILL_CONSUMER = this.immediatelyFast$prevFillConsumer;
            BatchingBuffers.TEXT_CONSUMER = this.immediatelyFast$prevTextConsumer;
            BatchingBuffers.TEXTURE_CONSUMER = this.immediatelyFast$prevTextureConsumer;
        }
    }
}

