/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.fabrishot.capture;

import java.nio.ByteBuffer;
import me.ramidzkh.fabrishot.MinecraftInterface;
import me.ramidzkh.fabrishot.capture.Dimension;
import me.ramidzkh.fabrishot.event.FramebufferCaptureCallback;
import org.lwjgl.opengl.GL11;

public class FramebufferCapturer {
    private static final int COMPONENT_COUNT = 3;
    private static final int BYTES_PER_PIXEL = 3;
    private final ByteBuffer bb;
    private final Dimension dim = this.getCurrentDimension();

    public FramebufferCapturer() {
        this.bb = ByteBuffer.allocateDirect(this.dim.width() * this.dim.height() * 3);
    }

    public int getBytesPerPixel() {
        return 3;
    }

    public int getChannelCount() {
        return 3;
    }

    public ByteBuffer getDataBuffer() {
        return this.bb;
    }

    public Dimension getCaptureDimension() {
        return this.dim;
    }

    private Dimension getCurrentDimension() {
        return new Dimension(MinecraftInterface.getDisplayWidth(), MinecraftInterface.getDisplayHeight());
    }

    public void capture() {
        Dimension dim2;
        Dimension dim1 = this.getCurrentDimension();
        if (!dim1.equals(dim2 = this.getCaptureDimension())) {
            throw new IllegalStateException(String.format("Display size changed! %s != %s", dim1, dim2));
        }
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        MinecraftInterface.writeFramebuffer(this.bb, 3);
        this.bb.rewind();
        ((FramebufferCaptureCallback)FramebufferCaptureCallback.EVENT.invoker()).onCapture(dim2, this.bb);
    }
}

