/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.fabricskyboxes_interop.client.config;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.flashyreese.mods.fabricskyboxes_interop.FSBInterop;
import me.flashyreese.mods.fabricskyboxes_interop.client.config.FSBInteropConfig;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSBInteropConfigScreen
extends class_437 {
    private final class_437 parent;
    private final FSBInteropConfig config;
    private final Logger logger = LoggerFactory.getLogger((String)"FSB-Interop");

    public FSBInteropConfigScreen(class_437 parent, FSBInteropConfig config) {
        super((class_2561)class_2561.method_43471((String)FSBInteropConfigScreen.getTranslationKey("title")));
        this.parent = parent;
        this.config = config;
    }

    private static String getTranslationKey(String optionKey) {
        return "options.fsb-interop." + optionKey;
    }

    private static String getTooltipKey(String translationKey) {
        return translationKey + ".tooltip";
    }

    protected void method_25426() {
        this.method_37063((class_364)this.createBooleanOptionButton(this.field_22789 / 2 - 100 - 110, this.field_22790 / 2 - 10 - 12, 200, 20, "interoperability", value -> {
            this.config.interoperability = value;
        }, () -> this.config.interoperability, () -> class_310.method_1551().method_1521()));
        this.method_37063((class_364)this.createBooleanOptionButton(this.field_22789 / 2 - 100 + 110, this.field_22790 / 2 - 10 - 12, 200, 20, "prefer_fsb_native", value -> {
            this.config.preferFSBNative = value;
        }, () -> this.config.preferFSBNative, this::reloadResourcesIfInterop));
        this.method_37063((class_364)this.createBooleanOptionButton(this.field_22789 / 2 - 100 - 110, this.field_22790 / 2 - 10 + 12, 200, 20, "process_optifine", value -> {
            this.config.processOptiFine = value;
        }, () -> this.config.processOptiFine, this::reloadResourcesIfInterop));
        this.method_37063((class_364)this.createBooleanOptionButton(this.field_22789 / 2 - 100 + 110, this.field_22790 / 2 - 10 + 12, 200, 20, "process_mcpatcher", value -> {
            this.config.processMCPatcher = value;
        }, () -> this.config.processMCPatcher, this::reloadResourcesIfInterop));
        this.method_37063((class_364)this.createBooleanOptionButton(this.field_22789 / 2 - 100 - 110, this.field_22790 / 2 - 10 + 36, 200, 20, "debug_mode", value -> {
            this.config.debugMode = value;
        }, () -> this.config.debugMode, () -> {}));
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)FSBInteropConfigScreen.getTranslationKey("dump_data")), button -> {
            Path path = FabricLoader.getInstance().getGameDir().resolve("fsb-interop-dump");
            try {
                if (Files.exists(path, new LinkOption[0])) {
                    if (FSBInteropConfig.INSTANCE.debugMode) {
                        this.logger.info("Existing dump directory detected. Recursively deleting the contents...");
                    }
                    Files.walk(path, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).filter(File::delete).forEach(file -> {
                        if (FSBInteropConfig.INSTANCE.debugMode) {
                            this.logger.info("Deleted: {}", (Object)file.getAbsolutePath());
                        }
                    });
                }
            }
            catch (IOException e) {
                this.logger.error("Error while deleting existing dump directory: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
            try {
                if (!Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path, new FileAttribute[0]);
                    if (FSBInteropConfig.INSTANCE.debugMode) {
                        this.logger.info("Dump directory created: {}", (Object)path.toAbsolutePath());
                    }
                }
                FSBInterop.getInstance().getConvertedSkyMap().forEach((identifier, json) -> {
                    String filename = identifier.toString();
                    filename = filename.replaceAll("[^a-zA-Z0-9-_\\.]", "_");
                    Path output = path.resolve(filename + ".json");
                    try {
                        Files.write(output, json.getBytes(), new OpenOption[0]);
                        if (FSBInteropConfig.INSTANCE.debugMode) {
                            this.logger.info("Successfully dumped {} to {}", identifier, (Object)output.toAbsolutePath());
                        }
                    }
                    catch (IOException e) {
                        this.logger.error("Error while dumping {} to {}: {}", new Object[]{identifier, output.toAbsolutePath(), e.getMessage()});
                        e.printStackTrace();
                    }
                });
                if (FSBInteropConfig.INSTANCE.debugMode) {
                    this.logger.info("Opening dump directory: {}", (Object)path.toAbsolutePath());
                }
                class_156.method_668().method_673(path.toUri());
            }
            catch (IOException e) {
                this.logger.error("Error while creating dump directory: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }).method_46434(this.field_22789 / 2 - 100 + 110, this.field_22790 / 2 - 10 + 36, 200, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)FSBInteropConfigScreen.getTooltipKey(FSBInteropConfigScreen.getTranslationKey("dump_data"))))).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 40, 200, 20).method_46431());
    }

    private void reloadResourcesIfInterop() {
        if (this.config.interoperability) {
            this.field_22787.method_1521();
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 30, 0xFFFFFF);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public void method_25432() {
        this.config.writeChanges();
    }

    private class_4185 createBooleanOptionButton(int x, int y, int width, int height, String key, Consumer<Boolean> consumer, Supplier<Boolean> supplier, Runnable onChange) {
        String translationKey = FSBInteropConfigScreen.getTranslationKey(key);
        class_5250 text = class_2561.method_43471((String)translationKey);
        class_5250 tooltipText = class_2561.method_43471((String)FSBInteropConfigScreen.getTooltipKey(translationKey));
        return class_4185.method_46430((class_2561)class_5244.method_30619((class_2561)text, (boolean)supplier.get()), arg_0 -> FSBInteropConfigScreen.lambda$createBooleanOptionButton$16(supplier, (class_2561)text, consumer, onChange, arg_0)).method_46434(x, y, width, height).method_46436(class_7919.method_47407((class_2561)tooltipText)).method_46431();
    }

    private static /* synthetic */ void lambda$createBooleanOptionButton$16(Supplier supplier, class_2561 text, Consumer consumer, Runnable onChange, class_4185 button) {
        boolean newValue = (Boolean)supplier.get() == false;
        button.method_25355((class_2561)class_5244.method_30619((class_2561)text, (boolean)newValue));
        consumer.accept(newValue);
        onChange.run();
    }
}

