/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation;

import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.models.EMFModelPart;
import traben.entity_model_features.models.animation.EMFAnimationHelper;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum EMFModelOrRenderVariable {
    TX{

        @Override
        public void setValue(EMFModelPart modelPart, float value) {
            if (modelPart == null) {
                return;
            }
            modelPart.field_3657 = value;
        }

        @Override
        public float getValue(class_630 modelPart) {
            if (modelPart == null) {
                return 0.0f;
            }
            return modelPart.field_3657;
        }
    }
    ,
    TY{

        @Override
        public void setValue(EMFModelPart modelPart, float value) {
            if (modelPart == null) {
                return;
            }
            modelPart.field_3656 = value;
        }

        @Override
        public float getValue(class_630 modelPart) {
            if (modelPart == null) {
                return 0.0f;
            }
            return modelPart.field_3656;
        }
    }
    ,
    TZ{

        @Override
        public void setValue(EMFModelPart modelPart, float value) {
            if (modelPart == null) {
                return;
            }
            modelPart.field_3655 = value;
        }

        @Override
        public float getValue(class_630 modelPart) {
            if (modelPart == null) {
                return 0.0f;
            }
            return modelPart.field_3655;
        }
    }
    ,
    RX{

        @Override
        public void setValue(EMFModelPart modelPart, float value) {
            if (modelPart == null) {
                return;
            }
            modelPart.field_3654 = value;
        }

        @Override
        public float getValue(class_630 modelPart) {
            if (modelPart == null) {
                return 0.0f;
            }
            return modelPart.field_3654;
        }
    }
    ,
    RY{

        @Override
        public void setValue(EMFModelPart modelPart, float value) {
            if (modelPart == null) {
                return;
            }
            modelPart.field_3675 = value;
        }

        @Override
        public float getValue(class_630 modelPart) {
            if (modelPart == null) {
                return 0.0f;
            }
            return modelPart.field_3675;
        }
    }
    ,
    RZ{

        @Override
        public void setValue(EMFModelPart modelPart, float value) {
            if (modelPart == null) {
                return;
            }
            modelPart.field_3674 = value;
        }

        @Override
        public float getValue(class_630 modelPart) {
            if (modelPart == null) {
                return 0.0f;
            }
            return modelPart.field_3674;
        }
    }
    ,
    SX{

        @Override
        public void setValue(EMFModelPart modelPart, float value) {
            if (modelPart == null) {
                return;
            }
            modelPart.field_37938 = value;
        }

        @Override
        public float getValue(class_630 modelPart) {
            if (modelPart == null) {
                return 0.0f;
            }
            return modelPart.field_37938;
        }
    }
    ,
    SY{

        @Override
        public void setValue(EMFModelPart modelPart, float value) {
            if (modelPart == null) {
                return;
            }
            modelPart.field_37939 = value;
        }

        @Override
        public float getValue(class_630 modelPart) {
            if (modelPart == null) {
                return 0.0f;
            }
            return modelPart.field_37939;
        }
    }
    ,
    SZ{

        @Override
        public void setValue(EMFModelPart modelPart, float value) {
            if (modelPart == null) {
                return;
            }
            modelPart.field_37940 = value;
        }

        @Override
        public float getValue(class_630 modelPart) {
            if (modelPart == null) {
                return 0.0f;
            }
            return modelPart.field_37940;
        }
    }
    ,
    VISIBLE{

        @Override
        public void setValue(EMFModelPart modelPart, float value) {
            if (modelPart == null) {
                return;
            }
            modelPart.field_3665 = value == 1.0f;
        }

        @Override
        public float getValue(class_630 modelPart) {
            if (modelPart == null) {
                return 0.0f;
            }
            return modelPart.field_3665 ? 1.0f : 0.0f;
        }
    }
    ,
    VISIBLE_BOXES{

        @Override
        public void setValue(EMFModelPart modelPart, float value) {
            if (modelPart == null) {
                return;
            }
            modelPart.field_38456 = value == 1.0f;
        }

        @Override
        public float getValue(class_630 modelPart) {
            if (modelPart == null) {
                return 0.0f;
            }
            return modelPart.field_38456 ? 1.0f : 0.0f;
        }
    }
    ,
    RENDER_shadow_size{

        @Override
        public void setValue(EMFModelPart ignored, float value) {
            EMFAnimationHelper.setShadowSize(value);
        }

        @Override
        public float getValue(class_630 ignored) {
            return EMFAnimationHelper.getShadowSize();
        }

        @Override
        public boolean isRenderVariable() {
            return true;
        }
    }
    ,
    RENDER_SHADOW_OPACITY{

        @Override
        public void setValue(EMFModelPart ignored, float value) {
            EMFAnimationHelper.setShadowOpacity(value);
        }

        @Override
        public float getValue(class_630 ignored) {
            return EMFAnimationHelper.getShadowOpacity();
        }

        @Override
        public boolean isRenderVariable() {
            return true;
        }
    }
    ,
    RENDER_SHADOW_X{

        @Override
        public void setValue(EMFModelPart ignored, float value) {
            EMFAnimationHelper.setShadowX(value);
        }

        @Override
        public float getValue(class_630 ignored) {
            return EMFAnimationHelper.getShadowX();
        }

        @Override
        public boolean isRenderVariable() {
            return true;
        }
    }
    ,
    RENDER_SHADOW_Z{

        @Override
        public void setValue(EMFModelPart ignored, float value) {
            EMFAnimationHelper.setShadowZ(value);
        }

        @Override
        public float getValue(class_630 ignored) {
            return EMFAnimationHelper.getShadowZ();
        }

        @Override
        public boolean isRenderVariable() {
            return true;
        }
    }
    ,
    RENDER_LEASH_X{

        @Override
        public void setValue(EMFModelPart ignored, float value) {
            EMFAnimationHelper.setLeashX(value);
        }

        @Override
        public float getValue(class_630 ignored) {
            return EMFAnimationHelper.getLeashX();
        }

        @Override
        public boolean isRenderVariable() {
            return true;
        }
    }
    ,
    RENDER_LEASH_Y{

        @Override
        public void setValue(EMFModelPart ignored, float value) {
            EMFAnimationHelper.setLeashY(value);
        }

        @Override
        public float getValue(class_630 ignored) {
            return EMFAnimationHelper.getLeashY();
        }

        @Override
        public boolean isRenderVariable() {
            return true;
        }
    }
    ,
    RENDER_LEASH_Z{

        @Override
        public void setValue(EMFModelPart ignored, float value) {
            EMFAnimationHelper.setLeashZ(value);
        }

        @Override
        public float getValue(class_630 ignored) {
            return EMFAnimationHelper.getLeashZ();
        }

        @Override
        public boolean isRenderVariable() {
            return true;
        }
    };


    @Nullable
    public static EMFModelOrRenderVariable getRenderVariable(String id) {
        if (id == null) {
            return null;
        }
        return switch (id) {
            case "render.shadow_size" -> RENDER_shadow_size;
            case "render.shadow_opacity" -> RENDER_SHADOW_OPACITY;
            case "render.shadow_offset_x" -> RENDER_SHADOW_X;
            case "render.shadow_offset_z" -> RENDER_SHADOW_Z;
            case "render.leash_offset_x" -> RENDER_LEASH_X;
            case "render.leash_offset_y" -> RENDER_LEASH_Y;
            case "render.leash_offset_z" -> RENDER_LEASH_Z;
            default -> null;
        };
    }

    @Nullable
    public static EMFModelOrRenderVariable get(String id) {
        if (id == null) {
            return null;
        }
        return switch (id) {
            case "tx" -> TX;
            case "ty" -> TY;
            case "tz" -> TZ;
            case "rx" -> RX;
            case "ry" -> RY;
            case "rz" -> RZ;
            case "sx" -> SX;
            case "sy" -> SY;
            case "sz" -> SZ;
            case "visible" -> VISIBLE;
            case "visible_boxes" -> VISIBLE_BOXES;
            default -> null;
        };
    }

    public boolean isRenderVariable() {
        return false;
    }

    public abstract float getValue(class_630 var1);

    public float getValue() {
        return this.getValue(null);
    }

    abstract void setValue(EMFModelPart var1, float var2);
}

