/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation;

import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.UUID;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.EMFModelPart;
import traben.entity_model_features.models.animation.EMFAnimationHelper;
import traben.entity_model_features.models.animation.EMFModelOrRenderVariable;
import traben.entity_model_features.models.animation.animation_math_parser.MathComponent;
import traben.entity_model_features.models.animation.animation_math_parser.MathExpressionParser;

public class EMFAnimation {
    public final EMFModelPart partToApplyTo;
    public final EMFModelOrRenderVariable variableToChange;
    public final String animKey;
    public final String expressionString;
    public final String modelName;
    public final boolean isVariable;
    public final Object2FloatOpenHashMap<UUID> prevResult = new Object2FloatOpenHashMap();
    final float defaultValue;
    public Object2ObjectLinkedOpenHashMap<String, EMFAnimation> emfAnimationVariables = null;
    public Object2ObjectOpenHashMap<String, EMFModelPart> allPartsBySingleAndFullHeirachicalId = null;
    MathComponent EMFCalculator = MathExpressionParser.NULL_EXPRESSION;

    public EMFAnimation(EMFModelPart partToApplyTo, EMFModelOrRenderVariable variableToChange, String animKey, String initialExpression, String modelName) {
        this.modelName = modelName;
        this.animKey = animKey;
        this.isVariable = animKey.startsWith("var");
        this.variableToChange = this.isVariable ? null : variableToChange;
        this.partToApplyTo = partToApplyTo;
        if (this.variableToChange != null) {
            if (partToApplyTo == null) {
                if (this.variableToChange.isRenderVariable()) {
                    this.defaultValue = this.variableToChange.getValue();
                } else {
                    if (EMFConfig.getConfig().logModelCreationData) {
                        System.out.println("null part for " + animKey);
                    }
                    this.defaultValue = 0.0f;
                }
            } else {
                this.defaultValue = this.variableToChange.getValue(partToApplyTo);
            }
        } else {
            this.defaultValue = 0.0f;
        }
        this.prevResult.defaultReturnValue(this.defaultValue);
        this.expressionString = initialExpression;
    }

    public String toString() {
        return this.animKey;
    }

    public void initExpression(Object2ObjectLinkedOpenHashMap<String, EMFAnimation> emfAnimationVariables, Object2ObjectOpenHashMap<String, EMFModelPart> allPartByName) {
        this.emfAnimationVariables = emfAnimationVariables;
        this.allPartsBySingleAndFullHeirachicalId = allPartByName;
        this.EMFCalculator = MathExpressionParser.getOptimizedExpression(this.expressionString, false, this);
        this.emfAnimationVariables = null;
        this.allPartsBySingleAndFullHeirachicalId = null;
    }

    public float getLastResultOnly() {
        if (EMFAnimationHelper.getEMFEntity() == null) {
            return 0.0f;
        }
        return this.prevResult.getFloat((Object)EMFAnimationHelper.getEMFEntity().getUuid());
    }

    public float getResultViaCalculate() {
        UUID id;
        UUID uUID = id = EMFAnimationHelper.getEMFEntity() == null ? null : EMFAnimationHelper.getEMFEntity().getUuid();
        if (id == null) {
            return 0.0f;
        }
        float result = this.calculatorRun();
        result = result == Float.MIN_VALUE ? 0.0f : result;
        this.prevResult.put((Object)id, result);
        return result;
    }

    public float calculatorRun() {
        return this.EMFCalculator.get();
    }

    public void calculateAndSet() {
        if (this.isVariable) {
            this.getResultViaCalculate();
        } else {
            this.handleResult(this.getResultViaCalculate());
        }
    }

    private void handleResult(float result) {
        if (this.variableToChange != null) {
            if (Double.isNaN(result)) {
                this.variableToChange.setValue(this.partToApplyTo, Float.MAX_VALUE);
            } else {
                this.variableToChange.setValue(this.partToApplyTo, result);
            }
        }
    }

    public boolean isValid() {
        return this.EMFCalculator != MathExpressionParser.NULL_EXPRESSION;
    }
}

