/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vertices;

import java.nio.ByteBuffer;
import java.util.function.IntFunction;
import net.coderbot.iris.vertices.IrisVertexFormats;
import net.coderbot.iris.vertices.NormI8;
import net.coderbot.iris.vertices.NormalHelper;
import net.coderbot.iris.vertices.QuadView;
import net.irisshaders.iris.api.v0.IrisTextVertexSink;
import net.minecraft.class_293;
import net.minecraft.class_4608;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryUtil;

public class IrisTextVertexSinkImpl
implements IrisTextVertexSink {
    static class_293 format = IrisVertexFormats.ENTITY;
    private final ByteBuffer buffer;
    private final TextQuadView quad = new TextQuadView();
    private final Vector3f saveNormal = new Vector3f();
    private static final int STRIDE = IrisVertexFormats.ENTITY.method_1362();
    private int vertexCount;
    private long elementOffset;
    private float uSum;
    private float vSum;
    private static final int OFFSET_POSITION = 0;
    private static final int OFFSET_COLOR = 12;
    private static final int OFFSET_TEXTURE = 16;
    private static final int OFFSET_MID_TEXTURE = 42;
    private static final int OFFSET_OVERLAY = 24;
    private static final int OFFSET_LIGHT = 28;
    private static final int OFFSET_NORMAL = 32;
    private static final int OFFSET_TANGENT = 50;

    public IrisTextVertexSinkImpl(int n, IntFunction<ByteBuffer> intFunction) {
        this.buffer = intFunction.apply(format.method_1362() * 4 * n);
        this.elementOffset = MemoryUtil.memAddress((ByteBuffer)this.buffer);
    }

    @Override
    public class_293 getUnderlyingVertexFormat() {
        return format;
    }

    @Override
    public ByteBuffer getUnderlyingByteBuffer() {
        return this.buffer;
    }

    @Override
    public void quad(float f, float f2, float f3, float f4, float f5, int n, float f6, float f7, float f8, float f9, int n2) {
        this.vertex(f, f2, f5, n, f6, f7, n2);
        this.vertex(f, f4, f5, n, f6, f9, n2);
        this.vertex(f3, f4, f5, n, f8, f9, n2);
        this.vertex(f3, f2, f5, n, f8, f7, n2);
    }

    private void vertex(float f, float f2, float f3, int n, float f4, float f5, int n2) {
        ++this.vertexCount;
        this.uSum += f4;
        this.vSum += f5;
        long l = this.elementOffset;
        MemoryUtil.memPutFloat((long)(l + 0L + 0L), (float)f);
        MemoryUtil.memPutFloat((long)(l + 0L + 4L), (float)f2);
        MemoryUtil.memPutFloat((long)(l + 0L + 8L), (float)f3);
        MemoryUtil.memPutInt((long)(l + 12L), (int)n);
        MemoryUtil.memPutFloat((long)(l + 16L + 0L), (float)f4);
        MemoryUtil.memPutFloat((long)(l + 16L + 4L), (float)f5);
        MemoryUtil.memPutInt((long)(l + 28L), (int)n2);
        MemoryUtil.memPutInt((long)(l + 24L), (int)class_4608.field_21444);
        if (this.vertexCount == 4) {
            this.vertexCount = 0;
            this.uSum = (float)((double)this.uSum * 0.25);
            this.vSum = (float)((double)this.vSum * 0.25);
            this.quad.setup(this.elementOffset, IrisVertexFormats.ENTITY.method_1362());
            NormalHelper.computeFaceNormal(this.saveNormal, this.quad);
            float f6 = this.saveNormal.x;
            float f7 = this.saveNormal.y;
            float f8 = this.saveNormal.z;
            int n3 = NormI8.pack(f6, f7, f8, 0.0f);
            int n4 = NormalHelper.computeTangent(f6, f7, f8, this.quad);
            for (long i = 0L; i < 4L; ++i) {
                MemoryUtil.memPutFloat((long)(l + 42L - (long)STRIDE * i), (float)this.uSum);
                MemoryUtil.memPutFloat((long)(l + 46L - (long)STRIDE * i), (float)this.vSum);
                MemoryUtil.memPutInt((long)(l + 32L - (long)STRIDE * i), (int)n3);
                MemoryUtil.memPutInt((long)(l + 50L - (long)STRIDE * i), (int)n4);
            }
            this.uSum = 0.0f;
            this.vSum = 0.0f;
        }
        this.buffer.position(this.buffer.position() + STRIDE);
        this.elementOffset += (long)STRIDE;
    }

    static class TextQuadView
    implements QuadView {
        long writePointer;
        int stride;

        public void setup(long l, int n) {
            this.writePointer = l;
            this.stride = n;
        }

        @Override
        public float x(int n) {
            return MemoryUtil.memGetFloat((long)(this.writePointer - (long)this.stride * (3L - (long)n)));
        }

        @Override
        public float y(int n) {
            return MemoryUtil.memGetFloat((long)(this.writePointer + 4L - (long)this.stride * (3L - (long)n)));
        }

        @Override
        public float z(int n) {
            return MemoryUtil.memGetFloat((long)(this.writePointer + 8L - (long)this.stride * (3L - (long)n)));
        }

        @Override
        public float u(int n) {
            return MemoryUtil.memGetFloat((long)(this.writePointer + 16L - (long)this.stride * (3L - (long)n)));
        }

        @Override
        public float v(int n) {
            return MemoryUtil.memGetFloat((long)(this.writePointer + 20L - (long)this.stride * (3L - (long)n)));
        }
    }
}

