/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.parsing;

import java.util.Collection;
import kroppeb.stareval.expression.Expression;
import kroppeb.stareval.expression.VariableExpression;
import kroppeb.stareval.function.FunctionContext;
import kroppeb.stareval.function.FunctionReturn;
import kroppeb.stareval.function.Type;
import kroppeb.stareval.function.TypedFunction;
import net.coderbot.iris.parsing.VectorType;

public class BooleanVectorizedFunction
implements TypedFunction {
    final TypedFunction inner;
    final int size;
    final TypedFunction.Parameter[] parameters;
    private final ElementAccessExpression[] vectorAccessors;
    private int index;

    public BooleanVectorizedFunction(TypedFunction typedFunction, int n) {
        this.inner = typedFunction;
        this.size = n;
        TypedFunction.Parameter[] parameterArray = typedFunction.getParameters();
        this.parameters = new TypedFunction.Parameter[parameterArray.length];
        this.vectorAccessors = new ElementAccessExpression[parameterArray.length];
        for (int i = 0; i < parameterArray.length; ++i) {
            this.parameters[i] = new TypedFunction.Parameter(VectorType.of((Type.Primitive)parameterArray[i].type(), n));
            this.vectorAccessors[i] = new ElementAccessExpression(parameterArray[i].type());
        }
    }

    @Override
    public Type getReturnType() {
        return Type.Boolean;
    }

    @Override
    public TypedFunction.Parameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public void evaluateTo(Expression[] expressionArray, FunctionContext functionContext, FunctionReturn functionReturn) {
        int n;
        for (n = 0; n < expressionArray.length; ++n) {
            Expression expression = expressionArray[n];
            expression.evaluateTo(functionContext, functionReturn);
            this.vectorAccessors[n].vector = functionReturn.objectReturn;
        }
        n = 0;
        while (n < this.size) {
            this.index = n++;
            this.inner.evaluateTo(this.vectorAccessors, functionContext, functionReturn);
            if (functionReturn.booleanReturn) continue;
            return;
        }
    }

    class ElementAccessExpression
    implements Expression {
        final Type parameterType;
        Object vector;

        ElementAccessExpression(Type type) {
            this.parameterType = type;
        }

        @Override
        public void evaluateTo(FunctionContext functionContext, FunctionReturn functionReturn) {
            this.parameterType.getValueFromArray(this.vector, BooleanVectorizedFunction.this.index, functionReturn);
        }

        @Override
        public void listVariables(Collection<? super VariableExpression> collection) {
            throw new IllegalStateException();
        }
    }
}

