/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.core.render.immediate.consumer;

import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.api.vertex.attributes.CommonVertexAttribute;
import net.caffeinemc.mods.sodium.api.vertex.attributes.common.ColorAttribute;
import net.caffeinemc.mods.sodium.api.vertex.attributes.common.TextureAttribute;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.VertexFormatDescription;
import net.minecraft.class_2350;
import net.minecraft.class_4583;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={class_4583.class})
public class OverlayVertexConsumerMixin
implements VertexBufferWriter {
    @Shadow
    @Final
    private class_4588 field_20866;
    @Shadow
    @Final
    private Matrix3f field_21054;
    @Shadow
    @Final
    private Matrix4f field_21053;
    @Shadow
    @Final
    private float field_41091;

    @Override
    public void push(MemoryStack stack, long ptr, int count, VertexFormatDescription format) {
        OverlayVertexConsumerMixin.transform(ptr, count, format, this.field_21054, this.field_21053, this.field_41091);
        VertexBufferWriter.of(this.field_20866).push(stack, ptr, count, format);
    }

    @Unique
    private static void transform(long ptr, int count, VertexFormatDescription format, Matrix3f inverseNormalMatrix, Matrix4f inverseTextureMatrix, float textureScale) {
        long stride = format.stride();
        int offsetPosition = format.getElementOffset(CommonVertexAttribute.POSITION);
        int offsetColor = format.getElementOffset(CommonVertexAttribute.COLOR);
        int offsetNormal = format.getElementOffset(CommonVertexAttribute.NORMAL);
        int offsetTexture = format.getElementOffset(CommonVertexAttribute.TEXTURE);
        int color = ColorABGR.pack(1.0f, 1.0f, 1.0f, 1.0f);
        Vector3f normal = new Vector3f(Float.NaN);
        Vector4f position = new Vector4f(Float.NaN);
        for (int vertexIndex = 0; vertexIndex < count; ++vertexIndex) {
            position.x = MemoryUtil.memGetFloat((long)(ptr + (long)offsetPosition + 0L));
            position.y = MemoryUtil.memGetFloat((long)(ptr + (long)offsetPosition + 4L));
            position.z = MemoryUtil.memGetFloat((long)(ptr + (long)offsetPosition + 8L));
            position.w = 1.0f;
            int packedNormal = MemoryUtil.memGetInt((long)(ptr + (long)offsetNormal));
            normal.x = NormI8.unpackX(packedNormal);
            normal.y = NormI8.unpackY(packedNormal);
            normal.z = NormI8.unpackZ(packedNormal);
            Vector3f transformedNormal = inverseNormalMatrix.transform(normal);
            class_2350 direction = class_2350.method_10147((float)transformedNormal.x(), (float)transformedNormal.y(), (float)transformedNormal.z());
            Vector4f transformedTexture = inverseTextureMatrix.transform(position);
            transformedTexture.rotateY((float)Math.PI);
            transformedTexture.rotateX(-1.5707964f);
            transformedTexture.rotate((Quaternionfc)direction.method_23224());
            float textureU = -transformedTexture.x() * textureScale;
            float textureV = -transformedTexture.y() * textureScale;
            ColorAttribute.set(ptr + (long)offsetColor, color);
            TextureAttribute.put(ptr + (long)offsetTexture, textureU, textureV);
            ptr += stride;
        }
    }
}

