/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.base;

import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.kinetics.BlockStressValues;
import com.simibubi.create.content.kinetics.KineticNetwork;
import com.simibubi.create.content.kinetics.RotationPropagator;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.base.KineticEffectHandler;
import com.simibubi.create.content.kinetics.gearbox.GearboxBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.content.kinetics.transmission.sequencer.SequencedGearshiftBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.sound.SoundScapes;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.block.CustomRenderBoundingBoxBlockEntity;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5250;

public class KineticBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IHaveHoveringInformation,
CustomRenderBoundingBoxBlockEntity {
    @Nullable
    public Long network;
    @Nullable
    public class_2338 source;
    public boolean networkDirty;
    public boolean updateSpeed = true;
    public int preventSpeedUpdate;
    protected KineticEffectHandler effects = new KineticEffectHandler(this);
    protected float speed;
    protected float capacity;
    protected float stress;
    protected boolean overStressed;
    protected boolean wasMoved;
    private int flickerTally;
    private int networkSize;
    private int validationCountdown;
    protected float lastStressApplied;
    protected float lastCapacityProvided;
    public SequencedGearshiftBlockEntity.SequenceContext sequenceContext;

    public KineticBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
    }

    @Override
    public void initialize() {
        if (this.hasNetwork() && !this.field_11863.field_9236) {
            KineticNetwork network = this.getOrCreateNetwork();
            if (!network.initialized) {
                network.initFromTE(this.capacity, this.stress, this.networkSize);
            }
            network.addSilently(this, this.lastCapacityProvided, this.lastStressApplied);
        }
        super.initialize();
    }

    @Override
    public void tick() {
        if (!this.field_11863.field_9236 && this.needsSpeedUpdate()) {
            this.attachKinetics();
        }
        super.tick();
        this.effects.tick();
        this.preventSpeedUpdate = 0;
        if (this.field_11863.field_9236) {
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> this.tickAudio());
            return;
        }
        if (this.validationCountdown-- <= 0) {
            this.validationCountdown = (Integer)AllConfigs.server().kinetics.kineticValidationFrequency.get();
            this.validateKinetics();
        }
        if (this.getFlickerScore() > 0) {
            this.flickerTally = this.getFlickerScore() - 1;
        }
        if (this.networkDirty) {
            if (this.hasNetwork()) {
                this.getOrCreateNetwork().updateNetwork();
            }
            this.networkDirty = false;
        }
    }

    private void validateKinetics() {
        if (this.hasSource()) {
            KineticBlockEntity sourceBE;
            if (!this.hasNetwork()) {
                this.removeSource();
                return;
            }
            if (!this.field_11863.method_8477(this.source)) {
                return;
            }
            class_2586 blockEntity = this.field_11863.method_8321(this.source);
            KineticBlockEntity kineticBlockEntity = sourceBE = blockEntity instanceof KineticBlockEntity ? (KineticBlockEntity)blockEntity : null;
            if (sourceBE == null || sourceBE.speed == 0.0f) {
                this.removeSource();
                this.detachKinetics();
                return;
            }
            return;
        }
        if (this.speed != 0.0f && this.getGeneratedSpeed() == 0.0f) {
            this.speed = 0.0f;
        }
    }

    public void updateFromNetwork(float maxStress, float currentStress, int networkSize) {
        this.networkDirty = false;
        this.capacity = maxStress;
        this.stress = currentStress;
        this.networkSize = networkSize;
        boolean overStressed = maxStress < currentStress && IRotate.StressImpact.isEnabled();
        this.method_5431();
        if (overStressed != this.overStressed) {
            float prevSpeed = this.getSpeed();
            this.overStressed = overStressed;
            this.onSpeedChanged(prevSpeed);
            this.sendData();
        }
    }

    protected class_2248 getStressConfigKey() {
        return this.method_11010().method_26204();
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)BlockStressValues.getImpact(this.getStressConfigKey());
        return impact;
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = (float)BlockStressValues.getCapacity(this.getStressConfigKey());
        return capacity;
    }

    public void onSpeedChanged(float previousSpeed) {
        boolean directionSwap;
        boolean fromOrToZero = previousSpeed == 0.0f != (this.getSpeed() == 0.0f);
        boolean bl = directionSwap = !fromOrToZero && Math.signum(previousSpeed) != Math.signum(this.getSpeed());
        if (fromOrToZero || directionSwap) {
            this.flickerTally = this.getFlickerScore() + 5;
        }
        this.method_5431();
    }

    @Override
    public void remove() {
        if (!this.field_11863.field_9236) {
            if (this.hasNetwork()) {
                this.getOrCreateNetwork().remove(this);
            }
            this.detachKinetics();
        }
        super.remove();
    }

    @Override
    protected void write(class_2487 compound, boolean clientPacket) {
        compound.method_10548("Speed", this.speed);
        if (this.sequenceContext != null && (!clientPacket || this.syncSequenceContext())) {
            compound.method_10566("Sequence", (class_2520)this.sequenceContext.serializeNBT());
        }
        if (this.needsSpeedUpdate()) {
            compound.method_10556("NeedsSpeedUpdate", true);
        }
        if (this.hasSource()) {
            compound.method_10566("Source", (class_2520)class_2512.method_10692((class_2338)this.source));
        }
        if (this.hasNetwork()) {
            class_2487 networkTag = new class_2487();
            networkTag.method_10544("Id", this.network.longValue());
            networkTag.method_10548("Stress", this.stress);
            networkTag.method_10548("Capacity", this.capacity);
            networkTag.method_10569("Size", this.networkSize);
            if (this.lastStressApplied != 0.0f) {
                networkTag.method_10548("AddedStress", this.lastStressApplied);
            }
            if (this.lastCapacityProvided != 0.0f) {
                networkTag.method_10548("AddedCapacity", this.lastCapacityProvided);
            }
            compound.method_10566("Network", (class_2520)networkTag);
        }
        super.write(compound, clientPacket);
    }

    public boolean needsSpeedUpdate() {
        return this.updateSpeed;
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        boolean overStressedBefore = this.overStressed;
        this.clearKineticInformation();
        if (this.wasMoved) {
            super.read(compound, clientPacket);
            return;
        }
        this.speed = compound.method_10583("Speed");
        this.sequenceContext = SequencedGearshiftBlockEntity.SequenceContext.fromNBT(compound.method_10562("Sequence"));
        if (compound.method_10545("Source")) {
            this.source = class_2512.method_10691((class_2487)compound.method_10562("Source"));
        }
        if (compound.method_10545("Network")) {
            class_2487 networkTag = compound.method_10562("Network");
            this.network = networkTag.method_10537("Id");
            this.stress = networkTag.method_10583("Stress");
            this.capacity = networkTag.method_10583("Capacity");
            this.networkSize = networkTag.method_10550("Size");
            this.lastStressApplied = networkTag.method_10583("AddedStress");
            this.lastCapacityProvided = networkTag.method_10583("AddedCapacity");
            this.overStressed = this.capacity < this.stress && IRotate.StressImpact.isEnabled();
        }
        super.read(compound, clientPacket);
        if (clientPacket && overStressedBefore != this.overStressed && this.speed != 0.0f) {
            this.effects.triggerOverStressedEffect();
        }
        if (clientPacket) {
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> InstancedRenderDispatcher.enqueueUpdate((class_2586)this));
        }
    }

    public float getGeneratedSpeed() {
        return 0.0f;
    }

    public boolean isSource() {
        return this.getGeneratedSpeed() != 0.0f;
    }

    public float getSpeed() {
        if (this.overStressed) {
            return 0.0f;
        }
        return this.getTheoreticalSpeed();
    }

    public float getTheoreticalSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public void setSource(class_2338 source) {
        this.source = source;
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        class_2586 blockEntity = this.field_11863.method_8321(source);
        if (!(blockEntity instanceof KineticBlockEntity)) {
            this.removeSource();
            return;
        }
        KineticBlockEntity sourceBE = (KineticBlockEntity)blockEntity;
        this.setNetwork(sourceBE.network);
        this.copySequenceContextFrom(sourceBE);
    }

    protected void copySequenceContextFrom(KineticBlockEntity sourceBE) {
        this.sequenceContext = sourceBE.sequenceContext;
    }

    public void removeSource() {
        float prevSpeed = this.getSpeed();
        this.speed = 0.0f;
        this.source = null;
        this.setNetwork(null);
        this.sequenceContext = null;
        this.onSpeedChanged(prevSpeed);
    }

    public void setNetwork(@Nullable Long networkIn) {
        if (this.network == networkIn) {
            return;
        }
        if (this.network != null) {
            this.getOrCreateNetwork().remove(this);
        }
        this.network = networkIn;
        this.method_5431();
        if (networkIn == null) {
            return;
        }
        this.network = networkIn;
        KineticNetwork network = this.getOrCreateNetwork();
        network.initialized = true;
        network.add(this);
    }

    public KineticNetwork getOrCreateNetwork() {
        return Create.TORQUE_PROPAGATOR.getOrCreateNetworkFor(this);
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public void attachKinetics() {
        this.updateSpeed = false;
        RotationPropagator.handleAdded(this.field_11863, this.field_11867, this);
    }

    public void detachKinetics() {
        RotationPropagator.handleRemoved(this.field_11863, this.field_11867, this);
    }

    public boolean isSpeedRequirementFulfilled() {
        class_2680 state = this.method_11010();
        if (!(this.method_11010().method_26204() instanceof IRotate)) {
            return true;
        }
        IRotate def = (IRotate)state.method_26204();
        IRotate.SpeedLevel minimumRequiredSpeedLevel = def.getMinimumRequiredSpeedLevel();
        return Math.abs(this.getSpeed()) >= minimumRequiredSpeedLevel.getSpeedValue();
    }

    public static void switchToBlockState(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.field_9236) {
            return;
        }
        class_2586 blockEntity = world.method_8321(pos);
        class_2680 currentState = world.method_8320(pos);
        boolean isKinetic = blockEntity instanceof KineticBlockEntity;
        if (currentState == state) {
            return;
        }
        if (blockEntity == null || !isKinetic) {
            world.method_8652(pos, state, 3);
            return;
        }
        KineticBlockEntity kineticBlockEntity = (KineticBlockEntity)blockEntity;
        if (state.method_26204() instanceof KineticBlock && !((KineticBlock)state.method_26204()).areStatesKineticallyEquivalent(currentState, state)) {
            if (kineticBlockEntity.hasNetwork()) {
                kineticBlockEntity.getOrCreateNetwork().remove(kineticBlockEntity);
            }
            kineticBlockEntity.detachKinetics();
            kineticBlockEntity.removeSource();
        }
        world.method_8652(pos, state, 3);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    public boolean addToTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        boolean notFastEnough;
        boolean bl = notFastEnough = !this.isSpeedRequirementFulfilled() && this.getSpeed() != 0.0f;
        if (this.overStressed && ((Boolean)AllConfigs.client().enableOverstressedTooltip.get()).booleanValue()) {
            Lang.translate("gui.stressometer.overstressed", new Object[0]).style(class_124.field_1065).forGoggles(tooltip);
            class_5250 hint = Lang.translateDirect("gui.contraptions.network_overstressed", new Object[0]);
            List<class_2561> cutString = TooltipHelper.cutTextComponent((class_2561)hint, TooltipHelper.Palette.GRAY_AND_WHITE);
            for (int i = 0; i < cutString.size(); ++i) {
                Lang.builder().add(cutString.get(i).method_27661()).forGoggles(tooltip);
            }
            return true;
        }
        if (notFastEnough) {
            Lang.translate("tooltip.speedRequirement", new Object[0]).style(class_124.field_1065).forGoggles(tooltip);
            class_5250 hint = Lang.translateDirect("gui.contraptions.not_fast_enough", class_1074.method_4662((String)this.method_11010().method_26204().method_9539(), (Object[])new Object[0]));
            List<class_2561> cutString = TooltipHelper.cutTextComponent((class_2561)hint, TooltipHelper.Palette.GRAY_AND_WHITE);
            for (int i = 0; i < cutString.size(); ++i) {
                Lang.builder().add(cutString.get(i).method_27661()).forGoggles(tooltip);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        boolean added = false;
        if (!IRotate.StressImpact.isEnabled()) {
            return added;
        }
        float stressAtBase = this.calculateStressApplied();
        if (class_3532.method_15347((float)stressAtBase, (float)0.0f)) {
            return added;
        }
        Lang.translate("gui.goggles.kinetic_stats", new Object[0]).forGoggles(tooltip);
        this.addStressImpactStats(tooltip, stressAtBase);
        return true;
    }

    protected void addStressImpactStats(List<class_2561> tooltip, float stressAtBase) {
        Lang.translate("tooltip.stressImpact", new Object[0]).style(class_124.field_1080).forGoggles(tooltip);
        float stressTotal = stressAtBase * Math.abs(this.getTheoreticalSpeed());
        Lang.number(stressTotal).translate("generic.unit.stress", new Object[0]).style(class_124.field_1075).space().add(Lang.translate("gui.goggles.at_current_speed", new Object[0]).style(class_124.field_1063)).forGoggles(tooltip, 1);
    }

    public void clearKineticInformation() {
        this.speed = 0.0f;
        this.source = null;
        this.network = null;
        this.overStressed = false;
        this.stress = 0.0f;
        this.capacity = 0.0f;
        this.lastStressApplied = 0.0f;
        this.lastCapacityProvided = 0.0f;
    }

    public void warnOfMovement() {
        this.wasMoved = true;
    }

    public int getFlickerScore() {
        return this.flickerTally;
    }

    public static float convertToDirection(float axisSpeed, class_2350 d) {
        return d.method_10171() == class_2350.class_2352.field_11056 ? axisSpeed : -axisSpeed;
    }

    public static float convertToLinear(float speed) {
        return speed / 512.0f;
    }

    public static float convertToAngular(float speed) {
        return speed * 3.0f / 10.0f;
    }

    public boolean isOverStressed() {
        return this.overStressed;
    }

    public float propagateRotationTo(KineticBlockEntity target, class_2680 stateFrom, class_2680 stateTo, class_2338 diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        return 0.0f;
    }

    public List<class_2338> addPropagationLocations(IRotate block, class_2680 state, List<class_2338> neighbours) {
        if (!this.canPropagateDiagonally(block, state)) {
            return neighbours;
        }
        class_2350.class_2351 axis = block.getRotationAxis(state);
        class_2338.method_20437((class_2338)new class_2338(-1, -1, -1), (class_2338)new class_2338(1, 1, 1)).forEach(offset -> {
            if (axis.method_10173(offset.method_10263(), offset.method_10264(), offset.method_10260()) != 0) {
                return;
            }
            if (offset.method_10262((class_2382)class_2338.field_10980) != 2.0) {
                return;
            }
            neighbours.add(this.field_11867.method_10081((class_2382)offset));
        });
        return neighbours;
    }

    public boolean isCustomConnection(KineticBlockEntity other, class_2680 state, class_2680 otherState) {
        return false;
    }

    protected boolean canPropagateDiagonally(IRotate block, class_2680 state) {
        return ICogWheel.isSmallCog(state);
    }

    public void requestModelDataUpdate() {
        if (!this.field_11865) {
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> InstancedRenderDispatcher.enqueueUpdate((class_2586)this));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void tickAudio() {
        class_2248 block;
        float componentSpeed = Math.abs(this.getSpeed());
        if (componentSpeed == 0.0f) {
            return;
        }
        float pitch = class_3532.method_15363((float)(componentSpeed / 256.0f + 0.45f), (float)0.85f, (float)1.0f);
        if (this.isNoisy()) {
            SoundScapes.play(SoundScapes.AmbienceGroup.KINETIC, this.field_11867, pitch);
        }
        if (ICogWheel.isSmallCog(block = this.method_11010().method_26204()) || ICogWheel.isLargeCog(block) || block instanceof GearboxBlock) {
            SoundScapes.play(SoundScapes.AmbienceGroup.COG, this.field_11867, pitch);
        }
    }

    protected boolean isNoisy() {
        return true;
    }

    public int getRotationAngleOffset(class_2350.class_2351 axis) {
        return 0;
    }

    protected boolean syncSequenceContext() {
        return false;
    }
}

