/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids;

import com.simibubi.create.AllFluids;
import com.simibubi.create.content.fluids.FlowSource;
import com.simibubi.create.content.fluids.FluidReactions;
import com.simibubi.create.content.fluids.pipes.VanillaFluidTargets;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.BlockFace;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.tags.Tags;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.callbacks.TransactionCallback;
import io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
import io.github.tropheusj.milk.Milk;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3922;
import net.minecraft.class_5540;
import net.minecraft.class_6862;

public class OpenEndedPipe
extends FlowSource {
    private static final List<IEffectHandler> EFFECT_HANDLERS = new ArrayList<IEffectHandler>();
    private class_1937 world;
    private class_2338 pos;
    private class_238 aoe;
    private OpenEndFluidHandler fluidHandler = new OpenEndFluidHandler();
    private class_2338 outputPos;
    private boolean wasPulling;
    private FluidStack cachedFluid;
    private List<class_1293> cachedEffects;

    public OpenEndedPipe(BlockFace face) {
        super(face);
        this.outputPos = face.getConnectedPos();
        this.pos = face.getPos();
        this.aoe = new class_238(this.outputPos).method_1012(0.0, -1.0, 0.0);
        if (face.getFace() == class_2350.field_11033) {
            this.aoe = this.aoe.method_1012(0.0, -1.0, 0.0);
        }
    }

    public static void registerEffectHandler(IEffectHandler handler) {
        EFFECT_HANDLERS.add(handler);
    }

    public class_1937 getWorld() {
        return this.world;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_2338 getOutputPos() {
        return this.outputPos;
    }

    public class_238 getAOE() {
        return this.aoe;
    }

    @Override
    public void manageSource(class_1937 world) {
        this.world = world;
    }

    @Override
    public Storage<FluidVariant> provideHandler() {
        return this.fluidHandler;
    }

    @Override
    public boolean isEndpoint() {
        return true;
    }

    public class_2487 serializeNBT() {
        class_2487 compound = new class_2487();
        this.fluidHandler.writeToNBT(compound);
        compound.method_10556("Pulling", this.wasPulling);
        compound.method_10566("Location", (class_2520)this.location.serializeNBT());
        return compound;
    }

    public static OpenEndedPipe fromNBT(class_2487 compound, class_2338 blockEntityPos) {
        BlockFace fromNBT = BlockFace.fromNBT(compound.method_10562("Location"));
        OpenEndedPipe oep = new OpenEndedPipe(new BlockFace(blockEntityPos, fromNBT.getFace()));
        oep.fluidHandler.readFromNBT(compound);
        oep.wasPulling = compound.method_10577("Pulling");
        return oep;
    }

    private FluidStack removeFluidFromSpace(TransactionContext ctx) {
        FluidStack empty = FluidStack.EMPTY;
        if (this.world == null) {
            return empty;
        }
        if (!this.world.method_8477(this.outputPos)) {
            return empty;
        }
        class_2680 state = this.world.method_8320(this.outputPos);
        class_3610 fluidState = state.method_26227();
        boolean waterlog = state.method_28498((class_2769)class_2741.field_12508);
        FluidStack drainBlock = VanillaFluidTargets.drainBlock(this.world, this.outputPos, state, ctx);
        if (!drainBlock.isEmpty()) {
            if (state.method_28498((class_2769)class_2741.field_20432) && AllFluids.HONEY.is((Object)drainBlock.getFluid())) {
                TransactionCallback.onSuccess((TransactionContext)ctx, () -> AdvancementBehaviour.tryAward((class_1922)this.world, this.pos, AllAdvancements.HONEY_DRAIN));
            }
            return drainBlock;
        }
        if (!waterlog && !state.method_45474()) {
            return empty;
        }
        if (fluidState.method_15769() || !fluidState.method_15771()) {
            return empty;
        }
        FluidStack stack = new FluidStack(fluidState.method_15772(), 81000L);
        if (FluidHelper.isWater(stack.getFluid())) {
            AdvancementBehaviour.tryAward((class_1922)this.world, this.pos, AllAdvancements.WATER_SUPPLY);
        }
        this.world.updateSnapshots(ctx);
        if (waterlog) {
            this.world.method_8652(this.outputPos, (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)), 3);
            TransactionCallback.onSuccess((TransactionContext)ctx, () -> this.world.method_39281(this.outputPos, (class_3611)class_3612.field_15910, 1));
            return stack;
        }
        this.world.method_8652(this.outputPos, (class_2680)fluidState.method_15759().method_11657((class_2769)class_2404.field_11278, (Comparable)Integer.valueOf(14)), 3);
        return stack;
    }

    private boolean provideFluidToSpace(FluidStack fluid, TransactionContext ctx) {
        if (this.world == null) {
            return false;
        }
        if (!this.world.method_8477(this.outputPos)) {
            return false;
        }
        class_2680 state = this.world.method_8320(this.outputPos);
        class_3610 fluidState = state.method_26227();
        boolean waterlog = state.method_28498((class_2769)class_2741.field_12508);
        if (!waterlog && !state.method_45474()) {
            return false;
        }
        if (fluid.isEmpty()) {
            return false;
        }
        if (!(fluid.getFluid() instanceof class_3609)) {
            return false;
        }
        if (!(fluid.getFluid() instanceof class_3609)) {
            return false;
        }
        if (!FluidHelper.hasBlockState(fluid.getFluid()) || fluid.getFluid().method_15791(Milk.MILK_FLUID_TAG)) {
            return true;
        }
        if (!fluidState.method_15769() && fluidState.method_15772() != fluid.getFluid()) {
            FluidReactions.handlePipeSpillCollision(this.world, this.outputPos, fluid.getFluid(), fluidState);
            return false;
        }
        if (fluidState.method_15771()) {
            return false;
        }
        if (waterlog && fluid.getFluid() != class_3612.field_15910) {
            return false;
        }
        if (this.world.method_8597().comp_644() && FluidHelper.isTag(fluid, (class_6862<class_3611>)class_3486.field_15517)) {
            int i = this.outputPos.method_10263();
            int j = this.outputPos.method_10264();
            int k = this.outputPos.method_10260();
            TransactionCallback.onSuccess((TransactionContext)ctx, () -> this.world.method_43128(null, (double)i, (double)j, (double)k, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (this.world.field_9229.method_43057() - this.world.field_9229.method_43057()) * 0.8f));
            return true;
        }
        this.world.updateSnapshots(ctx);
        if (waterlog) {
            this.world.method_8652(this.outputPos, (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)), 3);
            TransactionCallback.onSuccess((TransactionContext)ctx, () -> this.world.method_39281(this.outputPos, (class_3611)class_3612.field_15910, 1));
            return true;
        }
        if (!((Boolean)AllConfigs.server().fluids.pipesPlaceFluidSourceBlocks.get()).booleanValue()) {
            return true;
        }
        this.world.method_8652(this.outputPos, fluid.getFluid().method_15785().method_15759(), 3);
        return true;
    }

    private boolean canApplyEffects(FluidStack fluid) {
        for (IEffectHandler handler : EFFECT_HANDLERS) {
            if (!handler.canApplyEffects(this, fluid)) continue;
            return true;
        }
        return false;
    }

    private void applyEffects(FluidStack fluid) {
        for (IEffectHandler handler : EFFECT_HANDLERS) {
            if (!handler.canApplyEffects(this, fluid)) continue;
            handler.applyEffects(this, fluid);
        }
    }

    static {
        OpenEndedPipe.registerEffectHandler(new PotionEffectHandler());
        OpenEndedPipe.registerEffectHandler(new MilkEffectHandler());
        OpenEndedPipe.registerEffectHandler(new WaterEffectHandler());
        OpenEndedPipe.registerEffectHandler(new LavaEffectHandler());
        OpenEndedPipe.registerEffectHandler(new TeaEffectHandler());
    }

    private class OpenEndFluidHandler
    extends FluidTank {
        public OpenEndFluidHandler() {
            super(81000L);
        }

        public long insert(FluidVariant resource, long maxAmount, TransactionContext transaction) {
            if (OpenEndedPipe.this.world == null) {
                return 0L;
            }
            if (!OpenEndedPipe.this.world.method_8477(OpenEndedPipe.this.outputPos)) {
                return 0L;
            }
            if (resource.isBlank()) {
                return 0L;
            }
            FluidStack stack = new FluidStack(resource, 81L);
            this.updateSnapshots(transaction);
            try (Transaction provideTest = transaction.openNested();){
                if (!OpenEndedPipe.this.provideFluidToSpace(stack, (TransactionContext)provideTest)) {
                    long l = 0L;
                    return l;
                }
            }
            FluidStack containedFluidStack = this.getFluid();
            boolean hasBlockState = FluidHelper.hasBlockState(containedFluidStack.getFluid());
            if (!containedFluidStack.isEmpty() && !containedFluidStack.canFill(resource)) {
                this.setFluid(FluidStack.EMPTY);
            }
            if (OpenEndedPipe.this.wasPulling) {
                OpenEndedPipe.this.wasPulling = false;
            }
            if (OpenEndedPipe.this.canApplyEffects(stack) && !hasBlockState) {
                maxAmount = 81L;
            }
            long fill = super.insert(resource, maxAmount, transaction);
            if (!stack.isEmpty()) {
                TransactionCallback.onSuccess((TransactionContext)transaction, () -> OpenEndedPipe.this.applyEffects(stack));
            }
            if ((this.getFluidAmount() == 81000L || !FluidHelper.hasBlockState(containedFluidStack.getFluid()) || containedFluidStack.getFluid().method_15791(Milk.MILK_FLUID_TAG)) && OpenEndedPipe.this.provideFluidToSpace(containedFluidStack, transaction)) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fill;
        }

        public long extract(FluidVariant extractedVariant, long maxAmount, TransactionContext transaction) {
            if (OpenEndedPipe.this.world == null) {
                return 0L;
            }
            if (!OpenEndedPipe.this.world.method_8477(OpenEndedPipe.this.outputPos)) {
                return 0L;
            }
            if (maxAmount == 0L) {
                return 0L;
            }
            if (maxAmount > 81000L) {
                maxAmount = 81000L;
            }
            if (!OpenEndedPipe.this.wasPulling) {
                OpenEndedPipe.this.wasPulling = true;
            }
            this.updateSnapshots(transaction);
            long drainedFromInternal = super.extract(extractedVariant, maxAmount, transaction);
            if (drainedFromInternal != 0L) {
                return drainedFromInternal;
            }
            FluidStack drainedFromWorld = OpenEndedPipe.this.removeFluidFromSpace(transaction);
            if (drainedFromWorld.isEmpty()) {
                return 0L;
            }
            if (!drainedFromWorld.canFill(extractedVariant)) {
                return 0L;
            }
            long remainder = drainedFromWorld.getAmount() - maxAmount;
            drainedFromWorld.setAmount(maxAmount);
            if (remainder > 0L) {
                if (!this.getFluid().isEmpty() && !this.getFluid().isFluidEqual(drainedFromWorld)) {
                    this.setFluid(FluidStack.EMPTY);
                }
                super.insert(drainedFromWorld.getType(), remainder, transaction);
            }
            return drainedFromWorld.getAmount();
        }

        public boolean isResourceBlank() {
            if (!super.isResourceBlank()) {
                return false;
            }
            return this.getResource().isBlank();
        }

        public FluidVariant getResource() {
            if (!super.isResourceBlank()) {
                return (FluidVariant)super.getResource();
            }
            try (Transaction t = TransferUtil.getTransaction();){
                FluidStack stack = OpenEndedPipe.this.removeFluidFromSpace((TransactionContext)t);
                FluidVariant fluidVariant = stack.getType();
                return fluidVariant;
            }
        }

        public long getAmount() {
            long amount = super.getAmount();
            if (amount != 0L) {
                return amount;
            }
            return this.isResourceBlank() ? 0L : 81000L;
        }
    }

    public static interface IEffectHandler {
        public boolean canApplyEffects(OpenEndedPipe var1, FluidStack var2);

        public void applyEffects(OpenEndedPipe var1, FluidStack var2);
    }

    public static class PotionEffectHandler
    implements IEffectHandler {
        @Override
        public boolean canApplyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            return fluid.getFluid().method_15780((class_3611)AllFluids.POTION.get());
        }

        @Override
        public void applyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            if (pipe.cachedFluid == null || pipe.cachedEffects == null || !fluid.isFluidEqual(pipe.cachedFluid)) {
                FluidStack copy = fluid.copy();
                copy.setAmount(27000L);
                class_1799 bottle = PotionFluidHandler.fillBottle(new class_1799((class_1935)class_1802.field_8469), fluid);
                pipe.cachedEffects = class_1844.method_8067((class_1799)bottle);
            }
            if (pipe.cachedEffects.isEmpty()) {
                return;
            }
            List entities = pipe.getWorld().method_8390(class_1309.class, pipe.getAOE(), class_1309::method_6086);
            for (class_1309 entity : entities) {
                for (class_1293 effectInstance : pipe.cachedEffects) {
                    class_1291 effect = effectInstance.method_5579();
                    if (effect.method_5561()) {
                        effect.method_5564(null, null, entity, effectInstance.method_5578(), 0.5);
                        continue;
                    }
                    entity.method_6092(new class_1293(effectInstance));
                }
            }
        }
    }

    public static class MilkEffectHandler
    implements IEffectHandler {
        @Override
        public boolean canApplyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            return FluidHelper.isTag(fluid, (class_6862<class_3611>)Tags.Fluids.MILK);
        }

        @Override
        public void applyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            class_1937 world = pipe.getWorld();
            if (world.method_8510() % 5L != 0L) {
                return;
            }
            List entities = world.method_8390(class_1309.class, pipe.getAOE(), class_1309::method_6086);
            for (class_1309 entity : entities) {
                entity.method_6012();
            }
        }
    }

    public static class WaterEffectHandler
    implements IEffectHandler {
        @Override
        public boolean canApplyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            return FluidHelper.isTag(fluid, (class_6862<class_3611>)class_3486.field_15517);
        }

        @Override
        public void applyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            class_1937 world = pipe.getWorld();
            if (world.method_8510() % 5L != 0L) {
                return;
            }
            List entities = world.method_8333((class_1297)null, pipe.getAOE(), class_1297::method_5809);
            for (class_1297 entity : entities) {
                entity.method_5646();
            }
            class_2338.method_29715((class_238)pipe.getAOE()).forEach(pos -> WaterEffectHandler.dowseFire(world, pos));
        }

        private static void dowseFire(class_1937 level, class_2338 pos) {
            class_2680 state = level.method_8320(pos);
            if (state.method_26164(class_3481.field_21952)) {
                level.method_8650(pos, false);
            } else if (class_5540.method_35245((class_2680)state)) {
                class_5540.method_31614(null, (class_2680)state, (class_1936)level, (class_2338)pos);
            } else if (class_3922.method_23896((class_2680)state)) {
                level.method_8444(null, 1009, pos, 0);
                class_3922.method_29288(null, (class_1936)level, (class_2338)pos, (class_2680)state);
                level.method_8501(pos, (class_2680)state.method_11657((class_2769)class_3922.field_17352, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public static class LavaEffectHandler
    implements IEffectHandler {
        @Override
        public boolean canApplyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            return FluidHelper.isTag(fluid, (class_6862<class_3611>)class_3486.field_15518);
        }

        @Override
        public void applyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            class_1937 world = pipe.getWorld();
            if (world.method_8510() % 5L != 0L) {
                return;
            }
            List entities = world.method_8333((class_1297)null, pipe.getAOE(), entity -> !entity.method_5753());
            for (class_1297 entity2 : entities) {
                entity2.method_5639(3);
            }
        }
    }

    public static class TeaEffectHandler
    implements IEffectHandler {
        @Override
        public boolean canApplyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            return fluid.getFluid().method_15780((class_3611)AllFluids.TEA.get());
        }

        @Override
        public void applyEffects(OpenEndedPipe pipe, FluidStack fluid) {
            class_1937 world = pipe.getWorld();
            if (world.method_8510() % 5L != 0L) {
                return;
            }
            List entities = world.method_8390(class_1309.class, pipe.getAOE(), class_1309::method_6086);
            for (class_1309 entity : entities) {
                entity.method_6092(new class_1293(class_1294.field_5917, 21, 0, false, false, false));
            }
        }
    }
}

