/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.utils;

import com.google.common.base.CaseFormat;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1438;
import net.minecraft.class_1439;
import net.minecraft.class_1440;
import net.minecraft.class_1451;
import net.minecraft.class_1472;
import net.minecraft.class_1474;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1501;
import net.minecraft.class_1545;
import net.minecraft.class_1548;
import net.minecraft.class_1560;
import net.minecraft.class_1577;
import net.minecraft.class_1593;
import net.minecraft.class_1606;
import net.minecraft.class_1617;
import net.minecraft.class_1621;
import net.minecraft.class_1632;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_2105;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6053;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.entity_handlers.ETFBlockEntityWrapper;
import traben.entity_texture_features.entity_handlers.ETFEntity;
import traben.entity_texture_features.entity_handlers.ETFEntityWrapper;
import traben.entity_texture_features.mixin.accessor.MooshroomEntityAccessor;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.utils.ETFUtils2;

public abstract class ETFTexturePropertiesUtils {
    static Pattern groupByQuotationPattern = Pattern.compile("([^\"]\\S*|\".+?\")\\s*");

    public static void processNewOptifinePropertiesFile(ETFEntity entity, class_2960 vanillaIdentifier, class_2960 properties) {
        block25: {
            ETFManager manager = ETFManager.getInstance();
            try {
                Properties props = ETFUtils2.readAndReturnPropertiesElseNull(properties);
                if (props != null) {
                    List<ETFTexturePropertyCase> allCasesForTexture;
                    if (props.containsKey("vanillaBrightnessOverride")) {
                        int tryNumber;
                        String value = props.getProperty("vanillaBrightnessOverride").trim();
                        try {
                            tryNumber = Integer.parseInt(value.replaceAll("\\D", ""));
                        }
                        catch (NumberFormatException e) {
                            tryNumber = 0;
                        }
                        if (tryNumber >= 16) {
                            tryNumber = 15;
                        }
                        if (tryNumber < 0) {
                            tryNumber = 0;
                        }
                        manager.ENTITY_TYPE_VANILLA_BRIGHTNESS_OVERRIDE_VALUE.put(entity.getType(), tryNumber);
                    }
                    if (entity.isZombiePiglin() && props.containsKey("showHiddenModelParts") && "true".equals(props.getProperty("showHiddenModelParts"))) {
                        manager.zombiePiglinRightEarEnabled = true;
                    }
                    if (props.containsKey("suppressParticles") && "true".equals(props.getProperty("suppressParticles"))) {
                        manager.ENTITY_TYPE_IGNORE_PARTICLES.add(entity.getType());
                    }
                    if (props.containsKey("entityRenderLayerOverride")) {
                        String layer;
                        switch (layer = props.getProperty("entityRenderLayerOverride")) {
                            case "translucent": {
                                manager.ENTITY_TYPE_RENDER_LAYER.put(entity.getType(), 1);
                                break;
                            }
                            case "translucent_cull": {
                                manager.ENTITY_TYPE_RENDER_LAYER.put(entity.getType(), 2);
                                break;
                            }
                            case "end_portal": {
                                manager.ENTITY_TYPE_RENDER_LAYER.put(entity.getType(), 3);
                                break;
                            }
                            case "outline": {
                                manager.ENTITY_TYPE_RENDER_LAYER.put(entity.getType(), 4);
                            }
                        }
                    }
                    if (!(allCasesForTexture = ETFTexturePropertiesUtils.getAllValidPropertyObjects(props, "skins", vanillaIdentifier)).isEmpty()) {
                        manager.OPTIFINE_PROPERTY_CACHE.put((Object)vanillaIdentifier, allCasesForTexture);
                    } else {
                        ETFUtils2.logMessage("Ignoring properties file that failed to load any cases @ " + vanillaIdentifier, false);
                        manager.OPTIFINE_PROPERTY_CACHE.put((Object)vanillaIdentifier, null);
                    }
                    break block25;
                }
                ETFUtils2.logMessage("Ignoring properties file that was null @ " + vanillaIdentifier, false);
                manager.OPTIFINE_PROPERTY_CACHE.put((Object)vanillaIdentifier, null);
            }
            catch (Exception e) {
                ETFUtils2.logWarn("Ignoring properties file that caused Exception @ " + vanillaIdentifier + "\n" + e, false);
                e.printStackTrace();
                manager.OPTIFINE_PROPERTY_CACHE.put((Object)vanillaIdentifier, null);
            }
        }
    }

    public static List<ETFTexturePropertyCase> getAllValidPropertyObjects(Properties props, String suffixToTest, class_2960 vanillaIdentifier) {
        Set<String> propIds = props.stringPropertyNames();
        HashSet<Integer> numbers = new HashSet<Integer>();
        for (String str : propIds) {
            if ((str = str.replaceAll("\\D", "")).isEmpty()) continue;
            try {
                numbers.add(Integer.parseInt(str));
            }
            catch (NumberFormatException e) {
                ETFUtils2.logWarn("properties file number error in start count");
            }
        }
        ArrayList numbersList = new ArrayList(numbers);
        Collections.sort(numbersList);
        ArrayList<ETFTexturePropertyCase> allCasesForTexture = new ArrayList<ETFTexturePropertyCase>();
        for (Integer num : numbersList) {
            Integer[] suffixes = ETFTexturePropertiesUtils.getSuffixes(props, num, suffixToTest);
            if (suffixes != null && suffixes.length != 0) {
                allCasesForTexture.add(new ETFTexturePropertyCase(suffixes, ETFTexturePropertiesUtils.getWeights(props, num), ETFTexturePropertiesUtils.getBiomes(props, num), ETFTexturePropertiesUtils.getHeights(props, num), ETFTexturePropertiesUtils.getNames(props, num), ETFTexturePropertiesUtils.getProfessions(props, num), ETFTexturePropertiesUtils.getColors(props, num), ETFTexturePropertiesUtils.getBaby(props, num), ETFTexturePropertiesUtils.getWeather(props, num), ETFTexturePropertiesUtils.getHealth(props, num), ETFTexturePropertiesUtils.getMoon(props, num), ETFTexturePropertiesUtils.getDayTime(props, num), ETFTexturePropertiesUtils.getBlocks(props, num), ETFTexturePropertiesUtils.getTeams(props, num), ETFTexturePropertiesUtils.getSizes(props, num), ETFTexturePropertiesUtils.getSpeed(props, num), ETFTexturePropertiesUtils.getJump(props, num), ETFTexturePropertiesUtils.getMaxHealth(props, num), ETFTexturePropertiesUtils.getLlamaInv(props, num), ETFTexturePropertiesUtils.getAngry(props, num), ETFTexturePropertiesUtils.getHiddenGene(props, num), ETFTexturePropertiesUtils.getPlayerCreated(props, num), ETFTexturePropertiesUtils.getScreamingGoat(props, num), ETFTexturePropertiesUtils.getDistanceFromPlayer(props, num), ETFTexturePropertiesUtils.getCreeperCharge(props, num), ETFTexturePropertiesUtils.getStatusEffect(props, num), ETFTexturePropertiesUtils.getItems(props, num), ETFTexturePropertiesUtils.getMoving(props, num), ETFTexturePropertiesUtils.getNBT(props, num)));
                continue;
            }
            ETFUtils2.logWarn("property number \"" + num + ". in file \"" + vanillaIdentifier + ". failed to read.");
        }
        return allCasesForTexture;
    }

    @Nullable
    private static Integer[] getSuffixes(Properties props, int num, String suffixToTest) {
        if ("skins".equals(suffixToTest)) {
            Integer[] ints = ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, "skins");
            return ints == null ? ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, "textures") : ints;
        }
        return ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, suffixToTest);
    }

    @Nullable
    private static Integer[] getWeights(Properties props, int num) {
        if (props.containsKey("weights." + num)) {
            String dataFromProps = props.getProperty("weights." + num).trim();
            String[] weightData = dataFromProps.split("\\s+");
            ArrayList<Integer> builder = new ArrayList<Integer>();
            for (String s : weightData) {
                if ((s = s.trim()).replaceAll("\\D", "").isEmpty()) continue;
                try {
                    int tryNumber = Integer.parseInt(s.replaceAll("\\D", ""));
                    builder.add(tryNumber);
                }
                catch (NumberFormatException e) {
                    ETFUtils2.logWarn("properties files number error in weights category");
                }
            }
            return builder.toArray(new Integer[0]);
        }
        return null;
    }

    @Nullable
    private static String getBiomes(Properties props, int num) {
        String dataFromProps;
        String[] biomeList;
        if (props.containsKey("biomes." + num) && (biomeList = (dataFromProps = props.getProperty("biomes." + num).strip()).split("\\s+")).length > 0) {
            block33: for (int currentIndex = 0; currentIndex < biomeList.length; ++currentIndex) {
                String currentBiome;
                switch (currentBiome = biomeList[currentIndex].strip()) {
                    case "ExtremeHills": {
                        biomeList[currentIndex] = "stony_peaks";
                        continue block33;
                    }
                    case "Forest": 
                    case "ForestHills": {
                        biomeList[currentIndex] = "forest";
                        continue block33;
                    }
                    case "Taiga": 
                    case "TaigaHills": {
                        biomeList[currentIndex] = "taiga";
                        continue block33;
                    }
                    case "Swampland": {
                        biomeList[currentIndex] = "swamp";
                        continue block33;
                    }
                    case "Hell": {
                        biomeList[currentIndex] = "nether_wastes";
                        continue block33;
                    }
                    case "Sky": {
                        biomeList[currentIndex] = "the_end";
                        continue block33;
                    }
                    case "IcePlains": {
                        biomeList[currentIndex] = "snowy_plains";
                        continue block33;
                    }
                    case "IceMountains": {
                        biomeList[currentIndex] = "snowy_slopes";
                        continue block33;
                    }
                    case "MushroomIsland": 
                    case "MushroomIslandShore": {
                        biomeList[currentIndex] = "mushroom_fields";
                        continue block33;
                    }
                    case "DesertHills": 
                    case "Desert": {
                        biomeList[currentIndex] = "desert";
                        continue block33;
                    }
                    case "ExtremeHillsEdge": {
                        biomeList[currentIndex] = "meadow";
                        continue block33;
                    }
                    case "Jungle": 
                    case "JungleHills": {
                        biomeList[currentIndex] = "jungle";
                        continue block33;
                    }
                    default: {
                        if (currentBiome.contains("_") || currentBiome.equals(currentBiome.toLowerCase())) continue block33;
                        biomeList[currentIndex] = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, currentBiome);
                    }
                }
            }
            StringBuilder builder = new StringBuilder();
            for (String str : biomeList) {
                builder.append(str).append(" ");
            }
            return builder.toString().trim().toLowerCase();
        }
        return null;
    }

    @Nullable
    private static Integer[] getHeights(Properties props, int num) {
        if (!props.containsKey("heights." + num) && (props.containsKey("minHeight." + num) || props.containsKey("maxHeight." + num))) {
            String min = "-64";
            String max = "319";
            if (props.containsKey("minHeight." + num)) {
                min = props.getProperty("minHeight." + num).strip();
            }
            if (props.containsKey("maxHeight." + num)) {
                max = props.getProperty("maxHeight." + num).strip();
            }
            props.put("heights." + num, min + "-" + max);
        }
        return ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, "heights");
    }

    @Nullable
    private static String getNames(Properties props, int num) {
        String dataFromProps;
        ArrayList<String> names = new ArrayList<String>();
        if (props.containsKey("names." + num)) {
            dataFromProps = props.getProperty("names." + num).trim();
            if (dataFromProps.contains("regex:") || dataFromProps.contains("pattern:")) {
                names.add(dataFromProps);
            } else {
                names.add(dataFromProps);
                Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(dataFromProps);
                while (m.find()) {
                    names.add(m.group(1).replace("\"", "").trim());
                }
            }
        }
        if (props.containsKey("name." + num)) {
            dataFromProps = props.getProperty("name." + num).trim();
            names.add(dataFromProps);
        }
        if (names.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String str : names) {
            builder.append(str).append(" ");
        }
        return builder.toString().trim();
    }

    @Nullable
    private static String[] getProfessions(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "professions");
    }

    @Nullable
    private static String[] getColors(Properties props, int num) {
        String[] str = ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "collarColors");
        return str == null ? ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "colors") : str;
    }

    @Nullable
    private static Boolean getBaby(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericBooleanThatCanNull(props, num, "baby");
    }

    private static WeatherType getWeather(Properties props, int num) {
        if (props.containsKey("weather." + num)) {
            return WeatherType.getType(props.getProperty("weather." + num).trim());
        }
        return null;
    }

    @Nullable
    private static String[] getHealth(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "health");
    }

    @Nullable
    private static Integer[] getMoon(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, "moonPhase");
    }

    @Nullable
    private static String[] getDayTime(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "dayTime");
    }

    @Nullable
    private static String[] getBlocks(Properties props, int num) {
        String[] str = ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "blocks");
        return str == null ? ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "block") : str;
    }

    @Nullable
    private static String getTeams(Properties props, int num) {
        if (props.containsKey("teams." + num)) {
            return props.getProperty("teams." + num).trim();
        }
        if (props.containsKey("team." + num)) {
            return props.getProperty("team." + num).trim();
        }
        return null;
    }

    @Nullable
    private static Integer[] getSizes(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, "sizes");
    }

    @Nullable
    private static Double[] getSpeed(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericMinMaxDouble(props, num, "speed");
    }

    @Nullable
    private static Double[] getJump(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericMinMaxDouble(props, num, "jumpStrength");
    }

    @Nullable
    private static String[] getMaxHealth(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "maxHealth");
    }

    @Nullable
    private static Integer[] getLlamaInv(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericIntegerSplitWithRanges(props, num, "llamaInventory");
    }

    @Nullable
    private static Boolean getAngry(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericBooleanThatCanNull(props, num, "angry");
    }

    @Nullable
    private static class_1440.class_1443[] getHiddenGene(Properties props, int num) {
        if (props.containsKey("hiddenGene." + num)) {
            String[] input = props.getProperty("hiddenGene." + num).trim().split("\\s+");
            ArrayList<class_1440.class_1443> genes = new ArrayList<class_1440.class_1443>();
            block18: for (String gene : input) {
                switch (gene.trim()) {
                    case "normal": {
                        genes.add(class_1440.class_1443.field_6788);
                        continue block18;
                    }
                    case "lazy": {
                        genes.add(class_1440.class_1443.field_6794);
                        continue block18;
                    }
                    case "worried": {
                        genes.add(class_1440.class_1443.field_6795);
                        continue block18;
                    }
                    case "playful": {
                        genes.add(class_1440.class_1443.field_6791);
                        continue block18;
                    }
                    case "brown": {
                        genes.add(class_1440.class_1443.field_6792);
                        continue block18;
                    }
                    case "weak": {
                        genes.add(class_1440.class_1443.field_6793);
                        continue block18;
                    }
                    case "aggressive": {
                        genes.add(class_1440.class_1443.field_6789);
                        continue block18;
                    }
                    default: {
                        ETFUtils2.logWarn("properties files number error in hiddenGene category, caused by input: " + gene);
                    }
                }
            }
            return genes.toArray(new class_1440.class_1443[0]);
        }
        return null;
    }

    @Nullable
    private static Boolean getPlayerCreated(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericBooleanThatCanNull(props, num, "playerCreated");
    }

    @Nullable
    private static Boolean getScreamingGoat(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericBooleanThatCanNull(props, num, "screamingGoat");
    }

    @Nullable
    private static String[] getDistanceFromPlayer(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "distanceFromPlayer");
    }

    @Nullable
    private static Boolean getCreeperCharge(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericBooleanThatCanNull(props, num, "creeperCharged");
    }

    @Nullable
    private static class_1291[] getStatusEffect(Properties props, int num) {
        if (props.containsKey("statusEffect." + num)) {
            String dataFromProps = props.getProperty("statusEffect." + num).trim();
            String[] columnData = dataFromProps.split("\\s+");
            ArrayList<class_1291> statuses = new ArrayList<class_1291>();
            for (String data : columnData) {
                data = data.replaceAll("\\(", "").replaceAll("\\)", "");
                if ((data = data.trim()).replaceAll("\\D", "").isEmpty()) continue;
                try {
                    int tryNumber = Integer.parseInt(data.replaceAll("\\D", ""));
                    class_1291 attempt = class_1291.method_5569((int)tryNumber);
                    if (attempt == null) continue;
                    statuses.add(attempt);
                }
                catch (NumberFormatException e) {
                    ETFUtils2.logWarn("properties files number error in statusEffects category");
                }
            }
            return statuses.toArray(new class_1291[0]);
        }
        return null;
    }

    @Nullable
    private static String[] getItems(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericStringSplitProperty(props, num, "items");
    }

    @Nullable
    private static Boolean getMoving(Properties props, int num) {
        return ETFTexturePropertiesUtils.getGenericBooleanThatCanNull(props, num, "moving");
    }

    @Nullable
    private static String[] getGenericStringSplitProperty(Properties props, int num, String propertyName) {
        if (props.containsKey(propertyName + "." + num)) {
            return props.getProperty(propertyName + "." + num).trim().split("\\s+");
        }
        return null;
    }

    @Nullable
    private static Integer[] getGenericIntegerSplitWithRanges(Properties props, int num, String propertyName) {
        if (props.containsKey(propertyName + "." + num)) {
            String dataFromProps = props.getProperty(propertyName + "." + num).strip().replaceAll("[)(]", "");
            String[] skinData = dataFromProps.split("\\s+");
            ArrayList<Integer> suffixNumbers = new ArrayList<Integer>();
            for (String data : skinData) {
                if ((data = data.strip()).replaceAll("\\D", "").isEmpty()) continue;
                try {
                    if (data.contains("-")) {
                        suffixNumbers.addAll(Arrays.asList(ETFTexturePropertiesUtils.getIntRange(data).getAllWithinRangeAsList()));
                        continue;
                    }
                    int tryNumber = Integer.parseInt(data.replaceAll("\\D", ""));
                    suffixNumbers.add(tryNumber);
                }
                catch (NumberFormatException e) {
                    ETFUtils2.logWarn("properties files number error in " + propertyName + " category");
                }
            }
            return suffixNumbers.toArray(new Integer[0]);
        }
        return null;
    }

    @Nullable
    private static Double[] getGenericMinMaxDouble(Properties props, int num, String propertyName) {
        if (props.containsKey(propertyName + "." + num)) {
            String dataFromProps = props.getProperty(propertyName + "." + num).trim();
            String[] rangeData = dataFromProps.split("-");
            if (rangeData.length == 2) {
                try {
                    double tryMinNumber = Double.parseDouble(rangeData[0].replaceAll("[^\\.\\d]", ""));
                    double tryMaxNumber = Double.parseDouble(rangeData[1].replaceAll("[^\\.\\d]", ""));
                    return new Double[]{tryMinNumber, tryMaxNumber};
                }
                catch (NumberFormatException e) {
                    ETFUtils2.logWarn("properties files number error in " + propertyName + " category");
                }
            } else {
                ETFUtils2.logWarn("properties files number error in " + propertyName + " category");
            }
        }
        return null;
    }

    @Nullable
    private static Boolean getGenericBooleanThatCanNull(Properties props, int num, String propertyName) {
        if (props.containsKey(propertyName + "." + num)) {
            String input = props.getProperty(propertyName + "." + num).trim();
            if ("true".equals(input) || "false".equals(input)) {
                return "true".equals(input);
            }
            ETFUtils2.logWarn("properties files number error in " + propertyName + " category");
        }
        return null;
    }

    @Nullable
    private static Map<String, String> getNBT(Properties props, int num) {
        String keyPrefix = "nbt." + num + ".";
        HashMap<String, String> map = new HashMap<String, String>();
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (key != null && ((String)key).startsWith(keyPrefix)) {
                String nbtName = ((String)key).replaceFirst(keyPrefix, "");
                map.put(nbtName, ((String)value).trim());
            }
        }));
        if (!map.isEmpty()) {
            return map;
        }
        return null;
    }

    public static IntRange getIntRange(String rawRange) {
        String[] split;
        if ((rawRange = rawRange.trim()).startsWith("-")) {
            rawRange = rawRange.replaceFirst("-", "N");
        }
        if ((split = (rawRange = rawRange.replaceAll("--", "-N")).split("-")).length == 2 && !split[0].isEmpty() && !split[1].isEmpty()) {
            int[] minMax = new int[]{Integer.parseInt(split[0].replaceAll("\\D", "")), Integer.parseInt(split[1].replaceAll("\\D", ""))};
            if (split[0].contains("N")) {
                minMax[0] = -minMax[0];
            }
            if (split[1].contains("N")) {
                minMax[1] = -minMax[1];
            }
            if (minMax[0] > minMax[1]) {
                return new IntRange(minMax[1], minMax[0]);
            }
            return new IntRange(minMax[0], minMax[1]);
        }
        int number = Integer.parseInt(rawRange.replaceAll("\\D", ""));
        if (rawRange.contains("N")) {
            number = -number;
        }
        return new IntRange(number, number);
    }

    public static class ETFTexturePropertyCase {
        private final Integer[] SUFFIX_NUMBERS_WEIGHTED;
        @Nullable
        private final StringPropertyMatcher BIOME_VALUE_MATCHER;
        @Nullable
        private final Integer[] HEIGHT_Y_VALUES;
        @Nullable
        private final StringPropertyMatcher NAME_MATCHERS;
        @Nullable
        private final String[] PROFESSION_VALUES;
        @Nullable
        private final String[] COLOR_VALUES;
        @Nullable
        private final Boolean IS_BABY;
        @Nullable
        private final WeatherType WEATHER_TYPE;
        @Nullable
        private final String[] HEALTH_RANGE_STRINGS;
        @Nullable
        private final Integer[] MOON_PHASE_VALUES;
        @Nullable
        private final String[] TIME_RANGE_STRINGS;
        @Nullable
        private final String[] BLOCK_VALUES;
        @Nullable
        private final StringPropertyMatcher TEAM_MATCHER;
        @Nullable
        private final Integer[] SIZE_VALUES;
        @Nullable
        private final Double[] SPEED_MIN_MAX;
        @Nullable
        private final Double[] JUMP_MIN_MAX;
        @Nullable
        private final String[] MAX_HEALTH_STRINGS;
        @Nullable
        private final Integer[] INVENTORY_COLUMNS;
        @Nullable
        private final Boolean IS_ANGRY;
        @Nullable
        private final class_1440.class_1443[] HIDDEN_GENE;
        @Nullable
        private final Boolean IS_PLAYER_CREATED;
        @Nullable
        private final Boolean IS_SCREAMING_GOAT;
        @Nullable
        private final String[] DISTANCE_TO_PLAYER;
        @Nullable
        private final Boolean CREEPER_CHARGED;
        @Nullable
        private final class_1291[] STATUS_EFFECT;
        @Nullable
        private final String[] ITEMS;
        @Nullable
        private final Boolean MOVING;
        @Nullable
        private final Map<String, String> NBT_MAP;
        private final boolean isNullPropertyCase;

        public ETFTexturePropertyCase(Integer[] suffixesX, @Nullable Integer[] weightsX, @Nullable String biomesX, @Nullable Integer[] heights, @Nullable String namesX, @Nullable String[] professionsX, @Nullable String[] collarColoursX, @Nullable Boolean baby012, @Nullable WeatherType weather0123, @Nullable String[] healthX, @Nullable Integer[] moonX, @Nullable String[] daytimeX, @Nullable String[] blocksX, @Nullable String teamsX, @Nullable Integer[] sizeX, @Nullable Double[] speedMinMax, @Nullable Double[] jumpMinMax, @Nullable String[] maxHealthStrings, @Nullable Integer[] inventoryColumns, @Nullable Boolean isAngry, @Nullable class_1440.class_1443[] hiddenGene, @Nullable Boolean isPlayerCreated, @Nullable Boolean isScreamingGoat, @Nullable String[] distanceToPlayer, @Nullable Boolean creeperCharged, @Nullable class_1291[] statusEffect, @Nullable String[] items, @Nullable Boolean moving, @Nullable Map<String, String> nbtMap) {
            this.NBT_MAP = nbtMap;
            this.MOVING = moving;
            this.ITEMS = items;
            this.STATUS_EFFECT = statusEffect;
            this.CREEPER_CHARGED = creeperCharged;
            this.DISTANCE_TO_PLAYER = distanceToPlayer;
            this.SPEED_MIN_MAX = speedMinMax;
            this.JUMP_MIN_MAX = jumpMinMax;
            this.MAX_HEALTH_STRINGS = maxHealthStrings;
            this.INVENTORY_COLUMNS = inventoryColumns;
            this.IS_ANGRY = isAngry;
            this.HIDDEN_GENE = hiddenGene;
            this.IS_PLAYER_CREATED = isPlayerCreated;
            this.IS_SCREAMING_GOAT = isScreamingGoat;
            this.BIOME_VALUE_MATCHER = ETFTexturePropertyCase.getStringMatcher_Regex_Pattern_List_Single(biomesX);
            this.HEIGHT_Y_VALUES = heights;
            this.NAME_MATCHERS = ETFTexturePropertyCase.getStringMatcher_Regex_Pattern_List_Single(namesX);
            this.PROFESSION_VALUES = professionsX;
            this.COLOR_VALUES = collarColoursX;
            this.IS_BABY = baby012;
            this.WEATHER_TYPE = weather0123;
            this.HEALTH_RANGE_STRINGS = healthX;
            this.MOON_PHASE_VALUES = moonX;
            this.TIME_RANGE_STRINGS = daytimeX;
            this.BLOCK_VALUES = blocksX;
            this.TEAM_MATCHER = ETFTexturePropertyCase.getStringMatcher_Regex_Pattern_List_Single(teamsX);
            this.SIZE_VALUES = sizeX;
            if (weightsX == null) {
                weightsX = new Integer[]{};
            }
            if (weightsX.length > 0) {
                if (weightsX.length == suffixesX.length) {
                    ArrayList<Integer> buildWeighted = new ArrayList<Integer>();
                    int index = 0;
                    Integer[] integerArray = suffixesX;
                    int n = integerArray.length;
                    for (int i = 0; i < n; ++i) {
                        int suffix = integerArray[i];
                        Integer weightValue = weightsX[index];
                        if (weightValue != null) {
                            for (int i2 = 0; i2 < weightValue; ++i2) {
                                buildWeighted.add(suffix);
                            }
                        }
                        ++index;
                    }
                    this.SUFFIX_NUMBERS_WEIGHTED = buildWeighted.toArray(new Integer[0]);
                } else {
                    ETFUtils2.logWarn("random texture weights don't match for:\n suffixes: " + Arrays.toString((Object[])suffixesX) + "\n weights: " + Arrays.toString((Object[])weightsX), false);
                    this.SUFFIX_NUMBERS_WEIGHTED = suffixesX;
                }
            } else {
                this.SUFFIX_NUMBERS_WEIGHTED = suffixesX;
            }
            this.isNullPropertyCase = this.BIOME_VALUE_MATCHER == null && this.NAME_MATCHERS == null && this.HEIGHT_Y_VALUES == null && this.PROFESSION_VALUES == null && this.COLOR_VALUES == null && this.IS_BABY == null && this.WEATHER_TYPE == null && this.HEALTH_RANGE_STRINGS == null && this.MOON_PHASE_VALUES == null && this.TIME_RANGE_STRINGS == null && this.BLOCK_VALUES == null && this.TEAM_MATCHER == null && this.SIZE_VALUES == null && this.SPEED_MIN_MAX == null && this.JUMP_MIN_MAX == null && this.MAX_HEALTH_STRINGS == null && this.INVENTORY_COLUMNS == null && this.IS_ANGRY == null && this.HIDDEN_GENE == null && this.IS_PLAYER_CREATED == null && this.IS_SCREAMING_GOAT == null && this.DISTANCE_TO_PLAYER == null && this.CREEPER_CHARGED == null && this.STATUS_EFFECT == null && this.ITEMS == null && this.MOVING == null && this.NBT_MAP == null;
        }

        @Nullable
        private static StringPropertyMatcher getStringMatcher_Regex_Pattern_List_Single(@Nullable String propertyLineToBeMatchedPossiblyRegex) {
            boolean invert;
            if (propertyLineToBeMatchedPossiblyRegex == null || propertyLineToBeMatchedPossiblyRegex.isBlank()) {
                return null;
            }
            Object stringToMatch = propertyLineToBeMatchedPossiblyRegex.trim();
            if (((String)stringToMatch).startsWith("!")) {
                stringToMatch = ((String)stringToMatch).replaceFirst("!", "");
                invert = true;
            } else {
                invert = false;
            }
            if (((String)stringToMatch).contains("regex:")) {
                if (((String)stringToMatch).contains("iregex:")) {
                    Object finalStringToMatch = stringToMatch = ((String)stringToMatch).replaceFirst("iregex:", "");
                    return arg_0 -> ETFTexturePropertyCase.lambda$getStringMatcher_Regex_Pattern_List_Single$0(invert, (String)finalStringToMatch, arg_0);
                }
                Object finalStringToMatch = stringToMatch = ((String)stringToMatch).replaceFirst("regex:", "");
                return arg_0 -> ETFTexturePropertyCase.lambda$getStringMatcher_Regex_Pattern_List_Single$1(invert, (String)finalStringToMatch, arg_0);
            }
            if (((String)stringToMatch).contains("pattern:")) {
                stringToMatch = "\\Q" + (String)stringToMatch;
                if (((String)(stringToMatch = ((String)stringToMatch).replace("*", "\\E.*\\Q").replace("?", "\\E.+\\Q"))).contains("ipattern:")) {
                    Object finalStringToMatch = stringToMatch = ((String)stringToMatch).replace("ipattern:", "");
                    return arg_0 -> ETFTexturePropertyCase.lambda$getStringMatcher_Regex_Pattern_List_Single$2(invert, (String)finalStringToMatch, arg_0);
                }
                Object finalStringToMatch = stringToMatch = ((String)stringToMatch).replace("pattern:", "");
                return arg_0 -> ETFTexturePropertyCase.lambda$getStringMatcher_Regex_Pattern_List_Single$3(invert, (String)finalStringToMatch, arg_0);
            }
            String finalStringToMatch1 = stringToMatch;
            boolean finalDoPattern = finalStringToMatch1.contains("\"");
            String[] finalSplitMatches = ((String)stringToMatch).split("\\s+");
            return string -> {
                boolean check = false;
                if (string.equals(finalStringToMatch1)) {
                    check = true;
                } else {
                    for (String singleValue : finalSplitMatches) {
                        if (!string.equals(singleValue)) continue;
                        check = true;
                        break;
                    }
                    if (finalDoPattern && !check) {
                        Matcher m = groupByQuotationPattern.matcher(finalStringToMatch1);
                        while (m.find()) {
                            String foundInBrackets = m.group(1).replace("\"", "").trim();
                            if (!string.equals(foundInBrackets)) continue;
                            check = true;
                            break;
                        }
                    }
                }
                return invert != check;
            };
        }

        public String toString() {
            return "randomCase{weightedSuffixes=" + Arrays.toString((Object[])this.SUFFIX_NUMBERS_WEIGHTED) + ", biomes=" + this.BIOME_VALUE_MATCHER + ", heights=" + Arrays.toString((Object[])this.HEIGHT_Y_VALUES) + ", names=" + this.NAME_MATCHERS + "}";
        }

        private static boolean isStringValidInt(String string) {
            try {
                Integer.parseInt(string);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        public boolean doesEntityMeetConditionsOfThisCase(class_1297 entity, boolean isUpdate, Object2BooleanOpenHashMap<UUID> UUID_CaseHasUpdateablesCustom) {
            return this.doesEntityMeetConditionsOfThisCase(new ETFEntityWrapper(entity), isUpdate, UUID_CaseHasUpdateablesCustom);
        }

        public boolean doesEntityMeetConditionsOfThisCase(class_2586 entity, UUID uuid, boolean isUpdate, Object2BooleanOpenHashMap<UUID> UUID_CaseHasUpdateablesCustom) {
            return this.doesEntityMeetConditionsOfThisCase(new ETFBlockEntityWrapper(entity, uuid), isUpdate, UUID_CaseHasUpdateablesCustom);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean doesEntityMeetConditionsOfThisCase(ETFEntity etfEntity, boolean isUpdate, Object2BooleanOpenHashMap<UUID> UUID_CaseHasUpdateablesCustom) {
            boolean doesEntityMeetThisCaseTest;
            boolean wasEntityTestedByAnUpdatableProperty;
            block137: {
                block152: {
                    String[] str;
                    Object nbtPathInstructionIterator;
                    ObjectImmutableList<String> spawnConditions;
                    class_1297 entity;
                    block138: {
                        class_2487 entityNBT;
                        block139: {
                            if (this.isNullPropertyCase) {
                                return true;
                            }
                            if (!ETFClientCommon.ETFConfigData.restrictUpdateProperties) {
                                isUpdate = false;
                            }
                            UUID id = etfEntity.getUuid();
                            entity = etfEntity.entity();
                            if (ETFClientCommon.ETFConfigData.restrictUpdateProperties) {
                                if (ETFManager.getInstance().ENTITY_SPAWN_CONDITIONS_CACHE.containsKey(id)) {
                                    spawnConditions = ETFManager.getInstance().ENTITY_SPAWN_CONDITIONS_CACHE.get(id);
                                } else {
                                    spawnConditions = this.readAllSpawnConditionsForCache(etfEntity);
                                    ETFManager.getInstance().ENTITY_SPAWN_CONDITIONS_CACHE.put(id, spawnConditions);
                                }
                            } else {
                                spawnConditions = null;
                            }
                            wasEntityTestedByAnUpdatableProperty = false;
                            doesEntityMeetThisCaseTest = true;
                            if (this.BIOME_VALUE_MATCHER != null) {
                                if (!ETFClientCommon.ETFConfigData.restrictBiome) {
                                    wasEntityTestedByAnUpdatableProperty = true;
                                }
                                String entityBiome = isUpdate && ETFClientCommon.ETFConfigData.restrictBiome && ETFClientCommon.ETFConfigData.restrictUpdateProperties && spawnConditions != null && spawnConditions.size() > 1 ? ((String)spawnConditions.get(0)).trim() : ETFVersionDifferenceHandler.getBiomeString(etfEntity.getWorld(), etfEntity.getBlockPos()).replace("minecraft:", "");
                                doesEntityMeetThisCaseTest = this.BIOME_VALUE_MATCHER.testPropertyString(entityBiome);
                            }
                            if (!doesEntityMeetThisCaseTest || this.NBT_MAP == null) break block138;
                            wasEntityTestedByAnUpdatableProperty = true;
                            class_1297 internal = etfEntity.entity();
                            entityNBT = internal != null ? class_2105.method_9076((class_1297)internal) : etfEntity.writeNbt(new class_2487());
                            if (!entityNBT.method_33133()) break block139;
                            ETFUtils2.logError("NBT test failed, as could not read entity NBT");
                            doesEntityMeetThisCaseTest = false;
                            break block138;
                        }
                        for (Map.Entry entry : this.NBT_MAP.entrySet()) {
                            boolean doesTestPass;
                            boolean invertFinalResult;
                            block135: {
                                Object nbtNumber;
                                StringPropertyMatcher matcher;
                                String nbtTestInstruction;
                                block150: {
                                    String rawMatchString;
                                    String rawStringFromNBT;
                                    block151: {
                                        String nbtIdentifier;
                                        block143: {
                                            class_2487 finalNBTElementOrNullIfFailed;
                                            block148: {
                                                block149: {
                                                    class_2483 nbtList;
                                                    boolean listIndexInstructionWasWildCard;
                                                    block147: {
                                                        block146: {
                                                            block145: {
                                                                String rawStringFromNBT2;
                                                                block144: {
                                                                    nbtIdentifier = (String)entry.getKey();
                                                                    nbtTestInstruction = (String)entry.getValue();
                                                                    invertFinalResult = nbtTestInstruction.startsWith("!");
                                                                    if ((nbtTestInstruction = nbtTestInstruction.replaceFirst("!", "")).startsWith("print:")) {
                                                                        ETFUtils2.logMessage("NBT entity data print: ");
                                                                        System.out.println(entityNBT.method_10714());
                                                                        nbtTestInstruction = nbtTestInstruction.replaceFirst("print:", "");
                                                                    }
                                                                    finalNBTElementOrNullIfFailed = null;
                                                                    listIndexInstructionWasWildCard = false;
                                                                    class_2487 lastIterationNBTElement = entityNBT;
                                                                    nbtPathInstructionIterator = Arrays.stream(nbtIdentifier.split("\\.")).iterator();
                                                                    while (nbtPathInstructionIterator.hasNext()) {
                                                                        block141: {
                                                                            String nextPathInstruction;
                                                                            block142: {
                                                                                block140: {
                                                                                    if (lastIterationNBTElement == null) {
                                                                                        System.out.println("null nbt in ETF");
                                                                                        break;
                                                                                    }
                                                                                    nextPathInstruction = (String)nbtPathInstructionIterator.next();
                                                                                    if (!(lastIterationNBTElement instanceof class_2487)) break block140;
                                                                                    class_2487 nbtCompound = lastIterationNBTElement;
                                                                                    if (!nbtCompound.method_10545(nextPathInstruction)) break;
                                                                                    lastIterationNBTElement = nbtCompound.method_10580(nextPathInstruction);
                                                                                    break block141;
                                                                                }
                                                                                if (!(lastIterationNBTElement instanceof class_2483)) break block142;
                                                                                nbtList = (class_2483)lastIterationNBTElement;
                                                                                if ("*".equals(nextPathInstruction)) {
                                                                                    listIndexInstructionWasWildCard = true;
                                                                                    break block141;
                                                                                } else {
                                                                                    if (ETFTexturePropertyCase.isStringValidInt(nextPathInstruction)) {
                                                                                        try {
                                                                                            int index = Integer.parseInt(nextPathInstruction);
                                                                                            lastIterationNBTElement = (class_2520)nbtList.get(index);
                                                                                        }
                                                                                        catch (IndexOutOfBoundsException e) {
                                                                                            break;
                                                                                        }
                                                                                    }
                                                                                    ETFUtils2.logWarn("cannot parse list index of [" + nextPathInstruction + "] in nbt property: " + nbtIdentifier);
                                                                                    break;
                                                                                }
                                                                            }
                                                                            ETFUtils2.logError("cannot parse next nbt instruction of [" + nextPathInstruction + "] in nbt property: " + nbtIdentifier + ", as this nbt is not a list or compound and cannot have further instructions");
                                                                            break;
                                                                        }
                                                                        if (nbtPathInstructionIterator.hasNext()) continue;
                                                                        finalNBTElementOrNullIfFailed = lastIterationNBTElement;
                                                                    }
                                                                    doesTestPass = false;
                                                                    if (finalNBTElementOrNullIfFailed == null) break block143;
                                                                    if (!nbtTestInstruction.startsWith("print_raw:")) break block144;
                                                                    rawStringFromNBT2 = finalNBTElementOrNullIfFailed.method_10714();
                                                                    String rawMatchString2 = nbtTestInstruction.replaceFirst("print_raw:", "");
                                                                    ETFUtils2.logMessage("NBT RAW data of: " + nbtIdentifier + "=" + rawStringFromNBT2);
                                                                    matcher = ETFTexturePropertyCase.getStringMatcher_Regex_Pattern_List_Single(rawMatchString2);
                                                                    doesTestPass = matcher != null && matcher.testPropertyString(rawStringFromNBT2);
                                                                    break block135;
                                                                }
                                                                if (!nbtTestInstruction.startsWith("raw:")) break block145;
                                                                rawStringFromNBT2 = finalNBTElementOrNullIfFailed.method_10714();
                                                                String rawMatchString3 = nbtTestInstruction.replaceFirst("raw:", "");
                                                                matcher = ETFTexturePropertyCase.getStringMatcher_Regex_Pattern_List_Single(rawMatchString3);
                                                                doesTestPass = matcher != null && matcher.testPropertyString(rawStringFromNBT2);
                                                                break block135;
                                                            }
                                                            if (!nbtTestInstruction.startsWith("exists:")) break block146;
                                                            doesTestPass = nbtTestInstruction.contains("exists:true");
                                                            break block135;
                                                        }
                                                        if (!nbtTestInstruction.startsWith("range:")) break block147;
                                                        if (finalNBTElementOrNullIfFailed instanceof class_2514) {
                                                            nbtNumber = (class_2514)finalNBTElementOrNullIfFailed;
                                                            String rawRangeString = nbtTestInstruction.replaceFirst("range:", "");
                                                            IntRange range = ETFTexturePropertiesUtils.getIntRange(rawRangeString);
                                                            doesTestPass = range.isWithinRange(nbtNumber.method_10702().intValue());
                                                            break block135;
                                                        } else {
                                                            ETFUtils2.logWarn("NBT range is not valid for non number nbt types: " + nbtIdentifier + "=" + nbtTestInstruction);
                                                        }
                                                        break block135;
                                                    }
                                                    if (!(finalNBTElementOrNullIfFailed instanceof class_2483)) break block148;
                                                    nbtList = (class_2483)finalNBTElementOrNullIfFailed;
                                                    if (!listIndexInstructionWasWildCard) break block149;
                                                    nbtNumber = nbtList.iterator();
                                                    break block150;
                                                }
                                                ETFUtils2.logWarn("NBT list error with: " + nbtIdentifier + "=" + nbtTestInstruction);
                                                break block135;
                                            }
                                            StringPropertyMatcher matcher2 = ETFTexturePropertyCase.getStringMatcher_Regex_Pattern_List_Single(nbtTestInstruction);
                                            doesTestPass = matcher2 != null && matcher2.testPropertyString(finalNBTElementOrNullIfFailed.method_10714());
                                            break block135;
                                        }
                                        if (!nbtTestInstruction.startsWith("print_raw:")) break block151;
                                        rawStringFromNBT = "";
                                        rawMatchString = nbtTestInstruction.replaceFirst("print_raw:", "");
                                        ETFUtils2.logMessage("NBT RAW data of: " + nbtIdentifier + "=" + rawStringFromNBT);
                                        doesTestPass = rawMatchString.equals(rawStringFromNBT);
                                        break block135;
                                    }
                                    if (nbtTestInstruction.startsWith("raw:")) {
                                        rawStringFromNBT = "";
                                        rawMatchString = nbtTestInstruction.replaceFirst("raw:", "");
                                        doesTestPass = rawMatchString.equals(rawStringFromNBT);
                                        break block135;
                                    } else if (nbtTestInstruction.startsWith("exists:")) {
                                        doesTestPass = nbtTestInstruction.contains("exists:false");
                                    }
                                    break block135;
                                }
                                while (nbtNumber.hasNext()) {
                                    class_2520 element = (class_2520)nbtNumber.next();
                                    matcher = ETFTexturePropertyCase.getStringMatcher_Regex_Pattern_List_Single(nbtTestInstruction);
                                    doesTestPass = matcher != null && matcher.testPropertyString(element.method_10714());
                                    if (!doesTestPass) continue;
                                }
                            }
                            if (doesEntityMeetThisCaseTest = invertFinalResult != doesTestPass) continue;
                        }
                    }
                    if (doesEntityMeetThisCaseTest && this.NAME_MATCHERS != null) {
                        wasEntityTestedByAnUpdatableProperty = true;
                        if (etfEntity.hasCustomName()) {
                            String entityName = Objects.requireNonNull(etfEntity.getCustomName()).getString();
                            doesEntityMeetThisCaseTest = this.NAME_MATCHERS.testPropertyString(entityName);
                        } else {
                            doesEntityMeetThisCaseTest = false;
                        }
                    }
                    if (doesEntityMeetThisCaseTest && this.HEIGHT_Y_VALUES != null) {
                        if (!ETFClientCommon.ETFConfigData.restrictHeight) {
                            wasEntityTestedByAnUpdatableProperty = true;
                        }
                        int entityHeight = isUpdate && ETFClientCommon.ETFConfigData.restrictHeight && ETFClientCommon.ETFConfigData.restrictUpdateProperties && spawnConditions != null && spawnConditions.size() > 2 ? Integer.parseInt(((String)spawnConditions.get(1)).trim()) : etfEntity.getBlockY();
                        boolean check = false;
                        Integer[] integerArray = this.HEIGHT_Y_VALUES;
                        int n = integerArray.length;
                        for (int nbtIdentifier = 0; nbtIdentifier < n; ++nbtIdentifier) {
                            int i = (Integer)integerArray[nbtIdentifier];
                            if (i != entityHeight) continue;
                            check = true;
                            break;
                        }
                        doesEntityMeetThisCaseTest = check;
                    }
                    if (doesEntityMeetThisCaseTest && this.PROFESSION_VALUES != null && entity instanceof class_1646) {
                        wasEntityTestedByAnUpdatableProperty = true;
                        String entityProfession = ((class_1646)entity).method_7231().method_16924().toString().toLowerCase().replace("minecraft:", "");
                        int entityProfessionLevel = ((class_1646)entity).method_7231().method_16925();
                        boolean check = false;
                        block6: for (String str2 : this.PROFESSION_VALUES) {
                            int doesTestPass;
                            ArrayList<Integer> levelData;
                            block136: {
                                if (str2 == null) continue;
                                if ((str2 = str2.toLowerCase().replaceAll("\\s*", "").replace("minecraft:", "")).contains(":")) {
                                    String[] data = str2.split(":\\d");
                                    if (!entityProfession.contains(data[0]) && !data[0].contains(entityProfession)) continue;
                                    if (data.length == 2) {
                                        String[] levels = data[1].split(",");
                                        levelData = new ArrayList<Integer>();
                                        nbtPathInstructionIterator = levels;
                                        doesTestPass = ((String[])nbtPathInstructionIterator).length;
                                        break block136;
                                    } else {
                                        check = true;
                                        break;
                                    }
                                }
                                if (!entityProfession.contains(str2) && !str2.contains(entityProfession)) continue;
                                check = true;
                                break;
                            }
                            for (int i = 0; i < doesTestPass; ++i) {
                                String lvls = nbtPathInstructionIterator[i];
                                if (lvls.contains("-")) {
                                    levelData.addAll(Arrays.asList(ETFTexturePropertiesUtils.getIntRange(lvls).getAllWithinRangeAsList()));
                                    continue;
                                }
                                levelData.add(Integer.parseInt(lvls.replaceAll("\\D", "")));
                            }
                            for (Integer i : levelData) {
                                if (i != entityProfessionLevel) continue;
                                check = true;
                                continue block6;
                            }
                        }
                        doesEntityMeetThisCaseTest = check;
                    }
                    if (doesEntityMeetThisCaseTest && this.COLOR_VALUES != null) {
                        String entityColor;
                        wasEntityTestedByAnUpdatableProperty = true;
                        if (entity instanceof class_1493) {
                            class_1493 wolf = (class_1493)entity;
                            entityColor = wolf.method_6713().method_7792().toLowerCase();
                        } else if (entity instanceof class_1472) {
                            class_1472 sheep = (class_1472)entity;
                            entityColor = sheep.method_6633().method_7792().toLowerCase();
                        } else if (entity instanceof class_1501) {
                            class_1501 class_15012 = (class_1501)entity;
                            str = class_15012.method_6800();
                            entityColor = str != null ? str.method_7792().toLowerCase() : "NOT_A_COLOR";
                        } else if (entity instanceof class_1451) {
                            class_1451 cat = (class_1451)entity;
                            entityColor = cat.method_16096().method_7792().toLowerCase();
                        } else {
                            class_1474 fishy;
                            class_1606 shulker;
                            entityColor = entity instanceof class_1606 ? ((str = (shulker = (class_1606)entity).method_7121()) != null ? str.method_7792().toLowerCase() : "NOT_A_COLOR") : (entity instanceof class_1474 ? ((str = class_1474.method_6652((int)(fishy = (class_1474)entity).method_47862().method_47870())) != null ? str.method_7792().toLowerCase() : "NOT_A_COLOR") : "NOT_A_COLOR");
                        }
                        boolean check = false;
                        for (String i : this.COLOR_VALUES) {
                            if (i == null || !(i = i.toLowerCase()).equals(entityColor)) continue;
                            check = true;
                            break;
                        }
                        doesEntityMeetThisCaseTest = check;
                    }
                    if (doesEntityMeetThisCaseTest && entity instanceof class_1309 && this.IS_BABY != null) {
                        wasEntityTestedByAnUpdatableProperty = true;
                        boolean bl = doesEntityMeetThisCaseTest = this.IS_BABY.booleanValue() == ((class_1309)entity).method_6109();
                    }
                    if (doesEntityMeetThisCaseTest && this.WEATHER_TYPE != null) {
                        boolean thundering;
                        boolean raining;
                        if (!ETFClientCommon.ETFConfigData.restrictWeather) {
                            wasEntityTestedByAnUpdatableProperty = true;
                        }
                        if (isUpdate && ETFClientCommon.ETFConfigData.restrictWeather && ETFClientCommon.ETFConfigData.restrictUpdateProperties && spawnConditions != null && spawnConditions.size() >= 4) {
                            String[] data = ((String)spawnConditions.get(3)).split("-");
                            raining = "1".equals(data[0].trim());
                            thundering = "1".equals(data[1].trim());
                        } else {
                            raining = etfEntity.getWorld().method_8419();
                            thundering = etfEntity.getWorld().method_8546();
                        }
                        boolean check2 = false;
                        if (this.WEATHER_TYPE == WeatherType.clear && !raining && !thundering) {
                            check2 = true;
                        } else if (this.WEATHER_TYPE == WeatherType.rain && raining) {
                            check2 = true;
                        } else if (this.WEATHER_TYPE == WeatherType.thunder && thundering) {
                            check2 = true;
                        }
                        doesEntityMeetThisCaseTest = check2;
                    }
                    if (doesEntityMeetThisCaseTest && entity instanceof class_1309 && this.HEALTH_RANGE_STRINGS != null) {
                        wasEntityTestedByAnUpdatableProperty = true;
                        boolean check = false;
                        float checkValue = ((class_1309)entity).method_6032() / ((class_1309)entity).method_6063() * 100.0f;
                        for (String hlth : this.HEALTH_RANGE_STRINGS) {
                            if (hlth == null) continue;
                            if (hlth.contains("-")) {
                                String[] str3 = hlth.split("-");
                                if (!(checkValue >= (float)Integer.parseInt(str3[0].replaceAll("\\D", ""))) || !(checkValue <= (float)Integer.parseInt(str3[1].replaceAll("\\D", "")))) continue;
                                check = true;
                                break;
                            }
                            if (checkValue != (float)Integer.parseInt(hlth.replaceAll("\\D", ""))) continue;
                            check = true;
                            break;
                        }
                        doesEntityMeetThisCaseTest = check;
                    }
                    if (doesEntityMeetThisCaseTest && this.MOON_PHASE_VALUES != null) {
                        if (!ETFClientCommon.ETFConfigData.restrictMoonPhase) {
                            wasEntityTestedByAnUpdatableProperty = true;
                        }
                        int moonPhase = isUpdate && ETFClientCommon.ETFConfigData.restrictMoonPhase && ETFClientCommon.ETFConfigData.restrictUpdateProperties && spawnConditions != null && spawnConditions.size() > 5 ? Integer.parseInt(((String)spawnConditions.get(5)).trim()) : etfEntity.getWorld().method_30273();
                        boolean check = false;
                        Integer[] check2 = this.MOON_PHASE_VALUES;
                        int n = check2.length;
                        for (int cat = 0; cat < n; ++cat) {
                            int i = check2[cat];
                            if (i != moonPhase) continue;
                            check = true;
                            break;
                        }
                        doesEntityMeetThisCaseTest = check;
                    }
                    if (doesEntityMeetThisCaseTest && this.TIME_RANGE_STRINGS != null) {
                        if (!ETFClientCommon.ETFConfigData.restrictDayTime) {
                            wasEntityTestedByAnUpdatableProperty = true;
                        }
                        boolean check = false;
                        long time = isUpdate && ETFClientCommon.ETFConfigData.restrictDayTime && ETFClientCommon.ETFConfigData.restrictUpdateProperties && spawnConditions != null && spawnConditions.size() > 4 ? Long.parseLong(((String)spawnConditions.get(4)).trim()) : etfEntity.getWorld().method_8532();
                        for (String rangeOfTime : this.TIME_RANGE_STRINGS) {
                            if (rangeOfTime == null) continue;
                            if (rangeOfTime.contains("-")) {
                                str = rangeOfTime.split("-");
                                if (time < Long.parseLong(str[0].replaceAll("\\D", "")) || time > Long.parseLong(str[1].replaceAll("\\D", ""))) continue;
                                check = true;
                                break;
                            }
                            if (time != Long.parseLong(rangeOfTime.replaceAll("\\D", ""))) continue;
                            check = true;
                            break;
                        }
                        doesEntityMeetThisCaseTest = check;
                    }
                    if (doesEntityMeetThisCaseTest && this.BLOCK_VALUES != null) {
                        boolean bl;
                        Matcher m;
                        ArrayList<String> entries;
                        String[] entityOnBlockStates;
                        String[] entityOnBlocks;
                        if (!ETFClientCommon.ETFConfigData.restrictBlock) {
                            wasEntityTestedByAnUpdatableProperty = true;
                        }
                        if (isUpdate && ETFClientCommon.ETFConfigData.restrictBlock && ETFClientCommon.ETFConfigData.restrictUpdateProperties && spawnConditions != null && spawnConditions.size() > 6) {
                            entityOnBlocks = new String[]{((String)spawnConditions.get(2)).trim(), ((String)spawnConditions.get(6)).trim()};
                            entityOnBlockStates = new String[]{((String)spawnConditions.get(7)).trim(), ((String)spawnConditions.get(8)).trim()};
                        } else {
                            class_2680 blockState1 = etfEntity.getWorld().method_8320(etfEntity.getBlockPos().method_10074());
                            String string = class_7923.field_41175.method_10221((Object)blockState1.method_26204()).toString().replaceFirst("minecraft:", "");
                            class_2680 blockState2 = etfEntity.getWorld().method_8320(etfEntity.getBlockPos());
                            String entityOnBlock2 = class_7923.field_41175.method_10221((Object)blockState2.method_26204()).toString().replaceFirst("minecraft:", "");
                            entityOnBlocks = new String[]{string, entityOnBlock2};
                            entityOnBlockStates = new String[]{blockState1.method_11656().toString(), blockState2.method_11656().toString()};
                        }
                        Pattern patterOfEntries = Pattern.compile("(?<=:)([^:]+=[^:| ]+)(?=(:|$| ))");
                        boolean bl2 = false;
                        boolean check1 = false;
                        for (String block : this.BLOCK_VALUES) {
                            if (block == null) continue;
                            entries = new ArrayList<String>();
                            if (block.contains("=")) {
                                m = patterOfEntries.matcher(block);
                                while (m.find()) {
                                    entries.add(m.group(1).replace("\"", "").trim());
                                }
                                block = block.replaceAll("(?<=:)([^:]+=[^:| ]+)(?=(:|$| ))", "").replaceAll(":+$", "");
                            }
                            if ((block = block.strip()).startsWith("!")) {
                                if (!(block = block.replaceFirst("!", "")).replace("minecraft:", "").equalsIgnoreCase(entityOnBlocks[0])) {
                                    check1 = ETFTexturePropertyCase.doBlockEntriesMatch(entries, entityOnBlockStates[0]);
                                    continue;
                                }
                                doesEntityMeetThisCaseTest = false;
                                continue;
                            }
                            if (block.replace("minecraft:", "").equalsIgnoreCase(entityOnBlocks[0]) && (check1 = ETFTexturePropertyCase.doBlockEntriesMatch(entries, entityOnBlockStates[0]))) break;
                        }
                        if (!check1) {
                            for (String block : this.BLOCK_VALUES) {
                                if (block == null) continue;
                                entries = new ArrayList();
                                if (block.contains("=")) {
                                    m = patterOfEntries.matcher(block);
                                    while (m.find()) {
                                        entries.add(m.group(1).replace("\"", "").trim());
                                    }
                                    block = block.replaceAll("(?<=:)([^:]+=[^:| ]+)(?=(:|$| ))", "").replaceAll(":+$", "");
                                }
                                if ((block = block.strip()).startsWith("!")) {
                                    if (!(block = block.replaceFirst("!", "")).replace("minecraft:", "").equalsIgnoreCase(entityOnBlocks[1])) {
                                        bl = ETFTexturePropertyCase.doBlockEntriesMatch(entries, entityOnBlockStates[1]);
                                        continue;
                                    }
                                    doesEntityMeetThisCaseTest = false;
                                    continue;
                                }
                                if (block.replace("minecraft:", "").equalsIgnoreCase(entityOnBlocks[1]) && (bl = ETFTexturePropertyCase.doBlockEntriesMatch(entries, entityOnBlockStates[1]))) break;
                            }
                        }
                        if (doesEntityMeetThisCaseTest) {
                            boolean bl3 = doesEntityMeetThisCaseTest = check1 || bl;
                        }
                    }
                    if (doesEntityMeetThisCaseTest && this.TEAM_MATCHER != null) {
                        wasEntityTestedByAnUpdatableProperty = true;
                        if (etfEntity.getScoreboardTeam() != null) {
                            String teamName = etfEntity.getScoreboardTeam().method_1197();
                            doesEntityMeetThisCaseTest = this.TEAM_MATCHER.testPropertyString(teamName);
                        } else {
                            doesEntityMeetThisCaseTest = false;
                        }
                    }
                    if (doesEntityMeetThisCaseTest && this.SIZE_VALUES != null && (entity instanceof class_1621 || entity instanceof class_1593)) {
                        int size;
                        if (entity instanceof class_1621) {
                            class_1621 slime = (class_1621)entity;
                            size = slime.method_7152() - 1;
                        } else {
                            size = ((class_1593)entity).method_7084();
                        }
                        boolean check = false;
                        Integer[] patterOfEntries = this.SIZE_VALUES;
                        int n = patterOfEntries.length;
                        for (int check1 = 0; check1 < n; ++check1) {
                            int i = patterOfEntries[check1];
                            if (i != size) continue;
                            check = true;
                            break;
                        }
                        doesEntityMeetThisCaseTest = check;
                    }
                    if (doesEntityMeetThisCaseTest && entity instanceof class_1309 && this.SPEED_MIN_MAX != null) {
                        double speed = ((class_1309)entity).method_6029();
                        Double min = this.SPEED_MIN_MAX[0];
                        Double d = this.SPEED_MIN_MAX[1];
                        if (min != null && d != null) {
                            boolean bl = doesEntityMeetThisCaseTest = speed >= min && speed <= d;
                        }
                    }
                    if (doesEntityMeetThisCaseTest && this.JUMP_MIN_MAX != null && entity instanceof class_1496) {
                        double jumpHeight = ((class_1496)entity).method_6771();
                        Double min = this.JUMP_MIN_MAX[0];
                        Double d = this.JUMP_MIN_MAX[1];
                        if (min != null && d != null) {
                            boolean bl = doesEntityMeetThisCaseTest = jumpHeight >= min && jumpHeight <= d;
                        }
                    }
                    if (doesEntityMeetThisCaseTest && entity instanceof class_1309 && this.MAX_HEALTH_STRINGS != null) {
                        boolean check = false;
                        float checkValue = ((class_1309)entity).method_6063();
                        for (String hlth : this.MAX_HEALTH_STRINGS) {
                            if (hlth == null) continue;
                            if (hlth.contains("-")) {
                                String[] str4 = hlth.split("-");
                                if (!(checkValue >= (float)Integer.parseInt(str4[0].replaceAll("\\D", ""))) || !(checkValue <= (float)Integer.parseInt(str4[1].replaceAll("\\D", "")))) continue;
                                check = true;
                                break;
                            }
                            if (checkValue != (float)Integer.parseInt(hlth.replaceAll("\\D", ""))) continue;
                            check = true;
                            break;
                        }
                        doesEntityMeetThisCaseTest = check;
                    }
                    if (doesEntityMeetThisCaseTest && this.INVENTORY_COLUMNS != null && entity instanceof class_1501) {
                        void var12_87;
                        boolean found = false;
                        Integer[] checkValue = this.INVENTORY_COLUMNS;
                        int min = checkValue.length;
                        boolean bl = false;
                        while (var12_87 < min) {
                            int columns = checkValue[var12_87];
                            if (((class_1501)entity).method_6702() == columns) {
                                found = true;
                                break;
                            }
                            ++var12_87;
                        }
                        doesEntityMeetThisCaseTest = found;
                    }
                    if (doesEntityMeetThisCaseTest && this.IS_ANGRY != null) {
                        if (entity instanceof class_1560) {
                            wasEntityTestedByAnUpdatableProperty = true;
                            doesEntityMeetThisCaseTest = ((class_1560)entity).method_7028() == this.IS_ANGRY.booleanValue();
                        } else if (entity instanceof class_1545) {
                            wasEntityTestedByAnUpdatableProperty = true;
                            doesEntityMeetThisCaseTest = entity.method_5809() == this.IS_ANGRY.booleanValue();
                        } else if (entity instanceof class_1577) {
                            wasEntityTestedByAnUpdatableProperty = true;
                            doesEntityMeetThisCaseTest = ((class_1577)entity).method_7052() != null == this.IS_ANGRY;
                        } else if (entity instanceof class_1632) {
                            wasEntityTestedByAnUpdatableProperty = true;
                            doesEntityMeetThisCaseTest = ((class_1632)entity).method_6510() == this.IS_ANGRY.booleanValue();
                        } else if (entity instanceof class_1617) {
                            wasEntityTestedByAnUpdatableProperty = true;
                            doesEntityMeetThisCaseTest = ((class_1617)entity).method_7137() == this.IS_ANGRY.booleanValue();
                        } else {
                            doesEntityMeetThisCaseTest = false;
                        }
                    }
                    if (doesEntityMeetThisCaseTest && this.HIDDEN_GENE != null && entity instanceof class_1440) {
                        void var12_89;
                        boolean found = false;
                        class_1440.class_1443[] checkValue = this.HIDDEN_GENE;
                        int min = checkValue.length;
                        boolean bl = false;
                        while (var12_89 < min) {
                            class_1440.class_1443 gene = checkValue[var12_89];
                            if (((class_1440)entity).method_6508() == gene) {
                                found = true;
                                break;
                            }
                            ++var12_89;
                        }
                        doesEntityMeetThisCaseTest = found;
                    }
                    if (doesEntityMeetThisCaseTest && this.IS_PLAYER_CREATED != null && entity instanceof class_1439) {
                        boolean bl = doesEntityMeetThisCaseTest = ((class_1439)entity).method_6496() == this.IS_PLAYER_CREATED.booleanValue();
                    }
                    if (doesEntityMeetThisCaseTest && this.IS_SCREAMING_GOAT != null && entity instanceof class_6053) {
                        boolean bl = doesEntityMeetThisCaseTest = ((class_6053)entity).method_35178() == this.IS_SCREAMING_GOAT.booleanValue();
                    }
                    if (doesEntityMeetThisCaseTest && this.DISTANCE_TO_PLAYER != null && class_310.method_1551().field_1724 != null) {
                        wasEntityTestedByAnUpdatableProperty = true;
                        boolean check = false;
                        float checkValue = etfEntity.distanceTo((class_1297)class_310.method_1551().field_1724);
                        for (String distances : this.DISTANCE_TO_PLAYER) {
                            if (distances == null) continue;
                            if (distances.contains("-")) {
                                String[] str5 = distances.split("-");
                                if (!(checkValue >= (float)Integer.parseInt(str5[0].replaceAll("\\D", ""))) || !(checkValue <= (float)Integer.parseInt(str5[1].replaceAll("\\D", "")))) continue;
                                check = true;
                                break;
                            }
                            if ((int)checkValue != Integer.parseInt(distances.replaceAll("\\D", ""))) continue;
                            check = true;
                            break;
                        }
                        doesEntityMeetThisCaseTest = check;
                    }
                    if (doesEntityMeetThisCaseTest && this.CREEPER_CHARGED != null && entity instanceof class_1548) {
                        wasEntityTestedByAnUpdatableProperty = true;
                        boolean bl = doesEntityMeetThisCaseTest = ((class_1548)entity).method_6872() == this.CREEPER_CHARGED.booleanValue();
                    }
                    if (doesEntityMeetThisCaseTest && entity instanceof class_1309 && this.STATUS_EFFECT != null) {
                        void var12_92;
                        wasEntityTestedByAnUpdatableProperty = true;
                        boolean found = false;
                        class_1291[] checkValue = this.STATUS_EFFECT;
                        int min = checkValue.length;
                        boolean bl = false;
                        while (var12_92 < min) {
                            class_1291 effect = checkValue[var12_92];
                            if (((class_1309)entity).method_6059(effect)) {
                                found = true;
                                break;
                            }
                            ++var12_92;
                        }
                        if (!found && entity instanceof class_1438) {
                            class_1438 shroom = (class_1438)entity;
                            for (class_1291 effect : this.STATUS_EFFECT) {
                                if (effect == null || !effect.equals(((MooshroomEntityAccessor)shroom).getStewEffect())) continue;
                                found = true;
                                break;
                            }
                        }
                        doesEntityMeetThisCaseTest = found;
                    }
                    if (!doesEntityMeetThisCaseTest || this.ITEMS == null) break block137;
                    wasEntityTestedByAnUpdatableProperty = true;
                    System.out.println(Arrays.toString(this.ITEMS) + " - " + etfEntity.getItemsEquipped().toString());
                    if (this.ITEMS.length != 1 || !"none".equals(this.ITEMS[0]) && !"any".equals(this.ITEMS[0]) && !"holding".equals(this.ITEMS[0]) && !"wearing".equals(this.ITEMS[0])) break block152;
                    if ("none".equals(this.ITEMS[0])) {
                        Iterable<class_1799> equipped = etfEntity.getItemsEquipped();
                        for (class_1799 item : equipped) {
                            if (item == null || item.method_7960()) continue;
                            doesEntityMeetThisCaseTest = false;
                            break block137;
                        }
                        break block137;
                    } else {
                        Iterable<class_1799> items = "any".equals(this.ITEMS[0]) ? etfEntity.getItemsEquipped() : ("holding".equals(this.ITEMS[0]) ? etfEntity.getHandItems() : etfEntity.getArmorItems());
                        boolean found = false;
                        for (class_1799 class_17992 : items) {
                            if (class_17992 == null || class_17992.method_7960()) continue;
                            found = true;
                            break;
                        }
                        doesEntityMeetThisCaseTest = found;
                    }
                    break block137;
                }
                Iterable<class_1799> equipped = etfEntity.getItemsEquipped();
                boolean found = false;
                block26: for (String itemToFind : this.ITEMS) {
                    if (itemToFind == null) continue;
                    if (itemToFind.contains("minecraft:")) {
                        itemToFind = itemToFind.replace("minecraft:", "");
                    }
                    for (class_1799 item : equipped) {
                        if (item == null || item.method_7960() || !item.method_7909().toString().replace("minecraft:", "").equals(itemToFind)) continue;
                        found = true;
                        break block26;
                    }
                }
                doesEntityMeetThisCaseTest = found;
            }
            if (doesEntityMeetThisCaseTest && this.MOVING != null) {
                wasEntityTestedByAnUpdatableProperty = true;
                boolean bl = doesEntityMeetThisCaseTest = etfEntity.getVelocity().method_37267() == 0.0 != this.MOVING;
            }
            if (wasEntityTestedByAnUpdatableProperty && UUID_CaseHasUpdateablesCustom != null) {
                UUID_CaseHasUpdateablesCustom.put((Object)etfEntity.getUuid(), true);
            }
            return doesEntityMeetThisCaseTest;
        }

        public int getAnEntityVariantSuffixFromThisCase(UUID id) {
            int randomReliable = id.hashCode() > 0 ? id.hashCode() : -id.hashCode();
            randomReliable %= this.SUFFIX_NUMBERS_WEIGHTED.length;
            randomReliable = this.SUFFIX_NUMBERS_WEIGHTED[randomReliable];
            return randomReliable;
        }

        @NotNull
        private ObjectImmutableList<String> readAllSpawnConditionsForCache(@NotNull ETFEntity entity) {
            String block2;
            @NotNull String biome = !ETFClientCommon.ETFConfigData.restrictBiome ? "" : ETFVersionDifferenceHandler.getBiomeString(entity.getWorld(), entity.getBlockPos()).replace("minecraft:", "");
            @NotNull String height = !ETFClientCommon.ETFConfigData.restrictHeight ? "" : "" + entity.getBlockY();
            @NotNull String block = !ETFClientCommon.ETFConfigData.restrictBlock ? "" : class_7923.field_41175.method_10221((Object)entity.getWorld().method_8320(entity.getBlockPos().method_10074()).method_26204()).toString().replaceFirst("minecraft:", "");
            String string = block2 = !ETFClientCommon.ETFConfigData.restrictBlock ? "" : class_7923.field_41175.method_10221((Object)entity.getWorld().method_8320(entity.getBlockPos()).method_26204()).toString().replaceFirst("minecraft:", "");
            @NotNull String weather = !ETFClientCommon.ETFConfigData.restrictWeather ? "" : (entity.getWorld().method_8419() ? "1" : "0") + "-" + (entity.getWorld().method_8546() ? "1" : "0");
            @NotNull String time = !ETFClientCommon.ETFConfigData.restrictDayTime ? "" : "" + entity.getWorld().method_8532();
            @NotNull String moon = !ETFClientCommon.ETFConfigData.restrictMoonPhase ? "" : "" + entity.getWorld().method_30273();
            @NotNull String blockState1 = !ETFClientCommon.ETFConfigData.restrictBlock ? "" : entity.getWorld().method_8320(entity.getBlockPos().method_10074()).method_11656().toString();
            @NotNull String blockState2 = !ETFClientCommon.ETFConfigData.restrictBlock ? "" : entity.getWorld().method_8320(entity.getBlockPos()).method_11656().toString();
            return ObjectImmutableList.of((Object[])new String[]{biome, height, block, weather, time, moon, block2, blockState1, blockState2});
        }

        private static boolean doBlockEntriesMatch(List<String> propertyEntries, String blockStateEntries) {
            if (propertyEntries.isEmpty()) {
                return true;
            }
            String[] fixedStateEntries = blockStateEntries.replaceFirst("\\{", "").replaceFirst("}$", "").split(", ");
            HashMap<String, String> stateMap = new HashMap<String, String>();
            for (String entry : fixedStateEntries) {
                if (!entry.contains("=")) {
                    ETFUtils2.logWarn("block state failed in property check");
                    return false;
                }
                String[] set = entry.split("=");
                stateMap.put(set[0], set[1]);
            }
            if (stateMap.isEmpty()) {
                return false;
            }
            for (String property : propertyEntries) {
                String[] set = property.split("=");
                String key = set[0];
                if (stateMap.containsKey(key)) {
                    String stateValue = (String)stateMap.get(key);
                    List<String> properties = List.of(set[1].split(","));
                    if (properties.contains(stateValue)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        private static /* synthetic */ boolean lambda$getStringMatcher_Regex_Pattern_List_Single$3(boolean invert, String finalStringToMatch, String string) {
            return invert != string.matches(finalStringToMatch);
        }

        private static /* synthetic */ boolean lambda$getStringMatcher_Regex_Pattern_List_Single$2(boolean invert, String finalStringToMatch, String string) {
            return invert != string.matches("(?i)" + finalStringToMatch);
        }

        private static /* synthetic */ boolean lambda$getStringMatcher_Regex_Pattern_List_Single$1(boolean invert, String finalStringToMatch, String string) {
            return invert != string.matches(finalStringToMatch);
        }

        private static /* synthetic */ boolean lambda$getStringMatcher_Regex_Pattern_List_Single$0(boolean invert, String finalStringToMatch, String string) {
            return invert != string.matches("(?i)" + finalStringToMatch);
        }
    }

    private static enum WeatherType {
        clear,
        rain,
        thunder;


        @Nullable
        public static WeatherType getType(String type) {
            if (type == null) {
                return null;
            }
            switch (type) {
                case "clear": {
                    return clear;
                }
                case "rain": {
                    return rain;
                }
                case "thunder": {
                    return thunder;
                }
            }
            return null;
        }
    }

    private record IntRange(int lower, int higher) {
        public boolean isWithinRange(int value) {
            return value >= this.lower && value <= this.higher;
        }

        public Integer[] getAllWithinRangeAsList() {
            if (this.lower == this.higher) {
                return new Integer[]{this.lower};
            }
            ArrayList<Integer> builder = new ArrayList<Integer>();
            for (int i = this.lower; i <= this.higher; ++i) {
                builder.add(i);
            }
            return builder.toArray(new Integer[0]);
        }
    }

    private static interface StringPropertyMatcher {
        public boolean testPropertyString(String var1);
    }
}

