/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.config.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5244;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_922;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import traben.entity_texture_features.ETFClientCommon;
import traben.entity_texture_features.ETFVersionDifferenceHandler;
import traben.entity_texture_features.config.screens.ETFConfigScreen;
import traben.entity_texture_features.config.screens.ETFConfigScreenSkinTool;
import traben.entity_texture_features.texture_handlers.ETFManager;
import traben.entity_texture_features.utils.ETFUtils2;

public class ETFConfigScreenSkinToolPixelSelection
extends ETFConfigScreen {
    private final SelectionMode MODE;
    private final ETFConfigScreenSkinTool etfParent;
    Set<Integer> selectedPixels;
    class_2960 currentSkinToRender = new class_2960("entity_texture_features:textures/gui/icon.png");

    protected ETFConfigScreenSkinToolPixelSelection(ETFConfigScreenSkinTool parent, SelectionMode mode) {
        super(ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features" + (mode == SelectionMode.EMISSIVE ? ".emissive_select" : ".enchanted_select") + ".title"), parent);
        this.MODE = mode;
        this.etfParent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        class_2960 randomID = new class_2960("entity_texture_features_ignore", "gui_skin_" + System.currentTimeMillis() + ".png");
        if (ETFUtils2.registerNativeImageToIdentifier(this.etfParent.currentEditorSkin, randomID)) {
            this.currentSkinToRender = randomID;
        }
        this.selectedPixels = new HashSet<Integer>();
        for (int x = this.MODE.startX; x < this.MODE.startX + 8; ++x) {
            for (int y = this.MODE.startY; y < this.MODE.startY + 8; ++y) {
                int color = this.etfParent.currentEditorSkin.method_4315(x, y);
                if (color == 0) continue;
                this.selectedPixels.add(color);
            }
        }
        this.method_37063((class_364)this.getETFButton((int)((double)this.field_22789 * 0.024), (int)((double)this.field_22790 * 0.2), 20, 20, class_2561.method_30163((String)"\u27f3"), button -> {
            this.etfParent.flipView = !this.etfParent.flipView;
        }));
        this.method_37063((class_364)this.getETFButton((int)((double)this.field_22789 * 0.55), (int)((double)this.field_22790 * 0.9), (int)((double)this.field_22789 * 0.2), 20, class_5244.field_24339, button -> Objects.requireNonNull(this.field_22787).method_1507(this.parent)));
        int pixelSize = (int)((double)this.field_22790 * 0.7 / 64.0);
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 64; ++y) {
                int finalX = x;
                int finalY = y;
                class_4185 butt = new class_4185((int)((double)this.field_22789 * 0.35 + (double)(x * pixelSize)), (int)((double)this.field_22790 * 0.2 + (double)(y * pixelSize)), pixelSize, pixelSize, class_2561.method_30163((String)""), button -> {
                    int colorAtPixel = this.etfParent.currentEditorSkin.method_4315(finalX, finalY);
                    if (this.selectedPixels.contains(colorAtPixel)) {
                        this.selectedPixels.remove(colorAtPixel);
                    } else {
                        this.selectedPixels.add(colorAtPixel);
                    }
                    this.applyCurrentSelectedPixels();
                    this.etfParent.thisETFPlayerTexture.changeSkinToThisForTool(this.etfParent.currentEditorSkin);
                    class_2960 randomID2 = new class_2960("entity_texture_features_ignore", "gui_skin_" + System.currentTimeMillis() + ".png");
                    if (ETFUtils2.registerNativeImageToIdentifier(this.etfParent.currentEditorSkin, randomID2)) {
                        this.currentSkinToRender = randomID2;
                    }
                }, Supplier::get){

                    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
                    }
                };
                this.method_37063((class_364)butt);
            }
        }
    }

    private void applyCurrentSelectedPixels() {
        ArrayList<Integer> integerSet = new ArrayList<Integer>(this.selectedPixels);
        for (int x = this.MODE.startX; x < this.MODE.startX + 8; ++x) {
            for (int y = this.MODE.startY; y < this.MODE.startY + 8; ++y) {
                if (integerSet.isEmpty()) {
                    this.etfParent.currentEditorSkin.method_4305(x, y, 0);
                    continue;
                }
                this.etfParent.currentEditorSkin.method_4305(x, y, integerSet.get(0).intValue());
                integerSet.remove(0);
            }
        }
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int pixelSize = (int)((double)this.field_22790 * 0.7 / 64.0);
        ETFConfigScreenSkinToolPixelSelection.renderGUITexture(this.currentSkinToRender, (int)((double)this.field_22789 * 0.35), (int)((double)this.field_22790 * 0.2), (int)((double)this.field_22789 * 0.35 + (double)(64 * pixelSize)), (int)((double)this.field_22790 * 0.2 + (double)(64 * pixelSize)));
        context.method_27535(this.field_22793, ETFVersionDifferenceHandler.getTextFromTranslation("config.entity_texture_features.skin_select" + (this.selectedPixels.size() > 64 ? ".warn" : ".hint")), this.field_22789 / 7, (int)((double)this.field_22790 * 0.8), this.selectedPixels.size() > 64 ? 0xFF1515 : 0xFFFFFF);
        if (class_310.method_1551() != null) {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                int blinkModifierBySystemTimeInTicks = (int)(System.currentTimeMillis() / 50L % (long)(30 + ETFClientCommon.ETFConfigData.blinkLength * 2));
                ETFManager.getInstance().ENTITY_BLINK_TIME.put((Object)player.method_5667(), player.method_37908().method_8510() + (long)blinkModifierBySystemTimeInTicks - (long)(15 + ETFClientCommon.ETFConfigData.blinkLength));
                int height = (int)((double)this.field_22790 * 0.75);
                int playerX = (int)((double)this.field_22789 * 0.14);
                this.drawEntity(playerX, height, (int)((double)this.field_22790 * 0.3), -mouseX + playerX, (float)((double)(-mouseY) + (double)this.field_22790 * 0.3), (class_1309)player);
            } else {
                context.method_27535(this.field_22793, class_2561.method_30163((String)"Player model only visible while in game!"), this.field_22789 / 7, (int)((double)this.field_22790 * 0.4), 0xFFFFFF);
                context.method_27535(this.field_22793, class_2561.method_30163((String)"load a single-player world and then open this menu."), this.field_22789 / 7, (int)((double)this.field_22790 * 0.45), 0xFFFFFF);
            }
        }
    }

    public void drawEntity(int x, int y, int size, float mouseX, float mouseY, class_1309 entity) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float g = (float)Math.atan(mouseY / 40.0f);
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_22904((double)x, (double)y, 1050.0);
        matrixStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 matrixStack2 = new class_4587();
        matrixStack2.method_22904(0.0, 0.0, 1000.0);
        matrixStack2.method_22905((float)size, (float)size, (float)size);
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(g * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        matrixStack2.method_22907(quaternionf);
        float h = entity.field_6283;
        float i = entity.method_36454();
        float j = entity.method_36455();
        float k = entity.field_6259;
        float l = entity.field_6241;
        entity.field_6283 = (this.etfParent.flipView ? 0.0f : 180.0f) + f * 20.0f;
        entity.method_36456((this.etfParent.flipView ? 0.0f : 180.0f) + f * 40.0f);
        entity.method_36457(-g * 20.0f);
        entity.field_6241 = entity.method_36454();
        entity.field_6259 = entity.method_36454();
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        quaternionf2.conjugate();
        entityRenderDispatcher.method_24196(quaternionf2);
        entityRenderDispatcher.method_3948(false);
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.method_3954((class_1297)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack2, (class_4597)immediate, 0x800080));
        immediate.method_22993();
        class_4597.class_4598 immediate2 = class_310.method_1551().method_22940().method_23000();
        RenderSystem.runAsFancy(() -> {
            class_897 bob;
            class_1921 layer;
            class_4588 vertexC;
            class_2960 emissive;
            if (this.etfParent.thisETFPlayerTexture != null && this.etfParent.thisETFPlayerTexture.etfTextureOfFinalBaseSkin != null && entity instanceof class_742 && (emissive = this.etfParent.thisETFPlayerTexture.etfTextureOfFinalBaseSkin.getEmissiveIdentifierOfCurrentState()) != null && (vertexC = immediate.getBuffer(layer = class_1921.method_23580((class_2960)emissive))) != null && (bob = entityRenderDispatcher.method_3953((class_1297)entity)) instanceof class_922) {
                ((class_922)bob).method_4038().method_2828(matrixStack, vertexC, 0xF000F2, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        });
        immediate2.method_22993();
        entityRenderDispatcher.method_3948(true);
        entity.field_6283 = h;
        entity.method_36456(i);
        entity.method_36457(j);
        entity.field_6259 = k;
        entity.field_6241 = l;
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }

    public static enum SelectionMode {
        EMISSIVE(56, 16),
        ENCHANTED(56, 24);

        final int startX;
        final int startY;

        private SelectionMode(int start_x, int start_y) {
            this.startX = start_x;
            this.startY = start_y;
        }
    }
}

