/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl;

import dynamic_fps.impl.GraphicsState;
import dynamic_fps.impl.PowerState;
import dynamic_fps.impl.compat.FREX;
import dynamic_fps.impl.config.Config;
import dynamic_fps.impl.config.DynamicFPSConfig;
import dynamic_fps.impl.util.HudInfoRenderer;
import dynamic_fps.impl.util.KeyMappingHandler;
import dynamic_fps.impl.util.Localization;
import dynamic_fps.impl.util.Logging;
import dynamic_fps.impl.util.ModCompatibility;
import dynamic_fps.impl.util.OptionsHolder;
import dynamic_fps.impl.util.WindowObserver;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_4071;
import net.minecraft.class_425;
import net.minecraft.class_433;

public class DynamicFPSMod
implements ClientModInitializer {
    public static final String MOD_ID = "dynamic_fps";
    public static final boolean DEBUG = FabricLoader.getInstance().isDevelopmentEnvironment();
    private static Config config = Config.ACTIVE;
    private static PowerState state = PowerState.FOCUSED;
    public static DynamicFPSConfig modConfig = DynamicFPSConfig.load();
    private static boolean isDisabled = false;
    private static boolean isForcingLowFPS = false;
    private static class_310 minecraft;
    private static WindowObserver window;
    private static long lastRender;
    private static boolean hasRenderedLastFrame;
    private static final boolean OVERLAY_OPTIMIZATION_ACTIVE;
    private static final KeyMappingHandler toggleForcedKeyBinding;
    private static final KeyMappingHandler toggleDisabledKeyBinding;

    public void onInitializeClient() {
        modConfig.save();
        toggleForcedKeyBinding.register();
        toggleDisabledKeyBinding.register();
        HudRenderCallback.EVENT.register((Object)new HudInfoRenderer());
    }

    public static boolean isDisabled() {
        return isDisabled;
    }

    public static void onStatusChanged() {
        DynamicFPSMod.checkForStateChanges();
    }

    public static PowerState powerState() {
        return state;
    }

    public static boolean isForcingLowFPS() {
        return isForcingLowFPS;
    }

    public static void setWindow(long address) {
        window = new WindowObserver(address);
    }

    public static boolean checkForRender() {
        long currentTime = class_156.method_659();
        long timeSinceLastRender = currentTime - lastRender;
        if (!DynamicFPSMod.checkForRender(timeSinceLastRender)) {
            return false;
        }
        lastRender = currentTime;
        return true;
    }

    public static int targetFrameRate() {
        return config.frameRateTarget();
    }

    public static boolean shouldShowToasts() {
        return config.showToasts();
    }

    public static boolean shouldShowLevels() {
        return DynamicFPSMod.isDisabledInternal() || !DynamicFPSMod.isLevelCoveredByScreen() && !DynamicFPSMod.isLevelCoveredByOverlay();
    }

    private static boolean isDisabledInternal() {
        return isDisabled || FREX.isFlawlessFramesActive();
    }

    private static boolean isPauseScreenOpened() {
        return DynamicFPSMod.minecraft.field_1755 instanceof class_433;
    }

    private static boolean isLevelCoveredByScreen() {
        return DynamicFPSMod.minecraft.field_1755 != null && DynamicFPSMod.minecraft.field_1755.dynamic_fps$rendersBackground();
    }

    private static boolean isLevelCoveredByOverlay() {
        class_425 loadingOverlay;
        class_4071 class_40712;
        return OVERLAY_OPTIMIZATION_ACTIVE && (class_40712 = minecraft.method_18506()) instanceof class_425 && (loadingOverlay = (class_425)class_40712).dynamic_fps$isReloadComplete();
    }

    public static void handleStateChange(PowerState previous, PowerState current) {
        if (DEBUG) {
            Logging.getLogger().info("State changed from {} to {}.", (Object)previous, (Object)current);
        }
        Config before = config;
        config = modConfig.get(current);
        hasRenderedLastFrame = false;
        if (config.runGarbageCollector()) {
            System.gc();
        }
        if (before.volumeMultiplier() != config.volumeMultiplier()) {
            DynamicFPSMod.setVolumeMultiplier(config.volumeMultiplier());
        }
        if (before.graphicsState() != config.graphicsState()) {
            if (before.graphicsState() == GraphicsState.DEFAULT) {
                OptionsHolder.copyOptions(DynamicFPSMod.minecraft.field_1690);
            }
            OptionsHolder.applyOptions(DynamicFPSMod.minecraft.field_1690, config.graphicsState());
        }
    }

    private static void checkForStateChanges() {
        if (window == null) {
            return;
        }
        if (minecraft == null) {
            minecraft = class_310.method_1551();
        }
        PowerState current = DynamicFPSMod.isDisabledInternal() ? PowerState.FOCUSED : (isForcingLowFPS ? PowerState.UNFOCUSED : (window.isFocused() ? (!DynamicFPSMod.isPauseScreenOpened() ? PowerState.FOCUSED : PowerState.SUSPENDED) : (window.isHovered() ? PowerState.HOVERED : (!window.isIconified() ? PowerState.UNFOCUSED : PowerState.INVISIBLE))));
        if (state != current) {
            PowerState previous = state;
            state = current;
            DynamicFPSMod.handleStateChange(previous, current);
        }
    }

    private static boolean willPauseSounds() {
        return !minecraft.method_1569() && DynamicFPSMod.minecraft.field_1690.field_1837 && DynamicFPSMod.minecraft.field_1755 == null;
    }

    private static void setVolumeMultiplier(float multiplier) {
        if (multiplier == 0.0f && DynamicFPSMod.willPauseSounds()) {
            return;
        }
        float baseVolume = DynamicFPSMod.minecraft.field_1690.method_1630(class_3419.field_15250);
        minecraft.method_1483().method_4865(class_3419.field_15250, baseVolume * multiplier);
    }

    private static boolean checkForRender(long timeSinceLastRender) {
        int frameRateTarget = config.frameRateTarget();
        if (frameRateTarget <= 0) {
            return frameRateTarget == -1;
        }
        if (!hasRenderedLastFrame) {
            hasRenderedLastFrame = true;
            return true;
        }
        long frameTime = 1000 / frameRateTarget;
        return timeSinceLastRender >= frameTime;
    }

    static {
        hasRenderedLastFrame = false;
        OVERLAY_OPTIMIZATION_ACTIVE = !ModCompatibility.disableOverlayOptimization();
        toggleForcedKeyBinding = new KeyMappingHandler(Localization.translationKey("key", "toggle_forced"), "key.categories.misc", () -> {
            isForcingLowFPS = !isForcingLowFPS;
            DynamicFPSMod.onStatusChanged();
        });
        toggleDisabledKeyBinding = new KeyMappingHandler(Localization.translationKey("key", "toggle_disabled"), "key.categories.misc", () -> {
            isDisabled = !isDisabled;
            DynamicFPSMod.onStatusChanged();
        });
    }
}

