/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes.util.object;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Objects;

public enum Weather {
    CLEAR("clear"),
    RAIN("rain"),
    BIOME_RAIN("rain_biome"),
    SNOW("snow"),
    THUNDER("thunder");

    private static final Map<String, Weather> VALUES;
    public static final Codec<Weather> CODEC;
    private final String name;

    private Weather(String name) {
        this.name = name;
    }

    public static Weather fromString(String name) {
        return Objects.requireNonNull(VALUES.get(name));
    }

    public String toString() {
        return this.name;
    }

    static {
        CODEC = Codec.STRING.xmap(Weather::fromString, Weather::toString);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Weather value : Weather.values()) {
            builder.put((Object)value.name, (Object)value);
        }
        VALUES = builder.build();
    }
}

